import { ChangeDetectorRef } from '@angular/core';
import { EditorService } from './editor.service';
import { TreeOperationAPI } from './tree-operation-api';
import { IActionMapping } from '@ali-hm/angular-tree-component';
import * as i0 from "@angular/core";
export declare class IdeComponent {
    private EditorService;
    private changeDetectorRef;
    treeData: any;
    openedFiles: Array<any>;
    treeOperationAPI: TreeOperationAPI;
    private editor;
    private tref;
    private tree;
    loadIde: boolean;
    editorOptions: any;
    editorLanguageMap: any;
    monacoEditor: any;
    monacoEditorLoaded: boolean;
    contextMenuClicked: boolean;
    contextMenuPosition: {
        x: number;
        y: number;
    };
    nodeCMItems: ({
        label: string;
        name: string;
        click: () => void;
    } | {
        label: string;
        name: string;
        click?: undefined;
    })[];
    rootNodeCMItems: {
        label: string;
        name: string;
        click: () => void;
    }[];
    groupNodeCMItems: {
        label: string;
        name: string;
        click: () => void;
    }[];
    contextMeuClickMap: any;
    collapsed: boolean;
    selectedNode: any;
    actionMapping: IActionMapping;
    treeOptions: any;
    constructor(EditorService: EditorService, changeDetectorRef: ChangeDetectorRef);
    ngOnInit(): void;
    ngOnDestroy(): void;
    loadEditor(): void;
    getMenuOption(nodeData: any): any;
    menuClickOut: () => void;
    onOpenContextMenu(node: any, event: any): void;
    inputFileKeyUp(newValue: string, node: any): void;
    inputFocusOut(newValue: string, node: any): void;
    autoFocusInput(): void;
    onOpenNode(node: any, event: any): void;
    onAddNode(node?: any): void;
    addNode(newValue: string, node: any): void;
    onRenameNode(this: any): void;
    renameNode(newValue: string, node: any): void;
    deleteNode(): void;
    onAddGroupNode(node?: any): void;
    addGroupNode(newValue: string, node: any): void;
    deleteGroupNode(): void;
    detectContentChange(file: any): void;
    loadSelectedTab(file: any): void;
    setSelectedTab(file: any): void;
    closeFile(index: number): void;
    updateOpenedFiles(identifier: string, data: any): void;
    removeOpenedFile(identifier: string): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<IdeComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<IdeComponent, "xf-ide", never, { "treeData": { "alias": "treeData"; "required": false; }; "openedFiles": { "alias": "openedFiles"; "required": false; }; "treeOperationAPI": { "alias": "treeOperationAPI"; "required": false; }; }, {}, never, never, true, never>;
}
