import { ChangeDetectorRef, OnInit } from '@angular/core';
import { AbstractControl, ControlValueAccessor, ValidationErrors, Validator } from '@angular/forms';
import { TimezoneService, TimezoneUTC } from '../../../core/services/timezone.service';
import { SearchableItem } from '../../searchable-dropdown/searchable-item';
import { SearchableDropdownComponent } from '../../searchable-dropdown/searchable-dropdown.component';
import * as i0 from "@angular/core";
export declare class TimezoneSelectComponent implements OnInit, ControlValueAccessor, Validator {
    private timezoneService;
    private changeDetectorRef;
    timezoneList: TimezoneUTC[];
    items: SearchableItem[];
    filteredItems: SearchableItem[];
    selectedValue: SearchableItem | null;
    selectedTimezone: TimezoneUTC | null;
    searchableDropdownComponent: SearchableDropdownComponent;
    onChange: (_: any) => void;
    onTouched: () => void;
    touched: boolean;
    disabled: boolean;
    constructor(timezoneService: TimezoneService, changeDetectorRef: ChangeDetectorRef);
    valueChange(value: any): void;
    ngOnInit(): void;
    selectSearchableItem(): void;
    loadItems(search: string): void;
    writeValue(value: any): void;
    registerOnChange(fn: (value: string) => void): void;
    registerOnTouched(fn: () => void): void;
    markAsTouched(): void;
    focus(): void;
    get valid(): boolean;
    setDisabledState(disabled: boolean): void;
    validate(control: AbstractControl): ValidationErrors | null;
    static ɵfac: i0.ɵɵFactoryDeclaration<TimezoneSelectComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<TimezoneSelectComponent, "xf-timezone-select", never, {}, {}, never, never, false, never>;
}
