import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { Agent } from '../models/agent';
import { Connector } from '../models/connector';
import { ConnectorConfiguration } from '../models/connector-configuration';
import { ConnectorOperation } from '../models/connector-operation';
import { UtilityService } from './utility.service';
import * as i0 from "@angular/core";
export declare class ConnectorService {
    private http;
    private utilityService;
    cache: Record<string, any>;
    constructor(http: HttpClient, utilityService: UtilityService);
    getConnector(name: string, version: string, agent?: string, ignoreErrors?: boolean): Observable<Connector>;
    updateConnector(id: number, data?: any): Observable<Connector>;
    deleteConnector(id: number): Observable<Object>;
    createConnectorConfig(data: any): Observable<ConnectorConfiguration>;
    updateConnectorConfig(id: number, data: any): Observable<ConnectorConfiguration>;
    deleteConnectorConfig(id: number): Observable<Object>;
    getDevelopmentConnector(id: number): Observable<Connector>;
    createDevelopmentConnector(data?: any): Observable<Connector>;
    getConnectorFile(id: number): Observable<Object>;
    getConnectorFileContent(id: number, filepath: string): Observable<Object>;
    createConnectorFile(id: number, data: any): Observable<Object>;
    updateConnectorFile(id: number, data: any): Observable<Object>;
    deleteConnectorFile(id: number, data: any): Observable<Object>;
    createConnectorFolder(id: number, data: any): Observable<any>;
    deleteConnectorFolder(id: number, data: any): Observable<Object>;
    getConnectorHealth(connector: Connector, config_id: string, agent: string): Observable<Object>;
    getConnectorOutputSchema(connectorName: string, connectorVersion: string, operation: string, config: any, params: any, agent?: string): Observable<any>;
    executeConnectorAction(connector: Connector, operation: ConnectorOperation, configuration: ConnectorConfiguration, params?: any, audit?: any, auditInfo?: any, agent?: string): Observable<Object>;
    exportDevelopedConnector(id: number): Observable<ArrayBuffer>;
    getDependencyStatus(connector: {
        name: string;
        version: string;
    }): Observable<any>;
    getFieldData(data: any): Observable<ArrayBuffer>;
    filterConnectorOperations(operation: any, installed?: any): any;
    getDevelopedConnector(id: any): Observable<Object>;
    getConnectorTemplates(data: any): Observable<Object>;
    createConnector(connectorConfig: any): Observable<Object>;
    loadConnectors(params?: Record<string, any>): Observable<Connector[]>;
    getAgents(connector: Connector, installed?: boolean): Observable<Agent[]>;
    getConfiguredAgents(): Observable<any>;
    installConnectorOnAgents(name: string, version: string, queryParams?: Record<string, any>, payload?: Record<string, any>): Observable<Object>;
    getConnectorConfigurations(name: string, version: string, queryparams?: Record<string, any>): Observable<Object>;
    getConfigurationDetail(uuid: string): Observable<Object>;
    getConfigId(configurations: ConnectorConfiguration[], configId: string): {
        config_id: string;
        isJinja: boolean;
    };
    static ɵfac: i0.ɵɵFactoryDeclaration<ConnectorService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ConnectorService>;
}
