import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { EntityService } from './entity.service';
import { GetEndPathNamePipe } from '../../utility/pipes/get-end-path-name.pipe';
import * as i0 from "@angular/core";
export declare class ExportService {
    private getEndPathNamePipe;
    private http;
    private entityService;
    constructor(getEndPathNamePipe: GetEndPathNamePipe, http: HttpClient, entityService: EntityService);
    /**
      * @ngdoc method
      * @name xf-ui#exportService#loadRowsForExport
      * @methodOf exportService
      *
      * @description
      * Loads exported versions of the given rows from CH.
      *
      * @param {array} rows An array of entity objects to export. Each object must have '@id' key.
      * @param {string} entityType The name of the entity (workflow).
      * @returns {Promise} Promise that will resolve with the exported hydra response
      **/
    loadRowsForExport(rows: any[], entityType: string, selectedFields: string[], skipExportFlag?: boolean, includeVersions?: boolean, childEntityName?: string): Observable<any>;
    static ɵfac: i0.ɵɵFactoryDeclaration<ExportService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ExportService>;
}
