import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { PicklistService } from '../../form-fields/field-renderers/built-ins/picklist/picklist.service';
import { Query } from '../../query-filters/models/query';
import { ModelMetadataService } from './model-metadata.service';
import { SystemSettingsService } from './system-settings.service';
import { SubscriptionQueueService } from './subscription-queue.service';
import { GetEndPathNamePipe } from '../../utility/pipes/get-end-path-name.pipe';
import { InterpolatePipe } from '../../utility/pipes/interpolate.pipe';
import * as i0 from "@angular/core";
export declare class FilterCollectionService {
    private subscriptionService;
    private http;
    private getEndPathNamePipe;
    private picklistService;
    private modelMetadatasService;
    private interpolate;
    private settingsService;
    constructor(subscriptionService: SubscriptionQueueService, http: HttpClient, getEndPathNamePipe: GetEndPathNamePipe, picklistService: PicklistService, modelMetadatasService: ModelMetadataService, interpolate: InterpolatePipe, settingsService: SystemSettingsService);
    load(type: string): any;
    saveUserQuery(query: queryFilter): Observable<any>;
    saveSystemQuery(query: queryFilter): Observable<any>;
    save(query: queryFilter, queryType: string): Observable<any>;
    deleteQuery(query: queryFilter): Observable<Object>;
    loadQueryFilterValues(query: queryFilter): Observable<any>;
    _loadResource(iri: string): any;
    static ɵfac: i0.ɵɵFactoryDeclaration<FilterCollectionService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<FilterCollectionService>;
}
export interface queryFilter {
    name: string;
    models: any;
    query: Query;
    '@type'?: string;
    '@id'?: string;
}
