import * as i0 from "@angular/core";
export declare class StorageService {
    constructor();
    /**
     *
     * @param {string} key The key of Storage Entry
     * @param {any} value The value to store
     * @param {boolean} persist Flag to define the key existance post session timeout
     */
    setItem(key: string, value: any, persist?: boolean): void;
    /**
     * Clean up all non-persisted storage entries post user session timeout.
     */
    clearAll(): void;
    /**
     * Retrive the storage entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     * @returns {any} the value
     */
    getItem(key: string, persist?: boolean): any;
    /**
     * Remove the specified storage entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     */
    removeItem(key: string, persist?: boolean): void;
    /**
     * Build the key string of the storgae entry
     * @param {string} key The key of Storage Entry
     * @param {boolean} persist Flag to define the key existance post session timeout
     * @returns {string} key string
     */
    _getStorageKey(key: string, persist?: boolean): string;
    static ɵfac: i0.ɵɵFactoryDeclaration<StorageService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<StorageService>;
}
