import { ActivatedRoute, Router, RouterState } from '@angular/router';
import { Subject } from 'rxjs';
import { BreadcrumbService } from 'xng-breadcrumb';
import { SearchableItem } from '../../components/searchable-dropdown/searchable-item';
import { Field } from '../models/field';
import * as i0 from "@angular/core";
export declare class UtilityService {
    private router;
    protected route: ActivatedRoute;
    private breadcrumbService;
    documentClickedTarget: Subject<Event>;
    navigationChanged: Subject<boolean>;
    permissionsChanged: Subject<boolean>;
    state: RouterState;
    constructor(router: Router, route: ActivatedRoute, breadcrumbService: BreadcrumbService);
    generateUUID(): string;
    setTitleAlias(alias: string, value: string, newPath?: string): void;
    isUndefined(value: any): boolean;
    convertHexToRgbA(value: string | null | undefined): string;
    setParametersInUrl(queryParams: any): void;
    appendNewParameterInUrl(newQueryParams: any): void;
    filterFields(fields: Field[], search: string, fieldsAlreadyAdded: string[]): import("rxjs").Observable<SearchableItem[]>;
    downloadFile(fileData: any, fileName: string, fileType: string): void;
    csvToJSON(CSVcontents: any): {
        columns: string[];
        data: any[];
    };
    newAttribute(): {
        isNew: boolean;
        ownsRelationship: boolean;
        visibility: boolean;
        writeable: boolean;
        editable: boolean;
        gridColumn: boolean;
        defaultValue: string;
        value: null;
        validation: {
            required: boolean;
            minlength: number;
        };
        name: string;
        title: string;
        descriptions: {
            singular: string;
        };
        formType: string;
        type: string;
    };
    convertToCamelCase(string: string): string;
    getBaseContextPath(): string;
    getIriApiPath(IRI: string): string;
    getOrigin(): string;
    prependIri(value: string): string;
    formatBytes(a: number, b?: number): string;
    getTimeInterval(toDateStr: string, fromDateStr: string, ms_time?: any): string;
    addJinjaBraces(value: string): string;
    removeJinjaBraces(value: string): string;
    getTimeAgo(fromDateStr: string, toDateStr?: string, ms_time?: any): string;
    typeOf(value: any): "any" | "number" | "string" | "boolean" | "list" | "dict";
    getFieldTypeByValue(value: any): string;
    getHigherVersionNumber(version1: string, version2: string): string;
    static ɵfac: i0.ɵɵFactoryDeclaration<UtilityService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<UtilityService>;
}
