import { ComponentRef, EventEmitter, OnInit, SimpleChanges } from '@angular/core';
import { ControlValueAccessor, FormControl, ValidationErrors, Validator } from '@angular/forms';
import { Field } from '../../../../core/models/field';
import { FieldOptions } from '../../../models/field-options';
import { AbstractFieldComponent } from '../abstract-field.component';
import { ViewContainerDirective } from '../../../../utility/directives/view-container.directive';
import * as i0 from "@angular/core";
export declare class FormFieldComponent implements OnInit, ControlValueAccessor, Validator {
    field: Field;
    autoFocus: boolean;
    fieldOptions: FieldOptions;
    fieldClass?: string;
    jinjaToggled: EventEmitter<boolean>;
    onSubmit: EventEmitter<void>;
    xfViewContainer: ViewContainerDirective;
    componentRef: ComponentRef<AbstractFieldComponent>;
    constructor();
    ngOnInit(): void;
    value: any;
    ngOnChanges(changes: SimpleChanges): void;
    writeValue(value: any): void;
    setDisabledState?(isDisabled: boolean): void;
    registerOnChange(fn: (value: string) => void): void;
    registerOnTouched(fn: () => void): void;
    validate(control: FormControl): ValidationErrors | null;
    get valid(): boolean;
    focus(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<FormFieldComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<FormFieldComponent, "xf-form-field", never, { "field": { "alias": "field"; "required": false; }; "autoFocus": { "alias": "autoFocus"; "required": false; }; "fieldOptions": { "alias": "fieldOptions"; "required": false; }; "fieldClass": { "alias": "fieldClass"; "required": false; }; }, { "jinjaToggled": "jinjaToggled"; "onSubmit": "onSubmit"; }, never, never, false, never>;
}
