import { ChangeDetectorRef, ComponentRef } from '@angular/core';
import { AbstractControl, ControlValueAccessor, FormBuilder, FormGroup, ValidationErrors, Validator } from '@angular/forms';
import { Entity } from '../../core/models/entity';
import { Field } from '../../core/models/field';
import { Filter } from '../models/filter';
import { FormFieldComponent } from '../../form-fields/field-renderers/built-ins/form-field/form-field.component';
import { FieldOptions } from '../../form-fields/models/field-options';
import { SearchableDropdownComponent } from '../../components/searchable-dropdown/searchable-dropdown.component';
import { SearchableItem } from '../../components/searchable-dropdown/searchable-item';
import { AbstractFieldComponent } from '../../form-fields/field-renderers/built-ins/abstract-field.component';
import { ViewContainerDirective } from '../../utility/directives/view-container.directive';
import { EntityService } from '../../core/services/entity.service';
import * as i0 from "@angular/core";
export declare class FilterComponent implements ControlValueAccessor, Validator {
    private changeDetectorRef;
    private entityService;
    private formBuilder;
    entity: Entity;
    isChild: boolean;
    subEntity?: Entity;
    items: SearchableItem[];
    fieldValue: SearchableItem | null;
    formGroup: FormGroup;
    fieldOptions: FieldOptions;
    value: Filter;
    field: Field | null;
    fieldRenderer: any | null;
    formField: FormFieldComponent;
    filterField: SearchableDropdownComponent;
    fieldSelect: SearchableDropdownComponent;
    xfViewContainer: ViewContainerDirective;
    componentRef: ComponentRef<AbstractFieldComponent>;
    onChange: (_: any) => void;
    onTouched: () => void;
    constructor(changeDetectorRef: ChangeDetectorRef, entityService: EntityService, formBuilder: FormBuilder);
    writeValue(value: Filter): void;
    registerOnChange(fn: (value: string) => void): void;
    registerOnTouched(fn: () => void): void;
    ngOnInit(): void;
    filterFields(search: string): void;
    setField(field: Field): void;
    fieldChanged(): void;
    operatorChanged(newOperatorId: string): void;
    private setRenderer;
    valueChanged(value: any): void;
    deleteFilter(): void;
    validate(control: AbstractControl): ValidationErrors | null;
    focusOnFirstInvalidInput(): boolean;
    static ɵfac: i0.ɵɵFactoryDeclaration<FilterComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<FilterComponent, "xf-filter", never, { "entity": { "alias": "entity"; "required": false; }; "isChild": { "alias": "isChild"; "required": false; }; }, {}, never, never, false, never>;
}
