import { Type } from "@angular/core";
import { AbstractEditViewLayout } from "../view-template/abstract-edit-view-layout.component";
import { AbstractLayoutItemComponent } from "../view-template/layout-item/abstract-layout-item.component";
import { WidgetConfig } from "./widget-config";
export declare class ViewLayoutItem {
    type: ViewLayoutItem.Types;
    component?: Type<AbstractLayoutItemComponent>;
    editComponent?: Type<AbstractEditViewLayout>;
    contents: any;
    id: string;
    constructor(type: ViewLayoutItem.Types);
}
export declare namespace ViewLayoutItem {
    class Container extends ViewLayoutItem {
        contents: Array<ViewLayoutItem>;
        id: string;
        constructor(contents: ViewLayoutItem[]);
    }
    class Tabs extends ViewLayoutItem {
        contents: Tab[];
        constructor(contents: Tab[]);
    }
    class Tab extends ViewLayoutItem {
        contents: ViewLayoutItem[];
        name: string;
        constructor(name: string, contents: ViewLayoutItem[]);
    }
    class Widget extends ViewLayoutItem {
        config: string | WidgetConfig;
        count: number;
        rows: number;
        constructor(config: string | WidgetConfig);
    }
    enum Types {
        WIDGET = "widget",
        TABS = "tabs",
        TAB = "tab",
        CONTAINER = "container"
    }
}
