import { ChangeDetectorRef, EventEmitter, SimpleChanges } from '@angular/core';
import { FormGroupDirective } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { Subscription } from 'rxjs';
import { Button, ModalService, SpinnerService } from "shared";
import { ViewTemplateService } from '../view-template.service';
import { ViewTemplateContext } from '../../models/view-template-context';
import { ViewTemplate } from '../../models/view-template';
import * as i0 from "@angular/core";
export declare class ViewTemplateHeaderComponent {
    private rootFormGroup;
    private changeDetectorRef;
    private router;
    private route;
    private viewTemplateService;
    private systemViewTemplateService;
    private modalService;
    private spinnerService;
    mode: string | null;
    uuid: string | null;
    showBreadcrumbs: boolean;
    context: ViewTemplateContext;
    viewTemplate: ViewTemplate | null;
    viewTemplates: ViewTemplate[];
    recordId: string;
    actions: any;
    buttons: Button[];
    allowEdit: boolean;
    loadViews: EventEmitter<void>;
    selectedViewUuid?: any;
    currentModule?: string | null | undefined;
    backLink: string;
    subscription?: Subscription;
    params: any;
    constructor(rootFormGroup: FormGroupDirective, changeDetectorRef: ChangeDetectorRef, router: Router, route: ActivatedRoute, viewTemplateService: ViewTemplateService, systemViewTemplateService: ViewTemplateService, modalService: ModalService, spinnerService: SpinnerService);
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    navigateToView(uuid: string | null, mode: string): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ViewTemplateHeaderComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<ViewTemplateHeaderComponent, "xf-view-template-header", never, { "mode": { "alias": "mode"; "required": false; }; "uuid": { "alias": "uuid"; "required": false; }; "showBreadcrumbs": { "alias": "showBreadcrumbs"; "required": false; }; "context": { "alias": "context"; "required": false; }; "viewTemplate": { "alias": "viewTemplate"; "required": false; }; "viewTemplates": { "alias": "viewTemplates"; "required": false; }; "recordId": { "alias": "recordId"; "required": false; }; "actions": { "alias": "actions"; "required": false; }; "buttons": { "alias": "buttons"; "required": false; }; "allowEdit": { "alias": "allowEdit"; "required": false; }; }, { "loadViews": "loadViews"; }, never, never, false, never>;
}
export declare enum ViewTemplateHeaderActions {
    NEW = "new",
    SAVE = "save",
    EDIT = "edit",
    DUPLICATE = "duplicate",
    DELETE = "delete",
    CANCEL = "cancel"
}
