import { HttpClient } from '@angular/common/http';
import { ActivatedRoute, Router } from '@angular/router';
import { Observable, Subject } from 'rxjs';
import { UtilityService } from "shared";
import { ViewLayoutItem } from '../models/view-layout-item';
import { ViewTemplate } from '../models/view-template';
import { ApiService, Entity } from "shared";
import * as i0 from "@angular/core";
export declare class ViewTemplateService {
    private http;
    private router;
    private apiService;
    private utilityService;
    widgetLibraryChanged: Subject<boolean>;
    currentUrl?: string;
    viewTemplateEntity: Entity;
    widgetConfigEntity: Entity;
    constructor(http: HttpClient, router: Router, apiService: ApiService, utilityService: UtilityService);
    loadByUuid(uuid: string, includeWidgetConfigs?: boolean): Observable<any>;
    loadWithParams(filters: any): Observable<any>;
    delete(uuid: string): Observable<{}>;
    save(viewTemplate: ViewTemplate): Observable<ViewTemplate>;
    private getNewWidgetConfigs;
    navigateToView(params: any, currentRoute: ActivatedRoute): void;
    duplicate(uuid: string): Observable<ViewTemplate>;
    updateLayoutWidgetUuids(viewLayoutItem: ViewLayoutItem, uuidMap: {
        [oldUuid: string]: string;
    }): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<ViewTemplateService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<ViewTemplateService>;
}
