import { HttpClient } from '@angular/common/http';
import { ChangeDetectorRef, ComponentRef, EventEmitter, OnChanges, SimpleChanges, ViewContainerRef } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { DndDraggableDirective, DndHandleDirective } from 'ngx-drag-drop';
import { Observable, Subject, Subscription } from 'rxjs';
import { ApiService, DataProviderService, EmbedService, EntityChange, EntityService, PermissionService } from "shared";
import { AbstractWidgetComponent } from '../abstract-widget.component';
import { WidgetService } from '../widget.service';
import { ViewTemplateContext } from '../../models/view-template-context';
import { WidgetConfig } from '../../models/widget-config';
import { Widget } from '../../models/widget';
import * as i0 from "@angular/core";
export declare class WidgetComponent implements OnChanges {
    private widgetService;
    private http;
    private dataProvider;
    private ngbModalService;
    private permissionService;
    private changeDetectorRef;
    private entityService;
    private apiService;
    private parentDraggable;
    private embedService;
    config: string | WidgetConfig;
    widgetData: any;
    context: ViewTemplateContext;
    edit: EventEmitter<WidgetConfig>;
    clone: EventEmitter<WidgetConfig>;
    delete: EventEmitter<WidgetConfig>;
    mode: string | null;
    widgetClass?: string;
    showLayoutControls: boolean;
    updateHeight: Subject<any>;
    widgetId: string;
    widgetConfig?: WidgetConfig;
    showMenu: boolean;
    viewContainer: ViewContainerRef;
    componentRef: ComponentRef<AbstractWidgetComponent>;
    widget?: Widget;
    widgetPermission: string[];
    logExpanded: boolean;
    buildLogHtml: string;
    reloadRequired: boolean;
    subscription?: Subscription;
    dndHandle: DndHandleDirective;
    constructor(widgetService: WidgetService, http: HttpClient, dataProvider: DataProviderService, ngbModalService: NgbModal, permissionService: PermissionService, changeDetectorRef: ChangeDetectorRef, entityService: EntityService, apiService: ApiService, parentDraggable: DndDraggableDirective, embedService: EmbedService);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    createWidgetComponent(widgetConfig: WidgetConfig): void;
    watchMetadataChanges(widgetUuid: string): Observable<EntityChange>;
    getConfig(configUuid: string): Observable<any>;
    setConfig(): Observable<void>;
    setBuildLogHtml(): void;
    ngOnDestroy(): void;
    openEditModal(): void;
    reload(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<WidgetComponent, [null, null, null, null, null, null, null, null, { optional: true; }, null]>;
    static ɵcmp: i0.ɵɵComponentDeclaration<WidgetComponent, "xf-widget", never, { "config": { "alias": "config"; "required": false; }; "widgetData": { "alias": "widgetData"; "required": false; }; "context": { "alias": "context"; "required": false; }; "mode": { "alias": "mode"; "required": false; }; "widgetClass": { "alias": "widgetClass"; "required": false; }; "showLayoutControls": { "alias": "showLayoutControls"; "required": false; }; "updateHeight": { "alias": "updateHeight"; "required": false; }; "widgetId": { "alias": "widgetId"; "required": false; }; }, { "edit": "edit"; "clone": "clone"; "delete": "delete"; }, never, never, false, never>;
}
