import { DatePipe } from '@angular/common';
import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output, ViewChild, inject } from '@angular/core';
import { TranslocoService } from '@jsverse/transloco';
import { AgGridAngular } from 'ag-grid-angular';
import { difference, merge } from 'lodash-es';
import { ToastrService } from 'ngx-toastr';
import { catchError, concatMap, forkJoin, isObservable, of } from 'rxjs';
import { ApiService, DEFAULT_CACHE_BLOCK_SIZE, DEFAULT_GRID_ROWS, ModalService, Query } from "shared";
import { GridColumnService } from './services/grid-column.service';
import { GridReferenceService } from './services/grid-reference.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common";
import * as i3 from "ag-grid-angular";
import * as i4 from "./custom-grid-header/custom-grid-header.component";
const _c0 = a0 => ({ "custom-grid-header": a0 });
const _c1 = () => [];
function GridComponent_div_0_lib_custom_grid_header_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "lib-custom-grid-header", 7);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("component", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent)("componentData$", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderData$);
} }
function GridComponent_div_0_div_3_ng_container_1_xf_button_group_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-button-group", 13);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("buttons", (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons) || i0.ɵɵpureFunction0(1, _c1));
} }
function GridComponent_div_0_div_3_ng_container_1_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "button", 10);
    i0.ɵɵlistener("click", function GridComponent_div_0_div_3_ng_container_1_Template_button_click_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r1.refresh()); });
    i0.ɵɵelement(2, "i", 11);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(3, GridComponent_div_0_div_3_ng_container_1_xf_button_group_3_Template, 1, 2, "xf-button-group", 12);
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons) && (ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.buttons == null ? null : ctx_r1.gridConfig.options.buttons.length));
} }
function GridComponent_div_0_div_3_ng_template_2_xf_button_group_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-button-group", 13);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(4);
    i0.ɵɵproperty("buttons", ctx_r1.selectButtons || i0.ɵɵpureFunction0(1, _c1));
} }
function GridComponent_div_0_div_3_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, GridComponent_div_0_div_3_ng_template_2_xf_button_group_0_Template, 1, 2, "xf-button-group", 12);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵproperty("ngIf", ctx_r1.selectButtons == null ? null : ctx_r1.selectButtons.length);
} }
function GridComponent_div_0_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 8);
    i0.ɵɵtemplate(1, GridComponent_div_0_div_3_ng_container_1_Template, 4, 1, "ng-container", 9)(2, GridComponent_div_0_div_3_ng_template_2_Template, 1, 1, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const recordSelection_r4 = i0.ɵɵreference(3);
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.selectedRows.length === 0)("ngIfElse", recordSelection_r4);
} }
function GridComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 2)(1, "div", 3);
    i0.ɵɵtemplate(2, GridComponent_div_0_lib_custom_grid_header_2_Template, 1, 2, "lib-custom-grid-header", 4)(3, GridComponent_div_0_div_3_Template, 4, 2, "div", 5);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(4, "ag-grid-angular", 6);
    i0.ɵɵlistener("gridReady", function GridComponent_div_0_Template_ag_grid_angular_gridReady_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onGridReady($event)); })("firstDataRendered", function GridComponent_div_0_Template_ag_grid_angular_firstDataRendered_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onFirstDataRendered($event)); })("gridSizeChanged", function GridComponent_div_0_Template_ag_grid_angular_gridSizeChanged_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onGridSizeChanged($event)); })("rowDataUpdated", function GridComponent_div_0_Template_ag_grid_angular_rowDataUpdated_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.onRowDataUpdated($event)); });
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(13, _c0, ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent));
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.customGridHeaderComponent);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.gridConfig.options == null ? null : ctx_r1.gridConfig.options.enableSelectMenu);
    i0.ɵɵadvance();
    i0.ɵɵclassMapInterpolate1("w-100 ", ctx_r1.gridClass, "");
    i0.ɵɵproperty("columnDefs", ctx_r1.columnDefs)("gridOptions", ctx_r1.gridOptions)("serverSideDatasource", ctx_r1.dataSource)("selectionColumnDef", ctx_r1.selectionColumnDef)("animateRows", true)("suppressContextMenu", ctx_r1.suppressContextMenu)("overlayNoRowsTemplate", ctx_r1.noRowsTemplate);
} }
export class GridComponent {
    constructor(themeService, changeDetectorRef) {
        this.themeService = themeService;
        this.changeDetectorRef = changeDetectorRef;
        this.customColumnDefs = [];
        this.suppressContextMenu = false;
        this.rowSelectionChanged = new EventEmitter();
        this.gridQuery = new Query();
        this.gridColumnService = inject(GridColumnService);
        this.gridReferenceService = inject(GridReferenceService);
        this.modalService = inject(ModalService);
        this.apiService = inject(ApiService);
        this.toasterService = inject(ToastrService);
        this.translocoService = inject(TranslocoService);
        this.datePipe = inject(DatePipe);
        this.contextId = '';
        this.gridClass = 'ag-theme-alpine';
        this.selectedRows = [];
        this.selectButtons = [];
        this.selectionColumnDef = {
            suppressHeaderMenuButton: false,
            pinned: 'left',
        };
        this.columnDefs = [];
        this.currentRowHeight = 0;
        this.minRowHeight = 0;
        this.noRowsTemplate = '';
    }
    onGridReady(params) {
        this.contextId = this.gridConfig.uuid || this.dataSource.entity.type;
        this.gridApi = params.api;
        if (this.gridConfig.options?.onRegisterApi) {
            this.gridConfig.options?.onRegisterApi(this.gridApi);
        }
        this.minRowHeight = params.api.getSizesForCurrentTheme().rowHeight;
        this.currentRowHeight = this.minRowHeight;
        window.onresize = () => {
            this.gridApi.sizeColumnsToFit();
        };
        this.dataSource.selectedRows.forEach((uuid) => {
            const rowNode = this.gridApi.getRowNode(uuid);
            rowNode?.setSelected(true);
        });
        this.gridReferenceService.refresh$.subscribe(() => {
            this.refresh();
        });
    }
    onFirstDataRendered(params) {
        this.updateGridRowsHeight(params);
    }
    onGridSizeChanged(params) {
        this.updateGridRowsHeight(params);
    }
    onRowDataUpdated(params) {
        this.updateGridRowsHeight(params);
    }
    updateGridRowsHeight(params) {
        //Calculate the height of the grid and available parent height to fit all the grid rows scrollable
        if (this.gridConfig.options?.adjustGridRowHeight) {
            let pagingPanel = document.querySelector('.ag-paging-panel');
            let headerPanel = document.querySelector('.ag-header');
            let gridWrapper = document.querySelector('.grid-wrapper');
            let gridActionsContainer = document.querySelector('.grid-actions-container');
            let customGridHeight = 15; //Adjust the extra height
            if (!pagingPanel || !headerPanel || !gridWrapper || !gridActionsContainer) {
                return;
            }
            let gridHeight = gridWrapper.clientHeight - (gridActionsContainer.clientHeight + customGridHeight + pagingPanel.clientHeight + headerPanel.clientHeight);
            let renderedRowCount = params.api.getDisplayedRowCount();
            if (renderedRowCount * this.minRowHeight >= gridHeight) {
                document.querySelector('.ag-body')?.setAttribute('style', 'height:' + gridHeight + 'px');
            }
            else {
                document.querySelector('.ag-body')?.setAttribute('style', 'height:' + (renderedRowCount * this.minRowHeight) + 'px');
            }
        }
    }
    ngOnInit() {
        this.columnDefs = this.gridColumnService.create(this.dataSource.entity?.fields, this.gridConfig.configuration.query, this.gridConfig.configuration.columns, false, this.customColumnDefs, this.dataSource.entity.defaultSort);
        this.columnDefs = this.columnDefs.map((colDef) => {
            if (colDef.field === this.gridConfig.configuration.nameColumn) {
                colDef.pinned = 'left';
                colDef.suppressMovable = true;
                colDef.lockPosition = true;
                colDef.lockVisible = true;
            }
            return colDef;
        });
        this.gridOptions = this.mapGridOptions();
        let selectButtons = [];
        if (this.gridConfig.options?.selectButtons?.length) {
            selectButtons = this.gridConfig.options.selectButtons;
        }
        if (this.gridConfig.options?.allowDelete) {
            let deleteButton = this.createDeleteButton();
            selectButtons.push(deleteButton);
        }
        this.selectButtons = selectButtons;
        this.setTheme(this.themeService.getTheme());
        this.themeService.themeChanged.subscribe((theme) => this.setTheme(theme));
        this.noRowsTemplate = `<span>${this.translocoService.translate('errors.error_no_records')}</span>`;
    }
    createDeleteButton() {
        return {
            id: 'delete',
            text: '',
            tooltip: 'Delete',
            iconClass: 'fa fa-trash-can fa-light',
            onClick: () => { this.deleteSelected(); },
            class: 'btn btn-secondary',
            visible: true
        };
    }
    deleteSelected() {
        let entityName = this.selectedRows.length > 1 ? this.dataSource.entity.descriptions.plural : this.dataSource.entity.descriptions.singular;
        this.modalService.confirm(this.translocoService.translate('components.grid.deleteMessage', {
            entityName: `${this.dataSource.entity.descriptions.singular}(s)`
        })).pipe(concatMap((result) => {
            if (!result) {
                return of();
            }
            let uuids = this.selectedRows.map((row) => row.uuid);
            let observables$ = [];
            uuids.forEach((uuid) => {
                observables$.push(this.apiService.deleteRecord(this.dataSource.entity, uuid).pipe(catchError((error) => {
                    return of(error.error?.errors[0]?.detail);
                })));
            });
            return forkJoin(observables$);
        })).subscribe((responses) => {
            let successfulDeletions = responses.filter((error) => error === null).length;
            const deletionErrors = responses.length - successfulDeletions;
            if (deletionErrors > 0) {
                this.toasterService.warning(this.translocoService.translate('components.grid.partialDeletedToast', {
                    successful: successfulDeletions,
                    errors: deletionErrors,
                    length: this.selectedRows.length,
                    entityName: entityName
                }));
            }
            else {
                this.toasterService.success(this.translocoService.translate('components.grid.deletedToast', {
                    length: this.selectedRows.length, entityName: entityName
                }), 'Success');
            }
            this.gridApi.deselectAll();
            this.selectedRows = [];
            this.rowSelectionChanged.emit(this.selectedRows);
            this.refresh();
        });
    }
    setTheme(theme) {
        this.gridClass = theme === 'dark' ? 'ag-theme-alpine-dark' : 'ag-theme-alpine';
        this.changeDetectorRef.detectChanges();
    }
    mapGridOptions() {
        let columnTypes = this.gridColumnService.getDefaultColumnTypes();
        columnTypes = merge(columnTypes, this.gridConfig.options?.customColumnTypes || {});
        let dataTypeDefinitions = this.gridColumnService.getDefaultDataTypeDefinitions();
        dataTypeDefinitions = merge(dataTypeDefinitions, this.gridConfig.options?.customDataTypeDefinitions || {});
        let processCellCallback = (params) => this.processCellCallback(params);
        let gridOptions = {
            defaultColDef: this.gridColumnService.getDefaultColumnDef(),
            processCellForClipboard: processCellCallback,
            defaultCsvExportParams: {
                processCellCallback: processCellCallback,
            },
            defaultExcelExportParams: {
                processCellCallback: processCellCallback,
            },
            onCellClicked: (event) => {
                if (this.gridConfig.options?.onView && !event.colDef.cellRendererParams?.suppressCellClick) {
                    this.gridConfig.options.onView(event);
                }
            },
            onSelectionChanged: (event) => {
                const selectionState = event.api.getServerSideSelectionState();
                let uuids = [];
                if (selectionState.selectAll) {
                    const allNodes = event.api.getRenderedNodes().map((node) => node.data.uuid) || [];
                    uuids = difference(allNodes, selectionState.toggledNodes);
                }
                else {
                    uuids = selectionState.toggledNodes || [];
                }
                this.selectedRows = event.api.getRenderedNodes().filter((node) => uuids.indexOf(node.data.uuid) > -1).map((node) => node.data);
                this.rowSelectionChanged.emit(this.selectedRows);
                this.changeDetectorRef.detectChanges();
            },
            onDisplayedColumnsChanged: (event) => {
                event.api.refreshServerSide();
                event.api.sizeColumnsToFit();
            },
            rowSelection: {
                mode: 'multiRow',
                enableClickSelection: false,
                headerCheckbox: !this.gridConfig.options?.hideCheckboxes,
                checkboxes: !this.gridConfig.options?.hideCheckboxes,
                hideDisabledCheckboxes: true,
            },
            suppressCellFocus: true,
            suppressMenuHide: false,
            columnMenu: 'new',
            pagination: true,
            paginationPageSize: DEFAULT_GRID_ROWS,
            cacheBlockSize: DEFAULT_CACHE_BLOCK_SIZE,
            enableCellTextSelection: this.gridConfig.options?.enableCellTextSelection,
            columnTypes: columnTypes,
            dataTypeDefinitions: dataTypeDefinitions,
            paginationPageSizeSelector: [10, 20, 50, 100, 250],
            suppressServerSideFullWidthLoadingRow: true
        };
        if (this.gridConfig.options?.expandable) {
            gridOptions.masterDetail = true;
            gridOptions.detailCellRenderer = this.gridConfig.options?.detailCellRenderer;
        }
        if (!this.gridConfig.options?.skipRowId) {
            gridOptions.getRowId = (params) => params.data.uuid;
        }
        gridOptions.treeData = this.gridConfig.options?.treeData;
        gridOptions.isServerSideGroup = this.gridConfig.options?.isServerSideGroup;
        gridOptions.getServerSideGroupKey = this.gridConfig.options?.getServerSideGroupKey;
        gridOptions.autoGroupColumnDef = this.gridConfig.options?.autoGroupColumnDef;
        return gridOptions;
    }
    refresh() {
        this.gridApi.refreshServerSide({ route: [], purge: true });
    }
    processCellCallback(params) {
        if (isObservable(params.value)) {
            return getStoredResolvedObservableValue(params.value) || '';
        }
        return params.value;
    }
    static { this.ɵfac = function GridComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridComponent)(i0.ɵɵdirectiveInject(i1.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridComponent, selectors: [["xf-grid"]], viewQuery: function GridComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(AgGridAngular, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.agGrid = _t.first);
        } }, inputs: { dataSource: "dataSource", gridConfig: "gridConfig", customColumnDefs: "customColumnDefs", suppressContextMenu: "suppressContextMenu" }, outputs: { rowSelectionChanged: "rowSelectionChanged" }, features: [i0.ɵɵProvidersFeature([])], decls: 1, vars: 1, consts: [["recordSelection", ""], ["class", "grid-wrapper bg-secondary-panel h-100", 4, "ngIf"], [1, "grid-wrapper", "bg-secondary-panel", "h-100"], [1, "d-flex", "padding-top-16px", "grid-actions-container", "margin-bottom-4px", 3, "ngClass"], [3, "component", "componentData$", 4, "ngIf"], ["class", "grid-actions margin-right-16px ms-auto", 4, "ngIf"], ["rowModelType", "serverSide", 3, "gridReady", "firstDataRendered", "gridSizeChanged", "rowDataUpdated", "columnDefs", "gridOptions", "serverSideDatasource", "selectionColumnDef", "animateRows", "suppressContextMenu", "overlayNoRowsTemplate"], [3, "component", "componentData$"], [1, "grid-actions", "margin-right-16px", "ms-auto"], [4, "ngIf", "ngIfElse"], [1, "btn", "btn-sm", "btn-secondary", "mx-2", "float-end", 3, "click"], [1, "fa", "fa-refresh"], [3, "buttons", 4, "ngIf"], [3, "buttons"]], template: function GridComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, GridComponent_div_0_Template, 5, 15, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.columnDefs && ctx.gridOptions && ctx.dataSource);
        } }, dependencies: [i2.NgClass, i2.NgIf, i1.ButtonGroupComponent, i3.AgGridAngular, i4.CustomGridHeaderComponent], styles: [".grid-expandable-wrapper[_ngcontent-%COMP%]{position:absolute;left:70px;right:0}.grid-wrapper[_ngcontent-%COMP%]   .grid-actions[_ngcontent-%COMP%]     .btn-secondary{background-color:var(--grid-actions-secondary-bg);color:var(--grid-actions-secondary-color);border:1px solid var(--grid-actions-secondary-border-color)!important}.grid-wrapper[_ngcontent-%COMP%]   .grid-actions[_ngcontent-%COMP%]     .btn-secondary:hover{border-color:var(--btn-secondary-border-color)}.grid-wrapper[_ngcontent-%COMP%]   .custom-grid-header[_ngcontent-%COMP%]{background:var(--custom-grid-header-bg);border:1px solid var(--collection-list-header-border);border-bottom:none}.grid-wrapper[_ngcontent-%COMP%]     .ag-root-wrapper .ag-root-wrapper-body{height:100%;min-height:100px}.grid-wrapper[_ngcontent-%COMP%]     .ag-root-wrapper .ag-paging-panel{border-top-color:var(--grid-border-color);background:var(--custom-grid-header-bg)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid', changeDetection: ChangeDetectionStrategy.OnPush, providers: [], template: "<div class=\"grid-wrapper bg-secondary-panel h-100\" *ngIf=\"columnDefs && gridOptions && dataSource\">\n  <div class=\"d-flex padding-top-16px grid-actions-container margin-bottom-4px\"\n    [ngClass]=\"{'custom-grid-header' : gridConfig.options?.customGridHeaderComponent}\">\n    <lib-custom-grid-header *ngIf=\"gridConfig.options?.customGridHeaderComponent\"\n      [component]=\"gridConfig.options?.customGridHeaderComponent\"\n      [componentData$]=\"gridConfig.options?.customGridHeaderData$\"></lib-custom-grid-header>\n    <div class=\"grid-actions margin-right-16px ms-auto\" *ngIf=\"gridConfig.options?.enableSelectMenu\">\n      <ng-container *ngIf=\"selectedRows.length === 0; else recordSelection\">\n        <button class=\"btn btn-sm btn-secondary mx-2 float-end\" (click)=\"refresh()\">\n          <i class=\"fa fa-refresh\"></i>\n        </button>\n        <xf-button-group *ngIf=\"gridConfig.options?.buttons && gridConfig.options?.buttons?.length\"\n          [buttons]=\"gridConfig.options?.buttons || []\"></xf-button-group>\n      </ng-container>\n      <ng-template #recordSelection>\n        <xf-button-group *ngIf=\"selectButtons?.length\" [buttons]=\"selectButtons || []\"></xf-button-group>\n      </ng-template>\n    </div>\n  </div>\n  <ag-grid-angular class=\"w-100 {{gridClass}}\" rowModelType=\"serverSide\" [columnDefs]=\"columnDefs\"\n    [gridOptions]=\"gridOptions\" [serverSideDatasource]=\"dataSource\" [selectionColumnDef]=\"selectionColumnDef\"\n    (gridReady)=\"onGridReady($event)\" [animateRows]=\"true\" [suppressContextMenu]=\"suppressContextMenu\"\n    (firstDataRendered)=\"onFirstDataRendered($event)\" (gridSizeChanged)=\"onGridSizeChanged($event)\"\n    (rowDataUpdated)=\"onRowDataUpdated($event)\" [overlayNoRowsTemplate]=\"noRowsTemplate\"></ag-grid-angular>\n</div>\n", styles: [".grid-expandable-wrapper{position:absolute;left:70px;right:0}.grid-wrapper .grid-actions ::ng-deep .btn-secondary{background-color:var(--grid-actions-secondary-bg);color:var(--grid-actions-secondary-color);border:1px solid var(--grid-actions-secondary-border-color)!important}.grid-wrapper .grid-actions ::ng-deep .btn-secondary:hover{border-color:var(--btn-secondary-border-color)}.grid-wrapper .custom-grid-header{background:var(--custom-grid-header-bg);border:1px solid var(--collection-list-header-border);border-bottom:none}.grid-wrapper ::ng-deep .ag-root-wrapper .ag-root-wrapper-body{height:100%;min-height:100px}.grid-wrapper ::ng-deep .ag-root-wrapper .ag-paging-panel{border-top-color:var(--grid-border-color);background:var(--custom-grid-header-bg)}\n"] }]
    }], () => [{ type: i1.ThemeService }, { type: i0.ChangeDetectorRef }], { agGrid: [{
            type: ViewChild,
            args: [AgGridAngular]
        }], dataSource: [{
            type: Input
        }], gridConfig: [{
            type: Input
        }], customColumnDefs: [{
            type: Input
        }], suppressContextMenu: [{
            type: Input
        }], rowSelectionChanged: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridComponent, { className: "GridComponent", filePath: "src/grid.component.ts", lineNumber: 23 }); })();
const valueByObservable = new WeakMap();
export function storeResolvedObservableValue(observable, value) {
    valueByObservable.set(observable, value);
}
export function getStoredResolvedObservableValue(observable) {
    return valueByObservable.get(observable);
}
//# sourceMappingURL=data:application/json;base64,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