import { ChangeDetectionStrategy, Component, forwardRef, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { findIndex, isUndefined } from 'lodash-es';
import { GridColumn } from '../../../services/grid-column.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "ngx-drag-drop";
const _c0 = ["entity", ""];
function GridColumnsEditorComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 5)(1, "div", 6)(2, "span", 7);
    i0.ɵɵelement(3, "i", 8);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "span", 9)(6, "span", 10)(7, "input", 11);
    i0.ɵɵlistener("change", function GridColumnsEditorComponent_div_1_Template_input_change_7_listener($event) { const column_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.changeEditable(column_r2, $event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(8, "i", 12);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "span", 13)(10, "input", 14);
    i0.ɵɵlistener("change", function GridColumnsEditorComponent_div_1_Template_input_change_10_listener($event) { const column_r2 = i0.ɵɵrestoreView(_r1).$implicit; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.changeResizable(column_r2, $event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(11, "i", 15);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(12, "i", 16);
    i0.ɵɵlistener("click", function GridColumnsEditorComponent_div_1_Template_i_click_12_listener() { const fieldIndex_r4 = i0.ɵɵrestoreView(_r1).index; const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.removeField(fieldIndex_r4)); });
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const column_r2 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("dndDraggable", column_r2);
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", ctx_r2.entity.fields[column_r2.name] ? ctx_r2.entity.fields[column_r2.name].title : column_r2.name, " ");
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("checked", column_r2.editable)("disabled", ctx_r2.entity.fields[column_r2.name] ? !ctx_r2.entity.fields[column_r2.name].writeable : false);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("checked", column_r2.resizable);
} }
export class GridColumnsEditorComponent {
    constructor(utilityService, changeDetectorRef) {
        this.utilityService = utilityService;
        this.changeDetectorRef = changeDetectorRef;
        this.value = [];
        this.items = [];
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.column = null;
    }
    writeValue(value) {
        this.value = value;
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    onDrop(event) {
        const foundIndex = findIndex(this.value, {
            name: event.data.name
        });
        if (foundIndex > -1) {
            let dragColumn = this.value[foundIndex];
            this.value.splice(foundIndex, 1);
            if (dragColumn) {
                this.value.splice(event.index, 0, dragColumn);
            }
        }
    }
    changeResizable(column, event) {
        column.resizable = event.target.checked;
    }
    changeEditable(column, event) {
        column.editable = event.target.checked;
    }
    addField(event) {
        if (event) {
            this.value = isUndefined(this.value) ? [] : this.value;
            this.value?.push(new GridColumn({
                name: event.value.name,
                editable: false,
                resizable: true,
                sticky: 'NONE'
            }));
        }
    }
    removeField(fieldIndex) {
        this.value.splice(fieldIndex, 1);
    }
    filterFields(search) {
        const fieldsAlreadyAdded = this.value?.map((field) => field.name) || [];
        const fields = this.entity?.getFormFields() || this.entity.attributes;
        this.utilityService.filterFields(fields, search, fieldsAlreadyAdded).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    static { this.ɵfac = function GridColumnsEditorComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridColumnsEditorComponent)(i0.ɵɵdirectiveInject(i1.UtilityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: GridColumnsEditorComponent, selectors: [["xf-grid-columns-editor", "entity", ""]], inputs: { entity: "entity" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => GridColumnsEditorComponent),
                    multi: true
                }])], attrs: _c0, decls: 5, vars: 5, consts: [["dndDropzone", "", "dndEffectAllowed", "copyMove", 1, "col", "pb-2", 3, "dndDrop", "dndHorizontal"], ["dndEffectAllowed", "move", "class", "card d-inline-block p-2 m-2", 3, "dndDraggable", 4, "ngFor", "ngForOf"], ["dndPlaceholderRef", "", 1, "card", "dnd-placeholder", "mt-2"], [1, "d-flex", "flex-row", "justify-content-left", "gap-2", "mt-2"], ["placeholder", "+ Add Column", 3, "ngModelChange", "searchQueryChange", "ngModel", "clearValueOnSelect", "items"], ["dndEffectAllowed", "move", 1, "card", "d-inline-block", "p-2", "m-2", 3, "dndDraggable"], [1, "card-title", "m-0", "d-flex"], [1, "flex-grow-1"], ["dndHandle", "", 1, "cursor-move", "fa", "fa-arrows-alt", "fa-light", "me-2"], [1, "ms-3"], [1, "me-2", "p-1", "border-grey"], ["type", "checkbox", 1, "me-2", 3, "change", "checked", "disabled"], ["role", "button", 1, "fa", "fa-light", "fa-edit", "margin-top-4px"], [1, "p-1", "border-grey"], ["type", "checkbox", 1, "me-2", 3, "change", "checked"], ["role", "button", 1, "fa", "fa-light", "fa-left-right", "margin-top-4px"], ["role", "button", 1, "fa", "fa-light", "fa-close", "margin-top-4px", "text-danger", "ms-3", 3, "click"]], template: function GridColumnsEditorComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵlistener("dndDrop", function GridColumnsEditorComponent_Template_div_dndDrop_0_listener($event) { return ctx.onDrop($event); });
            i0.ɵɵtemplate(1, GridColumnsEditorComponent_div_1_Template, 13, 5, "div", 1);
            i0.ɵɵelement(2, "div", 2);
            i0.ɵɵelementStart(3, "div", 3)(4, "xf-searchable-dropdown", 4);
            i0.ɵɵlistener("ngModelChange", function GridColumnsEditorComponent_Template_xf_searchable_dropdown_ngModelChange_4_listener($event) { return ctx.addField($event); })("searchQueryChange", function GridColumnsEditorComponent_Template_xf_searchable_dropdown_searchQueryChange_4_listener($event) { return ctx.filterFields($event); });
            i0.ɵɵelementEnd()()();
        } if (rf & 2) {
            i0.ɵɵproperty("dndHorizontal", true);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.value);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("ngModel", ctx.column)("clearValueOnSelect", true)("items", ctx.items);
        } }, dependencies: [i2.NgForOf, i3.NgControlStatus, i3.NgModel, i1.SearchableDropdownComponent, i4.DndDraggableDirective, i4.DndDropzoneDirective, i4.DndHandleDirective, i4.DndPlaceholderRefDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridColumnsEditorComponent, [{
        type: Component,
        args: [{ selector: 'xf-grid-columns-editor[entity]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => GridColumnsEditorComponent),
                        multi: true
                    }], template: "<div class=\"col pb-2\" dndDropzone [dndHorizontal]=\"true\" dndEffectAllowed=\"copyMove\" (dndDrop)=\"onDrop($event)\">\n  <div *ngFor=\"let column of value; let fieldIndex = index\" [dndDraggable]=\"column\" dndEffectAllowed=\"move\"\n    class=\"card d-inline-block p-2 m-2\">\n    <div class=\"card-title m-0 d-flex\">\n      <span class=\"flex-grow-1\">\n        <i class=\"cursor-move fa fa-arrows-alt fa-light me-2\" dndHandle></i>{{ entity!.fields[column.name] ?\n        entity!.fields[column.name].title : column.name }}\n      </span>\n      <span class=\"ms-3\">\n        <!-- editable options -->\n        <span class=\"me-2 p-1 border-grey\">\n          <input type=\"checkbox\" class=\"me-2\" [checked]=\"column.editable\" (change)=\"changeEditable(column, $event)\"\n            [disabled]=\"entity!.fields[column.name] ? !entity!.fields[column.name].writeable : false\">\n          <i class=\"fa fa-light fa-edit margin-top-4px\" role=\"button\"></i>\n        </span>\n        <span class=\"p-1 border-grey\">\n          <input type=\"checkbox\" class=\"me-2\" [checked]=\"column.resizable\" (change)=\"changeResizable(column, $event)\">\n          <i class=\"fa fa-light fa-left-right margin-top-4px\" role=\"button\"></i>\n        </span>\n\n        <i class=\"fa fa-light fa-close margin-top-4px text-danger ms-3\" role=\"button\"\n          (click)=\"removeField(fieldIndex)\"></i>\n      </span>\n    </div>\n\n  </div>\n  <div class=\"card dnd-placeholder mt-2\" dndPlaceholderRef></div>\n  <div class=\"d-flex flex-row justify-content-left gap-2 mt-2\">\n    <xf-searchable-dropdown (ngModelChange)=\"addField($event)\" [ngModel]=\"column\" [clearValueOnSelect]=\"true\"\n      [items]=\"items\" placeholder=\"+ Add Column\" (searchQueryChange)=\"filterFields($event)\">\n    </xf-searchable-dropdown>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1.UtilityService }, { type: i0.ChangeDetectorRef }], { entity: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(GridColumnsEditorComponent, { className: "GridColumnsEditorComponent", filePath: "src/widgets/grid-widget/grid-columns-editor/grid-columns-editor.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,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