import { Injectable } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import { isArray } from 'lodash-es';
import { throwError } from 'rxjs';
import { catchError, concatMap, map, toArray } from 'rxjs/operators';
import { VIEW_TEMPLATES } from "shared";
import { GridColumn } from '../../services/grid-column.service';
import * as i0 from "@angular/core";
import * as i1 from "shared";
import * as i2 from "@angular/common/http";
export class GridService {
    constructor(filterCollectionService, http) {
        this.filterCollectionService = filterCollectionService;
        this.http = http;
    }
    loadUserPreferenceColumns() {
        return this.http.get(`${VIEW_TEMPLATES.VIEW_API_BASE}${VIEW_TEMPLATES.GRID_COLUMNS}`).pipe(map((result) => {
            result.config = isArray(result.config) ? {} : result.config;
            return result;
        }, catchError((error) => {
            return throwError(error);
        })));
    }
    saveUserPreferences(page, template) {
        return this.http.post(`${VIEW_TEMPLATES.VIEW_API_BASE}${VIEW_TEMPLATES.GRID_COLUMNS}`, template).pipe(map((result) => {
            return result;
        }));
    }
    loadColumnsJson(jsonURL) {
        return this.http.get(jsonURL).pipe(concatMap((response) => response.data.columns), map((column) => {
            return plainToInstance(GridColumn, column);
        }), toArray());
    }
    static { this.ɵfac = function GridService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || GridService)(i0.ɵɵinject(i1.FilterCollectionService), i0.ɵɵinject(i2.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: GridService, factory: GridService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(GridService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.FilterCollectionService }, { type: i2.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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