import { CommonModule } from '@angular/common';
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { cloneDeep, forEach } from 'lodash-es';
import { Field } from '../../core/models/field';
import * as i0 from "@angular/core";
import * as i1 from "../../form-fields/field-renderers/built-ins/picklist/picklist.service";
import * as i2 from "../../utility/pipes/get-end-path-name.pipe";
import * as i3 from "@angular/forms";
import * as i4 from "@angular/common";
function FieldSelectComponent_option_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r1 = ctx.$implicit;
    i0.ɵɵproperty("value", field_r1.formType);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(field_r1.title);
} }
function FieldSelectComponent_div_6_option_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const field_r4 = ctx.$implicit;
    i0.ɵɵproperty("value", field_r4.formType);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(field_r4.title);
} }
function FieldSelectComponent_div_6_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 8)(1, "label", 9);
    i0.ɵɵtext(2, "Select Sub Type ");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "select", 10);
    i0.ɵɵlistener("change", function FieldSelectComponent_div_6_Template_select_change_3_listener() { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.fieldTypeChanged("subField")); });
    i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_div_6_Template_select_ngModelChange_3_listener($event) { i0.ɵɵrestoreView(_r2); const ctx_r2 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r2.field.formType, $event) || (ctx_r2.field.formType = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵtemplate(4, FieldSelectComponent_div_6_option_4_Template, 2, 2, "option", 4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("disabled", ctx_r2.field.system);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r2.field.formType);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.textFieldSubTypes);
} }
function FieldSelectComponent_div_7_option_10_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 7);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const picklist_r6 = ctx.$implicit;
    i0.ɵɵproperty("value", picklist_r6.uuid);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(picklist_r6.name);
} }
function FieldSelectComponent_div_7_Template(rf, ctx) { if (rf & 1) {
    const _r5 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 11)(1, "div", 12)(2, "label", 13);
    i0.ɵɵtext(3, "Picklist");
    i0.ɵɵelementStart(4, "span", 14);
    i0.ɵɵtext(5, "*");
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(6, "div")(7, "select", 15);
    i0.ɵɵlistener("change", function FieldSelectComponent_div_7_Template_select_change_7_listener() { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.picklistSelected()); });
    i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_div_7_Template_select_ngModelChange_7_listener($event) { i0.ɵɵrestoreView(_r5); const ctx_r2 = i0.ɵɵnextContext(); i0.ɵɵtwoWayBindingSet(ctx_r2.selectedField.dataSource.query.filters[0].value, $event) || (ctx_r2.selectedField.dataSource.query.filters[0].value = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵelementStart(8, "option", 16);
    i0.ɵɵtext(9, "Select a Picklist");
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(10, FieldSelectComponent_div_7_option_10_Template, 2, 2, "option", 4);
    i0.ɵɵelementEnd()()()();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance(7);
    i0.ɵɵproperty("disabled", ctx_r2.selectedField.system)("required", true);
    i0.ɵɵtwoWayProperty("ngModel", ctx_r2.selectedField.dataSource.query.filters[0].value);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngForOf", ctx_r2.picklists);
} }
export class FieldSelectComponent {
    constructor(picklistService, getEndPathName) {
        this.picklistService = picklistService;
        this.getEndPathName = getEndPathName;
        this.primaryFields = [];
        this.subTextFields = [Field.BuiltInType.DOMAIN, Field.BuiltInType.FILEHASH, Field.BuiltInType.IPv4, Field.BuiltInType.IPv6, Field.BuiltInType.RICHTEXTHTML, Field.BuiltInType.RICHTEXTMARKDOWN, Field.BuiltInType.TEXTAREA, Field.BuiltInType.TEXT, Field.BuiltInType.URL];
        this.textFieldSubTypes = [];
        this.fieldTypechanged = new EventEmitter();
        this.picklists = [];
    }
    ngOnInit() {
        this.setFieldTypes();
        this.loadPicklists();
    }
    ngOnChanges(changes) {
        if (changes.field) {
            this.setFieldTypes();
        }
    }
    setFieldTypes() {
        this.fieldCopy = cloneDeep(this.field);
        this.selectedField = cloneDeep(this.field);
        this.textFieldSubTypes = [];
        this.primaryFields = [];
        forEach(this.fieldTypes, (attribute) => {
            if (this.subTextFields.indexOf(attribute.formType) !== -1) {
                this.textFieldSubTypes.push(attribute);
                if (attribute.formType === Field.BuiltInType.TEXT) {
                    const fieldCopy = cloneDeep(attribute);
                    fieldCopy.title = 'Text';
                    this.primaryFields.push(fieldCopy);
                }
            }
            else if ((attribute.formType !== 'manyToMany' && attribute.formType !== 'oneToMany')) {
                this.primaryFields.push(cloneDeep(attribute));
            }
            // else if(attributetype.formType === 'datetime' || attributetype.formType === 'date') {
            //     dateSubtype.push(attributetype);
            //     if(attributetype.formType === 'datetime'){
            //       textAttr = angular.copy(attributetype);
            //       textAttr.title = 'Datetime';
            //       attrtypes.push(textAttr);
            //     }
            //   }
            // else if (attributetype.formType === 'emailTemplate') {
            //   textAttr = angular.copy(attributetype);
            //   textAttr.title = 'Email Template Field';
            //   attrtypes.push(textAttr);
            // } else {
            //   if((attributetype.formType !== 'manyToMany' && attributetype.formType !== 'oneToMany') || !scope.hideRelationship){
            //     attrtypes.push(attributetype);
            //   }
            // }
        });
        if (this.subTextFields.indexOf(this.field.formType) !== -1) {
            this.fieldCopy.formType = Field.BuiltInType.TEXT;
        }
    }
    loadPicklists() {
        this.picklistService.loadAllPicklists().subscribe((picklists) => {
            this.picklists = picklists;
            this.validatePicklist(this.field);
        });
    }
    fieldTypeChanged(fieldType) {
        console.log(this.fieldCopy.formType);
        let selectedAttribute;
        let selectedField;
        if (fieldType === 'mainField') {
            selectedField = this.fieldCopy.formType === 'text' ? this.field : this.fieldCopy;
            selectedAttribute = (this.primaryFields.find((field) => field.formType === selectedField.formType) || this.textFieldSubTypes.find((field) => field.formType === selectedField.formType));
        }
        else {
            selectedField = this.field;
            selectedAttribute = this.textFieldSubTypes.find((field) => field.formType === selectedField.formType);
        }
        this.selectedField = Object.assign(selectedField, selectedAttribute);
        this.selectedAttribute = selectedAttribute;
        if (selectedAttribute.formType === Field.BuiltInType.PICKLIST || selectedAttribute.formType === Field.BuiltInType.MULTISELECT_PICKLIST) {
            this.validatePicklist(this.selectedField);
        }
        else {
            this.fieldTypechanged.emit({
                moduleAttribute: selectedAttribute,
                field: this.selectedField
            });
        }
    }
    picklistSelected() {
        console.log(this.fieldCopy);
        this.fieldTypechanged.emit({
            moduleAttribute: this.selectedAttribute,
            field: this.selectedField
        });
    }
    validatePicklist(field) {
        if (this.picklists && field.dataSource && field.dataSource.query?.filters.length) {
            const selectedPicklist = this.picklists[field.dataSource.query.filters[0].value];
            const displayConditions = field.displayConditions || {};
            if (selectedPicklist) {
                forEach(selectedPicklist, (option) => {
                    const uuid = this.getEndPathName.transform(option['@id']);
                    if (!displayConditions[uuid] || (field.formType === Field.BuiltInType.MULTISELECT_PICKLIST && ['disabled', 'enabled_condition'].indexOf(displayConditions[uuid].visibility) > -1)) {
                        const displayCondition = {
                            visibility: 'visible',
                            conditions: null
                        };
                        displayConditions[uuid] = displayCondition;
                    }
                    option.visibility = displayConditions[uuid].visibility;
                    option._conditions = displayConditions[uuid].conditions;
                });
            }
            else {
                field.dataSource.query.filters[0].value = null;
            }
            field.displayConditions = displayConditions;
        }
    }
    static { this.ɵfac = function FieldSelectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldSelectComponent)(i0.ɵɵdirectiveInject(i1.PicklistService), i0.ɵɵdirectiveInject(i2.GetEndPathNamePipe)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldSelectComponent, selectors: [["xf-field-select"]], inputs: { field: "field", modulesList: "modulesList", entity: "entity", moduleFields: "moduleFields", fieldTypes: "fieldTypes" }, outputs: { fieldTypechanged: "fieldTypechanged" }, standalone: true, features: [i0.ɵɵNgOnChangesFeature, i0.ɵɵStandaloneFeature], decls: 8, vars: 5, consts: [[1, "clearfix"], [1, "float-start", "padding-right-20px", "w-50"], ["for", "fieldType", 1, "control-label", "label-font"], ["id", "fieldType", "name", "fieldType", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "ngModelChange", "change", "disabled", "ngModel"], [3, "value", 4, "ngFor", "ngForOf"], ["class", "float-start padding-right-20px w-50 label-font", 4, "ngIf"], ["class", "margin-top-16px", 4, "ngIf"], [3, "value"], [1, "float-start", "padding-right-20px", "w-50", "label-font"], ["for", "textFieldSubType", 1, "control-label"], ["id", "textFieldSubType", "name", "textFieldSubType", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "change", "ngModelChange", "disabled", "ngModel"], [1, "margin-top-16px"], [1, "form-group"], ["for", "select-picklist", 1, "label-font"], [1, "text-danger"], ["id", "select-picklist", "name", "select-picklist", 1, "form-control", "form-control-sm", "margin-top-6px", 3, "change", "ngModelChange", "disabled", "required", "ngModel"], ["value", "null"]], template: function FieldSelectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0)(1, "div", 1)(2, "label", 2);
            i0.ɵɵtext(3, "Select Field Type ");
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(4, "select", 3);
            i0.ɵɵtwoWayListener("ngModelChange", function FieldSelectComponent_Template_select_ngModelChange_4_listener($event) { i0.ɵɵtwoWayBindingSet(ctx.fieldCopy.formType, $event) || (ctx.fieldCopy.formType = $event); return $event; });
            i0.ɵɵlistener("change", function FieldSelectComponent_Template_select_change_4_listener() { return ctx.fieldTypeChanged("mainField"); });
            i0.ɵɵtemplate(5, FieldSelectComponent_option_5_Template, 2, 2, "option", 4);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(6, FieldSelectComponent_div_6_Template, 5, 3, "div", 5);
            i0.ɵɵelementEnd();
            i0.ɵɵtemplate(7, FieldSelectComponent_div_7_Template, 11, 4, "div", 6);
        } if (rf & 2) {
            i0.ɵɵadvance(4);
            i0.ɵɵproperty("disabled", ctx.field.system);
            i0.ɵɵtwoWayProperty("ngModel", ctx.fieldCopy.formType);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngForOf", ctx.primaryFields);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fieldCopy.formType === "text");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.selectedField.formType === "picklist" || ctx.selectedField.formType === "multiselectpicklist");
        } }, dependencies: [FormsModule, i3.NgSelectOption, i3.ɵNgSelectMultipleOption, i3.SelectControlValueAccessor, i3.NgControlStatus, i3.RequiredValidator, i3.NgModel, CommonModule, i4.NgForOf, i4.NgIf] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldSelectComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-select', standalone: true, imports: [FormsModule, CommonModule], template: "<div class=\"clearfix\">\n  <div class=\"float-start padding-right-20px w-50\">\n    <label class=\"control-label label-font\" for=\"fieldType\">Select Field Type\n    </label>\n    <select class=\"form-control form-control-sm margin-top-6px\" id=\"fieldType\" name=\"fieldType\"\n      [disabled]=\"field.system\" [(ngModel)]=\"fieldCopy.formType\" (change)=\"fieldTypeChanged('mainField')\">\n      <option *ngFor=\"let field of primaryFields;\" [value]=\"field.formType\">{{ field.title }}</option>\n    </select>\n  </div>\n  <div *ngIf=\"fieldCopy.formType === 'text'\" class=\"float-start padding-right-20px w-50 label-font\">\n    <label class=\"control-label\" for=\"textFieldSubType\">Select Sub Type\n    </label>\n    <select class=\"form-control form-control-sm margin-top-6px\" id=\"textFieldSubType\" name=\"textFieldSubType\"\n      [disabled]=\"field.system\" (change)=\"fieldTypeChanged('subField')\" [(ngModel)]=\"field.formType\">\n      <option *ngFor=\"let field of textFieldSubTypes;\" [value]=\"field.formType\">{{ field.title }}</option>\n    </select>\n  </div>\n</div>\n<div *ngIf=\"selectedField.formType === 'picklist' || selectedField.formType === 'multiselectpicklist'\"\n  class=\"margin-top-16px\">\n  <!-- <div class=\"form-group\" data-ng-class=\"{'has-error': (form.picklistSelect.$touched && !form.picklistSelect.$valid)|| field.dataSource.query.filters[0].value == ''}\"></div> -->\n  <div class=\"form-group\">\n    <label class=\"label-font\" for=\"select-picklist\">Picklist<span class=\"text-danger\">*</span></label>\n    <div>\n      <select class=\"form-control form-control-sm margin-top-6px\" id=\"select-picklist\" name=\"select-picklist\"\n        [disabled]=\"selectedField.system\" (change)=\"picklistSelected()\" [required]=\"true\"\n        [(ngModel)]=\"selectedField.dataSource.query.filters[0].value\">\n        <option value=\"null\">Select a Picklist</option>\n        <option *ngFor=\"let picklist of picklists;\" [value]=\"picklist.uuid\">{{ picklist.name }}</option>\n      </select>\n    </div>\n    <!-- <select class=\"form-control\" id=\"picklist-select--{{ $index }}\" name=\"picklistSelect\" data-ng-disabled=\"field.system === true\" data-ng-model=\"field.dataSource.query.filters[0].value\" data-ng-required=\"true\" data-ng-options=\"picklistName as picklistName for (picklistName, picklistValue) in picklistNames\"\n        data-ng-change=\"updateFieldType(false, '')\">\n\n      </select>\n      <span class=\"fa fa-sort-desc\"></span>\n      <div data-cs-messages=\"form.picklistSelect\"></div> -->\n  </div>\n  <!-- <div class=\"form-group\" data-ng-show=\"!inline\">\n    <button type=\"button\" class=\"btn btn-sm btn-default margin-top-3\" data-ng-disabled=\"field.system === true\" data-ng-hide=\"license && license.details.is_distributed &&  license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\" data-ng-click=\"quickPicklistEditor(null)\" id=\"create-new-picklist-btn--{{ $index }}\">Create picklist</button>\n    <button data-ng-if=\"field.dataSource.query.filters[0].value\" type=\"button\" class=\"btn btn-sm btn-default margin-top-3\" data-ng-disabled=\"field.system === true\" data-ng-hide=\"license && license.details.is_distributed &&  license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\" data-ng-click=\"quickPicklistEditor(field.dataSource.query.filters[0].value)\" id=\"modify-picklist-btn\">Modify picklist</button>\n  </div> -->\n  <!-- <div class=\"alert alert-info margin-top-sm\" data-ng-show=\"license && license.details.is_distributed && license.details.role && license.details.role[0] === 'master' && currentStateName === 'main.multitenancy.remoteTenantManager.manageTenantModules.editTenantModules'\">\n      <i class=\"icon icon-information\"></i>&nbsp;&nbsp;Picklists referred here are from the Master Node. Please ensure a sync between the picklists in Master and Tenant nodes for any edit to happen successfully.\n  </div> -->\n  <!-- <div class=\"form-group\" data-ng-if=\"field.dataSource.query.filters[0].value && picklistNames[field.dataSource.query.filters[0].value] && !hideVisibility\">\n    <div class=\"checkbox margin-bottom-md\">\n      <label>\n        <input id=\"picklist-item-visibility\" type=\"checkbox\" name=\"picklist-item-visibility\" data-ng-model=\"$parent.field.dataSource.useDisplayConditions\">&nbsp;&nbsp;Configure Picklist Item Visibility\n        <span data-uib-tooltip=\"Picklist option visibility allows you to hide picklist items for this field based on conditions\"\n          data-tooltip-append-to-body=\"true\"><i class=\"icon icon-information font-Size-13\"></i></span>\n      </label>\n    </div>\n    <div data-ng-show=\"$parent.field.dataSource.useDisplayConditions\">\n      <div class=\"picklist-item-visibility-container\" data-ng-repeat=\"(key, option) in picklistNames[field.dataSource.query.filters[0].value].picklists | orderBy: 'orderIndex'\">\n        <div class=\"row padding-bottom-sm\">\n          <div class=\"col-md-4 label\">\n            <p id=\"view-{{ ::option.itemValue }}\" data-ng-hide=\"option.color\" class=\"margin-0 text-left text-overflow line-height-normal {{defaultClass}}\">\n              <span class=\"{{ defaultClass ? 'rating': '' }}\" title=\"{{ option.itemValue && option.itemValue.length > 0 ?  option.itemValue : 'None'}}\">{{ option.itemValue && option.itemValue.length > 0 ?  option.itemValue : 'None'}}</p>\n            <p id=\"view-{{ ::option.itemValue }}\" data-ng-show=\"option.color\" class=\"margin-0 text-left {{defaultClass}}\">\n            <span class=\"rating\" data-ng-attr-style=\"background: {{ option.color }}; color: {{ (option.color | isHexColorLight) ? '#000' : '#fff' }}\"> {{ option.itemValue }}</span>\n            </p>\n          </div>\n          <div class=\"col-md-8 val\">\n            <div class=\"cs-select\">\n              <select class=\"form-control\" name=\"picklist-item-visibility-display-{{ $index }}\" data-ng-model=\"option._visibility\" data-ng-required=\"true\" data-ng-change=\"updatePicklistItemVisibility(option)\">\n                <option value=\"visible\">Visible</option>\n                <option value=\"disabled\" ng-if=\"field.formType === 'picklist'\">Disabled</option>\n                <option value=\"hidden\">Hidden</option>\n                <option value=\"visible_condition\">Conditionally Visible</option>\n                <option value=\"enabled_condition\" ng-if=\"field.formType === 'picklist'\">Conditionally Enabled</option>\n              </select>\n              <span class=\"fa fa-sort-desc\"></span>\n            </div>\n          </div>\n        </div>\n        <div data-ng-if=\"option._visibility == 'visible_condition' || option._visibility == 'enabled_condition'\" class=\"row\">\n          <div class=\"col-md-12 padding-left-6\">\n            <hr class=\"margin-top-sm margin-bottom-md\">\n            <div data-cs-conditional data-enable-nested-filter=\"$parent.enableNestedFilter\" data-fields=\"$parent.moduleFields\" data-ng-model=\"option._conditions\" data-value-changed-param=\"option\" data-value-changed=\"updatePicklistItemVisibility\" data-form-name=\"'fieldSelectForm'\"></div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div> -->\n</div>\n" }]
    }], () => [{ type: i1.PicklistService }, { type: i2.GetEndPathNamePipe }], { field: [{
            type: Input
        }], modulesList: [{
            type: Input
        }], entity: [{
            type: Input
        }], moduleFields: [{
            type: Input
        }], fieldTypes: [{
            type: Input
        }], fieldTypechanged: [{
            type: Output
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldSelectComponent, { className: "FieldSelectComponent", filePath: "lib/components/field-select/field-select.component.ts", lineNumber: 20 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmllbGQtc2VsZWN0LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zcmMvbGliL2NvbXBvbmVudHMvZmllbGQtc2VsZWN0L2ZpZWxkLXNlbGVjdC5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9jb21wb25lbnRzL2ZpZWxkLXNlbGVjdC9maWVsZC1zZWxlY3QuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFlBQVksRUFBRSxNQUFNLGlCQUFpQixDQUFDO0FBQy9DLE9BQU8sRUFBRSxTQUFTLEVBQUUsWUFBWSxFQUFFLEtBQUssRUFBcUIsTUFBTSxFQUFpQixNQUFNLGVBQWUsQ0FBQztBQUN6RyxPQUFPLEVBQUUsV0FBVyxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDN0MsT0FBTyxFQUFFLFNBQVMsRUFBRSxPQUFPLEVBQUUsTUFBTSxXQUFXLENBQUM7QUFHL0MsT0FBTyxFQUFFLEtBQUssRUFBRSxNQUFNLHlCQUF5QixDQUFDOzs7Ozs7O0lDQTFDLGlDQUFzRTtJQUFBLFlBQWlCO0lBQUEsaUJBQVM7OztJQUFuRCx5Q0FBd0I7SUFBQyxjQUFpQjtJQUFqQixvQ0FBaUI7OztJQVF2RixpQ0FBMEU7SUFBQSxZQUFpQjtJQUFBLGlCQUFTOzs7SUFBbkQseUNBQXdCO0lBQUMsY0FBaUI7SUFBakIsb0NBQWlCOzs7O0lBSjdGLEFBREYsOEJBQWtHLGVBQzVDO0lBQUEsZ0NBQ3BEO0lBQUEsaUJBQVE7SUFDUixrQ0FDaUc7SUFBckUsa0xBQVUsd0JBQWlCLFVBQVUsQ0FBQyxLQUFDO0lBQUMsaVRBQTRCO0lBQzlGLGlGQUEwRTtJQUU5RSxBQURFLGlCQUFTLEVBQ0w7OztJQUhGLGVBQXlCO0lBQXpCLDhDQUF5QjtJQUF5QyxxREFBNEI7SUFDcEUsY0FBcUI7SUFBckIsa0RBQXFCOzs7SUFjN0MsaUNBQW9FO0lBQUEsWUFBbUI7SUFBQSxpQkFBUzs7O0lBQXBELHdDQUF1QjtJQUFDLGNBQW1CO0lBQW5CLHNDQUFtQjs7OztJQU4zRixBQURGLEFBSEYsK0JBQzBCLGNBRUEsZ0JBQzBCO0lBQUEsd0JBQVE7SUFBQSxnQ0FBMEI7SUFBQSxpQkFBQztJQUFPLEFBQVAsaUJBQU8sRUFBUTtJQUVoRyxBQURGLDJCQUFLLGlCQUc2RDtJQUQ1QixrTEFBVSx5QkFBa0IsS0FBQztJQUMvRCwwUEFBb0QsQ0FBQyxtRUFBRCxDQUFDLG9EQUFRO0lBQzdELGtDQUFxQjtJQUFBLGlDQUFpQjtJQUFBLGlCQUFTO0lBQy9DLG1GQUFvRTtJQXlENUUsQUFoREUsQUFQRSxBQURFLGlCQUFTLEVBQ0wsRUFPRixFQWdERjs7O0lBNURFLGVBQWlDO0lBQStCLEFBQWhFLHNEQUFpQyxrQkFBZ0Q7SUFDakYsc0ZBQTZEO0lBRWhDLGVBQWE7SUFBYiwwQ0FBYTs7QURUbEQsTUFBTSxPQUFPLG9CQUFvQjtJQTJCL0IsWUFBb0IsZUFBZ0MsRUFBVSxjQUFrQztRQUE1RSxvQkFBZSxHQUFmLGVBQWUsQ0FBaUI7UUFBVSxtQkFBYyxHQUFkLGNBQWMsQ0FBb0I7UUFuQmhHLGtCQUFhLEdBQXNCLEVBQUUsQ0FBQztRQUM5QixrQkFBYSxHQUFhLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxNQUFNLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3hSLHNCQUFpQixHQUFzQixFQUFFLENBQUM7UUFFaEMscUJBQWdCLEdBQUcsSUFBSSxZQUFZLEVBQXVELENBQUM7UUFDckcsY0FBUyxHQUFtQixFQUFFLENBQUM7SUFnQi9CLENBQUM7SUFHRCxRQUFRO1FBQ04sSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN2QixDQUFDO0lBRUQsV0FBVyxDQUFDLE9BQXNCO1FBQ2hDLElBQUksT0FBTyxDQUFDLEtBQUssRUFBRSxDQUFDO1lBQ2xCLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztRQUN2QixDQUFDO0lBQ0gsQ0FBQztJQUVPLGFBQWE7UUFDbkIsSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUMzQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsRUFBRSxDQUFDO1FBQzVCLElBQUksQ0FBQyxhQUFhLEdBQUcsRUFBRSxDQUFDO1FBQ3hCLE9BQU8sQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUMsU0FBMEIsRUFBRSxFQUFFO1lBQ3RELElBQUksSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUM7Z0JBQzFELElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7Z0JBQ3ZDLElBQUksU0FBUyxDQUFDLFFBQVEsS0FBSyxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksRUFBRSxDQUFDO29CQUNsRCxNQUFNLFNBQVMsR0FBRyxTQUFTLENBQUMsU0FBUyxDQUFDLENBQUM7b0JBQ3ZDLFNBQVMsQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDO29CQUN6QixJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztnQkFDckMsQ0FBQztZQUNILENBQUM7aUJBQU0sSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLEtBQUssWUFBWSxJQUFJLFNBQVMsQ0FBQyxRQUFRLEtBQUssV0FBVyxDQUFDLEVBQUUsQ0FBQztnQkFDdkYsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDaEQsQ0FBQztZQUNELHdGQUF3RjtZQUN4Rix1Q0FBdUM7WUFDdkMsaURBQWlEO1lBQ2pELGdEQUFnRDtZQUNoRCxxQ0FBcUM7WUFDckMsa0NBQWtDO1lBQ2xDLFFBQVE7WUFDUixNQUFNO1lBQ04seURBQXlEO1lBQ3pELDRDQUE0QztZQUM1Qyw2Q0FBNkM7WUFDN0MsOEJBQThCO1lBQzlCLFdBQVc7WUFDWCx3SEFBd0g7WUFDeEgscUNBQXFDO1lBQ3JDLE1BQU07WUFDTixJQUFJO1FBQ04sQ0FBQyxDQUFDLENBQUM7UUFDSCxJQUFJLElBQUksQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQztZQUMzRCxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQztRQUNuRCxDQUFDO0lBRUgsQ0FBQztJQUVPLGFBQWE7UUFDbkIsSUFBSSxDQUFDLGVBQWUsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDLFNBQWMsRUFBRSxFQUFFO1lBQ25FLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO1lBQzNCLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsS0FBc0IsQ0FBQyxDQUFDO1FBQ3JELENBQUMsQ0FBQyxDQUFBO0lBQ0osQ0FBQztJQUVELGdCQUFnQixDQUFDLFNBQW1DO1FBQ2xELE9BQU8sQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUNyQyxJQUFJLGlCQUFrQyxDQUFDO1FBQ3ZDLElBQUksYUFBb0IsQ0FBQztRQUN6QixJQUFJLFNBQVMsS0FBSyxXQUFXLEVBQUUsQ0FBQztZQUM5QixhQUFhLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLEtBQUssTUFBTSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO1lBQ2pGLGlCQUFpQixHQUFHLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxLQUFzQixFQUFFLEVBQUUsQ0FBQyxLQUFLLENBQUMsUUFBUSxLQUFLLGFBQWEsQ0FBQyxRQUFRLENBQUMsSUFBSSxJQUFJLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLENBQUMsS0FBc0IsRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLFFBQVEsS0FBSyxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUUsQ0FBQztRQUM5TixDQUFDO2FBQU0sQ0FBQztZQUNOLGFBQWEsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQzNCLGlCQUFpQixHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsQ0FBQyxLQUFzQixFQUFFLEVBQUUsQ0FBQyxLQUFLLENBQUMsUUFBUSxLQUFLLGFBQWEsQ0FBQyxRQUFRLENBQUUsQ0FBQTtRQUN6SCxDQUFDO1FBQ0QsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLGFBQWEsRUFBRSxpQkFBaUIsQ0FBQyxDQUFDO1FBQ3JFLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxpQkFBaUIsQ0FBQztRQUMzQyxJQUFJLGlCQUFpQixDQUFDLFFBQVEsS0FBSyxLQUFLLENBQUMsV0FBVyxDQUFDLFFBQVEsSUFBSSxpQkFBaUIsQ0FBQyxRQUFRLEtBQUssS0FBSyxDQUFDLFdBQVcsQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1lBQ3ZJLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsYUFBOEIsQ0FBQyxDQUFDO1FBQzdELENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQztnQkFDekIsZUFBZSxFQUFFLGlCQUFpQjtnQkFDbEMsS0FBSyxFQUFFLElBQUksQ0FBQyxhQUFhO2FBQzFCLENBQUMsQ0FBQztRQUNMLENBQUM7SUFDSCxDQUFDO0lBQ0QsZ0JBQWdCO1FBQ2QsT0FBTyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7UUFDNUIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQztZQUN6QixlQUFlLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUN2QyxLQUFLLEVBQUUsSUFBSSxDQUFDLGFBQWE7U0FDMUIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVPLGdCQUFnQixDQUFDLEtBQW9CO1FBQzNDLElBQUksSUFBSSxDQUFDLFNBQVMsSUFBSSxLQUFLLENBQUMsVUFBVSxJQUFJLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUNqRixNQUFNLGdCQUFnQixHQUFRLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ3RGLE1BQU0saUJBQWlCLEdBQVEsS0FBSyxDQUFDLGlCQUFpQixJQUFJLEVBQUUsQ0FBQztZQUM3RCxJQUFJLGdCQUFnQixFQUFFLENBQUM7Z0JBQ3JCLE9BQU8sQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLE1BQVcsRUFBRSxFQUFFO29CQUN4QyxNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztvQkFDMUQsSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsS0FBSyxLQUFLLENBQUMsV0FBVyxDQUFDLG9CQUFvQixJQUFJLENBQUMsVUFBVSxFQUFFLG1CQUFtQixDQUFDLENBQUMsT0FBTyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQzt3QkFDbEwsTUFBTSxnQkFBZ0IsR0FBRzs0QkFDdkIsVUFBVSxFQUFFLFNBQVM7NEJBQ3JCLFVBQVUsRUFBRSxJQUFJO3lCQUNqQixDQUFDO3dCQUNGLGlCQUFpQixDQUFDLElBQUksQ0FBQyxHQUFHLGdCQUFnQixDQUFDO29CQUM3QyxDQUFDO29CQUNELE1BQU0sQ0FBQyxVQUFVLEdBQUcsaUJBQWlCLENBQUMsSUFBSSxDQUFDLENBQUMsVUFBVSxDQUFDO29CQUN2RCxNQUFNLENBQUMsV0FBVyxHQUFHLGlCQUFpQixDQUFDLElBQUksQ0FBQyxDQUFDLFVBQVUsQ0FBQztnQkFDMUQsQ0FBQyxDQUFDLENBQUM7WUFDTCxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUM7WUFDakQsQ0FBQztZQUNELEtBQUssQ0FBQyxpQkFBaUIsR0FBRyxpQkFBaUIsQ0FBQztRQUM5QyxDQUFDO0lBQ0gsQ0FBQztxSEE5SVUsb0JBQW9CO29FQUFwQixvQkFBb0I7WUNqQjdCLEFBREYsQUFERiw4QkFBc0IsYUFDNkIsZUFDUztZQUFBLGtDQUN4RDtZQUFBLGlCQUFRO1lBQ1IsaUNBQ3NHO1lBQTFFLG1PQUFnQztZQUFDLG1HQUFVLHFCQUFpQixXQUFXLENBQUMsSUFBQztZQUNuRywyRUFBc0U7WUFFMUUsQUFERSxpQkFBUyxFQUNMO1lBQ04scUVBQWtHO1lBUXBHLGlCQUFNO1lBQ04sc0VBQzBCOztZQWRwQixlQUF5QjtZQUF6QiwyQ0FBeUI7WUFBQyxzREFBZ0M7WUFDaEMsY0FBaUI7WUFBakIsMkNBQWlCO1lBR3pDLGNBQW1DO1lBQW5DLHdEQUFtQztZQVNyQyxjQUErRjtZQUEvRix3SEFBK0Y7NEJERHpGLFdBQVcsc0lBQUUsWUFBWTs7aUZBRXhCLG9CQUFvQjtjQVBoQyxTQUFTOzJCQUNFLGlCQUFpQixjQUdmLElBQUksV0FDUCxDQUFDLFdBQVcsRUFBRSxZQUFZLENBQUM7aUZBRzNCLEtBQUs7a0JBQWIsS0FBSztZQUNHLFdBQVc7a0JBQW5CLEtBQUs7WUFDRyxNQUFNO2tCQUFkLEtBQUs7WUFDRyxZQUFZO2tCQUFwQixLQUFLO1lBQ0csVUFBVTtrQkFBbEIsS0FBSztZQU9JLGdCQUFnQjtrQkFBekIsTUFBTTs7a0ZBWkksb0JBQW9CIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tbW9uTW9kdWxlIH0gZnJvbSAnQGFuZ3VsYXIvY29tbW9uJztcbmltcG9ydCB7IENvbXBvbmVudCwgRXZlbnRFbWl0dGVyLCBJbnB1dCwgT25DaGFuZ2VzLCBPbkluaXQsIE91dHB1dCwgU2ltcGxlQ2hhbmdlcyB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgRm9ybXNNb2R1bGUgfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XG5pbXBvcnQgeyBjbG9uZURlZXAsIGZvckVhY2ggfSBmcm9tICdsb2Rhc2gtZXMnO1xuaW1wb3J0IHsgTW9kdWxlQXR0cmlidXRlIH0gZnJvbSAnLi4vLi4vY29yZS9tb2RlbHMvYXR0cmlidXRlLW1hcCc7XG5pbXBvcnQgeyBFbnRpdHkgfSBmcm9tICcuLi8uLi9jb3JlL21vZGVscy9lbnRpdHknO1xuaW1wb3J0IHsgRmllbGQgfSBmcm9tICcuLi8uLi9jb3JlL21vZGVscy9maWVsZCc7XG5pbXBvcnQgeyBQaWNrbGlzdE5hbWUgfSBmcm9tICcuLi8uLi9mb3JtLWZpZWxkcy9maWVsZC1yZW5kZXJlcnMvYnVpbHQtaW5zL3BpY2tsaXN0L21vZGVscy9waWNrbGlzdE5hbWUnO1xuaW1wb3J0IHsgUGlja2xpc3RTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vZm9ybS1maWVsZHMvZmllbGQtcmVuZGVyZXJzL2J1aWx0LWlucy9waWNrbGlzdC9waWNrbGlzdC5zZXJ2aWNlJztcbmltcG9ydCB7IFBpY2tsaXN0RmllbGQgfSBmcm9tICcuLi8uLi9mb3JtLWZpZWxkcy9maWVsZC10eXBlcy9waWNrbGlzdCc7XG5pbXBvcnQgeyBHZXRFbmRQYXRoTmFtZVBpcGUgfSBmcm9tICcuLi8uLi91dGlsaXR5L3BpcGVzL2dldC1lbmQtcGF0aC1uYW1lLnBpcGUnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICd4Zi1maWVsZC1zZWxlY3QnLFxuICB0ZW1wbGF0ZVVybDogJy4vZmllbGQtc2VsZWN0LmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vZmllbGQtc2VsZWN0LmNvbXBvbmVudC5zY3NzJ10sXG4gIHN0YW5kYWxvbmU6IHRydWUsXG4gIGltcG9ydHM6IFtGb3Jtc01vZHVsZSwgQ29tbW9uTW9kdWxlXSxcbn0pXG5leHBvcnQgY2xhc3MgRmllbGRTZWxlY3RDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIE9uQ2hhbmdlcyB7XG4gIEBJbnB1dCgpIGZpZWxkITogRmllbGQ7XG4gIEBJbnB1dCgpIG1vZHVsZXNMaXN0ITogRW50aXR5W107XG4gIEBJbnB1dCgpIGVudGl0eSE6IEVudGl0eTtcbiAgQElucHV0KCkgbW9kdWxlRmllbGRzITogRW50aXR5LkZpZWxkTWFwO1xuICBASW5wdXQoKSBmaWVsZFR5cGVzIToge1xuICAgIFthdHRyOiBzdHJpbmddOiBNb2R1bGVBdHRyaWJ1dGVcbiAgfTtcbiAgcHJpbWFyeUZpZWxkczogTW9kdWxlQXR0cmlidXRlW10gPSBbXTtcbiAgcHJpdmF0ZSBzdWJUZXh0RmllbGRzOiBzdHJpbmdbXSA9IFtGaWVsZC5CdWlsdEluVHlwZS5ET01BSU4sIEZpZWxkLkJ1aWx0SW5UeXBlLkZJTEVIQVNILCBGaWVsZC5CdWlsdEluVHlwZS5JUHY0LCBGaWVsZC5CdWlsdEluVHlwZS5JUHY2LCBGaWVsZC5CdWlsdEluVHlwZS5SSUNIVEVYVEhUTUwsIEZpZWxkLkJ1aWx0SW5UeXBlLlJJQ0hURVhUTUFSS0RPV04sIEZpZWxkLkJ1aWx0SW5UeXBlLlRFWFRBUkVBLCBGaWVsZC5CdWlsdEluVHlwZS5URVhULCBGaWVsZC5CdWlsdEluVHlwZS5VUkxdO1xuICB0ZXh0RmllbGRTdWJUeXBlczogTW9kdWxlQXR0cmlidXRlW10gPSBbXTtcbiAgZmllbGRDb3B5ITogRmllbGQ7XG4gIEBPdXRwdXQoKSBmaWVsZFR5cGVjaGFuZ2VkID0gbmV3IEV2ZW50RW1pdHRlcjx7IG1vZHVsZUF0dHJpYnV0ZTogTW9kdWxlQXR0cmlidXRlLCBmaWVsZD86IEZpZWxkIH0+KCk7XG4gIHBpY2tsaXN0czogUGlja2xpc3ROYW1lW10gPSBbXTtcbiAgLy8gY29sQ2xhc3M6ICc9PycsXG4gIC8vIGhpZGVSZWxhdGlvbnNoaXA6ICc9PycsXG4gIC8vIG1vZHVsZUZpZWxkczogJz0/JyxcbiAgLy8gaGlkZVZpc2liaWxpdHk6ICc9PycsXG4gIC8vIHNob3dDb25uZWN0b3JGaWVsZDogJz0/JyxcbiAgLy8gZW5hYmxlSmluamE6ICc9PycsXG4gIC8vIHNob3dTaW1wbGVGaWVsZHM6ICc9PycsXG4gIC8vIHNob3dGb3JtQXR0cmlidXRlczogJz0/JyxcbiAgLy8gY2hhbmdlTWV0aG9kOiAnPT8nXG4gIC8vQE91dHB1dCgpXG4gIHNlbGVjdGVkRmllbGQhOiBGaWVsZDtcbiAgc2VsZWN0ZWRBdHRyaWJ1dGUhOiBNb2R1bGVBdHRyaWJ1dGU7XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSBwaWNrbGlzdFNlcnZpY2U6IFBpY2tsaXN0U2VydmljZSwgcHJpdmF0ZSBnZXRFbmRQYXRoTmFtZTogR2V0RW5kUGF0aE5hbWVQaXBlKSB7XG5cbiAgfVxuXG5cbiAgbmdPbkluaXQoKTogdm9pZCB7XG4gICAgdGhpcy5zZXRGaWVsZFR5cGVzKCk7XG4gICAgdGhpcy5sb2FkUGlja2xpc3RzKCk7XG4gIH1cblxuICBuZ09uQ2hhbmdlcyhjaGFuZ2VzOiBTaW1wbGVDaGFuZ2VzKTogdm9pZCB7XG4gICAgaWYgKGNoYW5nZXMuZmllbGQpIHtcbiAgICAgIHRoaXMuc2V0RmllbGRUeXBlcygpO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgc2V0RmllbGRUeXBlcygpIHtcbiAgICB0aGlzLmZpZWxkQ29weSA9IGNsb25lRGVlcCh0aGlzLmZpZWxkKTtcbiAgICB0aGlzLnNlbGVjdGVkRmllbGQgPSBjbG9uZURlZXAodGhpcy5maWVsZCk7XG4gICAgdGhpcy50ZXh0RmllbGRTdWJUeXBlcyA9IFtdO1xuICAgIHRoaXMucHJpbWFyeUZpZWxkcyA9IFtdO1xuICAgIGZvckVhY2godGhpcy5maWVsZFR5cGVzLCAoYXR0cmlidXRlOiBNb2R1bGVBdHRyaWJ1dGUpID0+IHtcbiAgICAgIGlmICh0aGlzLnN1YlRleHRGaWVsZHMuaW5kZXhPZihhdHRyaWJ1dGUuZm9ybVR5cGUpICE9PSAtMSkge1xuICAgICAgICB0aGlzLnRleHRGaWVsZFN1YlR5cGVzLnB1c2goYXR0cmlidXRlKTtcbiAgICAgICAgaWYgKGF0dHJpYnV0ZS5mb3JtVHlwZSA9PT0gRmllbGQuQnVpbHRJblR5cGUuVEVYVCkge1xuICAgICAgICAgIGNvbnN0IGZpZWxkQ29weSA9IGNsb25lRGVlcChhdHRyaWJ1dGUpO1xuICAgICAgICAgIGZpZWxkQ29weS50aXRsZSA9ICdUZXh0JztcbiAgICAgICAgICB0aGlzLnByaW1hcnlGaWVsZHMucHVzaChmaWVsZENvcHkpO1xuICAgICAgICB9XG4gICAgICB9IGVsc2UgaWYgKChhdHRyaWJ1dGUuZm9ybVR5cGUgIT09ICdtYW55VG9NYW55JyAmJiBhdHRyaWJ1dGUuZm9ybVR5cGUgIT09ICdvbmVUb01hbnknKSkge1xuICAgICAgICB0aGlzLnByaW1hcnlGaWVsZHMucHVzaChjbG9uZURlZXAoYXR0cmlidXRlKSk7XG4gICAgICB9XG4gICAgICAvLyBlbHNlIGlmKGF0dHJpYnV0ZXR5cGUuZm9ybVR5cGUgPT09ICdkYXRldGltZScgfHwgYXR0cmlidXRldHlwZS5mb3JtVHlwZSA9PT0gJ2RhdGUnKSB7XG4gICAgICAvLyAgICAgZGF0ZVN1YnR5cGUucHVzaChhdHRyaWJ1dGV0eXBlKTtcbiAgICAgIC8vICAgICBpZihhdHRyaWJ1dGV0eXBlLmZvcm1UeXBlID09PSAnZGF0ZXRpbWUnKXtcbiAgICAgIC8vICAgICAgIHRleHRBdHRyID0gYW5ndWxhci5jb3B5KGF0dHJpYnV0ZXR5cGUpO1xuICAgICAgLy8gICAgICAgdGV4dEF0dHIudGl0bGUgPSAnRGF0ZXRpbWUnO1xuICAgICAgLy8gICAgICAgYXR0cnR5cGVzLnB1c2godGV4dEF0dHIpO1xuICAgICAgLy8gICAgIH1cbiAgICAgIC8vICAgfVxuICAgICAgLy8gZWxzZSBpZiAoYXR0cmlidXRldHlwZS5mb3JtVHlwZSA9PT0gJ2VtYWlsVGVtcGxhdGUnKSB7XG4gICAgICAvLyAgIHRleHRBdHRyID0gYW5ndWxhci5jb3B5KGF0dHJpYnV0ZXR5cGUpO1xuICAgICAgLy8gICB0ZXh0QXR0ci50aXRsZSA9ICdFbWFpbCBUZW1wbGF0ZSBGaWVsZCc7XG4gICAgICAvLyAgIGF0dHJ0eXBlcy5wdXNoKHRleHRBdHRyKTtcbiAgICAgIC8vIH0gZWxzZSB7XG4gICAgICAvLyAgIGlmKChhdHRyaWJ1dGV0eXBlLmZvcm1UeXBlICE9PSAnbWFueVRvTWFueScgJiYgYXR0cmlidXRldHlwZS5mb3JtVHlwZSAhPT0gJ29uZVRvTWFueScpIHx8ICFzY29wZS5oaWRlUmVsYXRpb25zaGlwKXtcbiAgICAgIC8vICAgICBhdHRydHlwZXMucHVzaChhdHRyaWJ1dGV0eXBlKTtcbiAgICAgIC8vICAgfVxuICAgICAgLy8gfVxuICAgIH0pO1xuICAgIGlmICh0aGlzLnN1YlRleHRGaWVsZHMuaW5kZXhPZih0aGlzLmZpZWxkLmZvcm1UeXBlKSAhPT0gLTEpIHtcbiAgICAgIHRoaXMuZmllbGRDb3B5LmZvcm1UeXBlID0gRmllbGQuQnVpbHRJblR5cGUuVEVYVDtcbiAgICB9XG5cbiAgfVxuXG4gIHByaXZhdGUgbG9hZFBpY2tsaXN0cygpIHtcbiAgICB0aGlzLnBpY2tsaXN0U2VydmljZS5sb2FkQWxsUGlja2xpc3RzKCkuc3Vic2NyaWJlKChwaWNrbGlzdHM6IGFueSkgPT4ge1xuICAgICAgdGhpcy5waWNrbGlzdHMgPSBwaWNrbGlzdHM7XG4gICAgICB0aGlzLnZhbGlkYXRlUGlja2xpc3QodGhpcy5maWVsZCBhcyBQaWNrbGlzdEZpZWxkKTtcbiAgICB9KVxuICB9XG5cbiAgZmllbGRUeXBlQ2hhbmdlZChmaWVsZFR5cGU6ICdtYWluRmllbGQnIHwgJ3N1YkZpZWxkJykge1xuICAgIGNvbnNvbGUubG9nKHRoaXMuZmllbGRDb3B5LmZvcm1UeXBlKTtcbiAgICBsZXQgc2VsZWN0ZWRBdHRyaWJ1dGU6IE1vZHVsZUF0dHJpYnV0ZTtcbiAgICBsZXQgc2VsZWN0ZWRGaWVsZDogRmllbGQ7XG4gICAgaWYgKGZpZWxkVHlwZSA9PT0gJ21haW5GaWVsZCcpIHtcbiAgICAgIHNlbGVjdGVkRmllbGQgPSB0aGlzLmZpZWxkQ29weS5mb3JtVHlwZSA9PT0gJ3RleHQnID8gdGhpcy5maWVsZCA6IHRoaXMuZmllbGRDb3B5O1xuICAgICAgc2VsZWN0ZWRBdHRyaWJ1dGUgPSAodGhpcy5wcmltYXJ5RmllbGRzLmZpbmQoKGZpZWxkOiBNb2R1bGVBdHRyaWJ1dGUpID0+IGZpZWxkLmZvcm1UeXBlID09PSBzZWxlY3RlZEZpZWxkLmZvcm1UeXBlKSB8fCB0aGlzLnRleHRGaWVsZFN1YlR5cGVzLmZpbmQoKGZpZWxkOiBNb2R1bGVBdHRyaWJ1dGUpID0+IGZpZWxkLmZvcm1UeXBlID09PSBzZWxlY3RlZEZpZWxkLmZvcm1UeXBlKSkhO1xuICAgIH0gZWxzZSB7XG4gICAgICBzZWxlY3RlZEZpZWxkID0gdGhpcy5maWVsZDtcbiAgICAgIHNlbGVjdGVkQXR0cmlidXRlID0gdGhpcy50ZXh0RmllbGRTdWJUeXBlcy5maW5kKChmaWVsZDogTW9kdWxlQXR0cmlidXRlKSA9PiBmaWVsZC5mb3JtVHlwZSA9PT0gc2VsZWN0ZWRGaWVsZC5mb3JtVHlwZSkhXG4gICAgfVxuICAgIHRoaXMuc2VsZWN0ZWRGaWVsZCA9IE9iamVjdC5hc3NpZ24oc2VsZWN0ZWRGaWVsZCwgc2VsZWN0ZWRBdHRyaWJ1dGUpO1xuICAgIHRoaXMuc2VsZWN0ZWRBdHRyaWJ1dGUgPSBzZWxlY3RlZEF0dHJpYnV0ZTtcbiAgICBpZiAoc2VsZWN0ZWRBdHRyaWJ1dGUuZm9ybVR5cGUgPT09IEZpZWxkLkJ1aWx0SW5UeXBlLlBJQ0tMSVNUIHx8IHNlbGVjdGVkQXR0cmlidXRlLmZvcm1UeXBlID09PSBGaWVsZC5CdWlsdEluVHlwZS5NVUxUSVNFTEVDVF9QSUNLTElTVCkge1xuICAgICAgdGhpcy52YWxpZGF0ZVBpY2tsaXN0KHRoaXMuc2VsZWN0ZWRGaWVsZCBhcyBQaWNrbGlzdEZpZWxkKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5maWVsZFR5cGVjaGFuZ2VkLmVtaXQoe1xuICAgICAgICBtb2R1bGVBdHRyaWJ1dGU6IHNlbGVjdGVkQXR0cmlidXRlLFxuICAgICAgICBmaWVsZDogdGhpcy5zZWxlY3RlZEZpZWxkXG4gICAgICB9KTtcbiAgICB9XG4gIH1cbiAgcGlja2xpc3RTZWxlY3RlZCgpIHtcbiAgICBjb25zb2xlLmxvZyh0aGlzLmZpZWxkQ29weSk7XG4gICAgdGhpcy5maWVsZFR5cGVjaGFuZ2VkLmVtaXQoe1xuICAgICAgbW9kdWxlQXR0cmlidXRlOiB0aGlzLnNlbGVjdGVkQXR0cmlidXRlLFxuICAgICAgZmllbGQ6IHRoaXMuc2VsZWN0ZWRGaWVsZFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSB2YWxpZGF0ZVBpY2tsaXN0KGZpZWxkOiBQaWNrbGlzdEZpZWxkKSB7XG4gICAgaWYgKHRoaXMucGlja2xpc3RzICYmIGZpZWxkLmRhdGFTb3VyY2UgJiYgZmllbGQuZGF0YVNvdXJjZS5xdWVyeT8uZmlsdGVycy5sZW5ndGgpIHtcbiAgICAgIGNvbnN0IHNlbGVjdGVkUGlja2xpc3Q6IGFueSA9IHRoaXMucGlja2xpc3RzW2ZpZWxkLmRhdGFTb3VyY2UucXVlcnkuZmlsdGVyc1swXS52YWx1ZV07XG4gICAgICBjb25zdCBkaXNwbGF5Q29uZGl0aW9uczogYW55ID0gZmllbGQuZGlzcGxheUNvbmRpdGlvbnMgfHwge307XG4gICAgICBpZiAoc2VsZWN0ZWRQaWNrbGlzdCkge1xuICAgICAgICBmb3JFYWNoKHNlbGVjdGVkUGlja2xpc3QsIChvcHRpb246IGFueSkgPT4ge1xuICAgICAgICAgIGNvbnN0IHV1aWQgPSB0aGlzLmdldEVuZFBhdGhOYW1lLnRyYW5zZm9ybShvcHRpb25bJ0BpZCddKTtcbiAgICAgICAgICBpZiAoIWRpc3BsYXlDb25kaXRpb25zW3V1aWRdIHx8IChmaWVsZC5mb3JtVHlwZSA9PT0gRmllbGQuQnVpbHRJblR5cGUuTVVMVElTRUxFQ1RfUElDS0xJU1QgJiYgWydkaXNhYmxlZCcsICdlbmFibGVkX2NvbmRpdGlvbiddLmluZGV4T2YoZGlzcGxheUNvbmRpdGlvbnNbdXVpZF0udmlzaWJpbGl0eSkgPiAtMSkpIHtcbiAgICAgICAgICAgIGNvbnN0IGRpc3BsYXlDb25kaXRpb24gPSB7XG4gICAgICAgICAgICAgIHZpc2liaWxpdHk6ICd2aXNpYmxlJyxcbiAgICAgICAgICAgICAgY29uZGl0aW9uczogbnVsbFxuICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIGRpc3BsYXlDb25kaXRpb25zW3V1aWRdID0gZGlzcGxheUNvbmRpdGlvbjtcbiAgICAgICAgICB9XG4gICAgICAgICAgb3B0aW9uLnZpc2liaWxpdHkgPSBkaXNwbGF5Q29uZGl0aW9uc1t1dWlkXS52aXNpYmlsaXR5O1xuICAgICAgICAgIG9wdGlvbi5fY29uZGl0aW9ucyA9IGRpc3BsYXlDb25kaXRpb25zW3V1aWRdLmNvbmRpdGlvbnM7XG4gICAgICAgIH0pO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgZmllbGQuZGF0YVNvdXJjZS5xdWVyeS5maWx0ZXJzWzBdLnZhbHVlID0gbnVsbDtcbiAgICAgIH1cbiAgICAgIGZpZWxkLmRpc3BsYXlDb25kaXRpb25zID0gZGlzcGxheUNvbmRpdGlvbnM7XG4gICAgfVxuICB9XG5cbn1cbiIsIjxkaXYgY2xhc3M9XCJjbGVhcmZpeFwiPlxuICA8ZGl2IGNsYXNzPVwiZmxvYXQtc3RhcnQgcGFkZGluZy1yaWdodC0yMHB4IHctNTBcIj5cbiAgICA8bGFiZWwgY2xhc3M9XCJjb250cm9sLWxhYmVsIGxhYmVsLWZvbnRcIiBmb3I9XCJmaWVsZFR5cGVcIj5TZWxlY3QgRmllbGQgVHlwZVxuICAgIDwvbGFiZWw+XG4gICAgPHNlbGVjdCBjbGFzcz1cImZvcm0tY29udHJvbCBmb3JtLWNvbnRyb2wtc20gbWFyZ2luLXRvcC02cHhcIiBpZD1cImZpZWxkVHlwZVwiIG5hbWU9XCJmaWVsZFR5cGVcIlxuICAgICAgW2Rpc2FibGVkXT1cImZpZWxkLnN5c3RlbVwiIFsobmdNb2RlbCldPVwiZmllbGRDb3B5LmZvcm1UeXBlXCIgKGNoYW5nZSk9XCJmaWVsZFR5cGVDaGFuZ2VkKCdtYWluRmllbGQnKVwiPlxuICAgICAgPG9wdGlvbiAqbmdGb3I9XCJsZXQgZmllbGQgb2YgcHJpbWFyeUZpZWxkcztcIiBbdmFsdWVdPVwiZmllbGQuZm9ybVR5cGVcIj57eyBmaWVsZC50aXRsZSB9fTwvb3B0aW9uPlxuICAgIDwvc2VsZWN0PlxuICA8L2Rpdj5cbiAgPGRpdiAqbmdJZj1cImZpZWxkQ29weS5mb3JtVHlwZSA9PT0gJ3RleHQnXCIgY2xhc3M9XCJmbG9hdC1zdGFydCBwYWRkaW5nLXJpZ2h0LTIwcHggdy01MCBsYWJlbC1mb250XCI+XG4gICAgPGxhYmVsIGNsYXNzPVwiY29udHJvbC1sYWJlbFwiIGZvcj1cInRleHRGaWVsZFN1YlR5cGVcIj5TZWxlY3QgU3ViIFR5cGVcbiAgICA8L2xhYmVsPlxuICAgIDxzZWxlY3QgY2xhc3M9XCJmb3JtLWNvbnRyb2wgZm9ybS1jb250cm9sLXNtIG1hcmdpbi10b3AtNnB4XCIgaWQ9XCJ0ZXh0RmllbGRTdWJUeXBlXCIgbmFtZT1cInRleHRGaWVsZFN1YlR5cGVcIlxuICAgICAgW2Rpc2FibGVkXT1cImZpZWxkLnN5c3RlbVwiIChjaGFuZ2UpPVwiZmllbGRUeXBlQ2hhbmdlZCgnc3ViRmllbGQnKVwiIFsobmdNb2RlbCldPVwiZmllbGQuZm9ybVR5cGVcIj5cbiAgICAgIDxvcHRpb24gKm5nRm9yPVwibGV0IGZpZWxkIG9mIHRleHRGaWVsZFN1YlR5cGVzO1wiIFt2YWx1ZV09XCJmaWVsZC5mb3JtVHlwZVwiPnt7IGZpZWxkLnRpdGxlIH19PC9vcHRpb24+XG4gICAgPC9zZWxlY3Q+XG4gIDwvZGl2PlxuPC9kaXY+XG48ZGl2ICpuZ0lmPVwic2VsZWN0ZWRGaWVsZC5mb3JtVHlwZSA9PT0gJ3BpY2tsaXN0JyB8fCBzZWxlY3RlZEZpZWxkLmZvcm1UeXBlID09PSAnbXVsdGlzZWxlY3RwaWNrbGlzdCdcIlxuICBjbGFzcz1cIm1hcmdpbi10b3AtMTZweFwiPlxuICA8IS0tIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCIgZGF0YS1uZy1jbGFzcz1cInsnaGFzLWVycm9yJzogKGZvcm0ucGlja2xpc3RTZWxlY3QuJHRvdWNoZWQgJiYgIWZvcm0ucGlja2xpc3RTZWxlY3QuJHZhbGlkKXx8IGZpZWxkLmRhdGFTb3VyY2UucXVlcnkuZmlsdGVyc1swXS52YWx1ZSA9PSAnJ31cIj48L2Rpdj4gLS0+XG4gIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCI+XG4gICAgPGxhYmVsIGNsYXNzPVwibGFiZWwtZm9udFwiIGZvcj1cInNlbGVjdC1waWNrbGlzdFwiPlBpY2tsaXN0PHNwYW4gY2xhc3M9XCJ0ZXh0LWRhbmdlclwiPio8L3NwYW4+PC9sYWJlbD5cbiAgICA8ZGl2PlxuICAgICAgPHNlbGVjdCBjbGFzcz1cImZvcm0tY29udHJvbCBmb3JtLWNvbnRyb2wtc20gbWFyZ2luLXRvcC02cHhcIiBpZD1cInNlbGVjdC1waWNrbGlzdFwiIG5hbWU9XCJzZWxlY3QtcGlja2xpc3RcIlxuICAgICAgICBbZGlzYWJsZWRdPVwic2VsZWN0ZWRGaWVsZC5zeXN0ZW1cIiAoY2hhbmdlKT1cInBpY2tsaXN0U2VsZWN0ZWQoKVwiIFtyZXF1aXJlZF09XCJ0cnVlXCJcbiAgICAgICAgWyhuZ01vZGVsKV09XCJzZWxlY3RlZEZpZWxkLmRhdGFTb3VyY2UucXVlcnkuZmlsdGVyc1swXS52YWx1ZVwiPlxuICAgICAgICA8b3B0aW9uIHZhbHVlPVwibnVsbFwiPlNlbGVjdCBhIFBpY2tsaXN0PC9vcHRpb24+XG4gICAgICAgIDxvcHRpb24gKm5nRm9yPVwibGV0IHBpY2tsaXN0IG9mIHBpY2tsaXN0cztcIiBbdmFsdWVdPVwicGlja2xpc3QudXVpZFwiPnt7IHBpY2tsaXN0Lm5hbWUgfX08L29wdGlvbj5cbiAgICAgIDwvc2VsZWN0PlxuICAgIDwvZGl2PlxuICAgIDwhLS0gPHNlbGVjdCBjbGFzcz1cImZvcm0tY29udHJvbFwiIGlkPVwicGlja2xpc3Qtc2VsZWN0LS17eyAkaW5kZXggfX1cIiBuYW1lPVwicGlja2xpc3RTZWxlY3RcIiBkYXRhLW5nLWRpc2FibGVkPVwiZmllbGQuc3lzdGVtID09PSB0cnVlXCIgZGF0YS1uZy1tb2RlbD1cImZpZWxkLmRhdGFTb3VyY2UucXVlcnkuZmlsdGVyc1swXS52YWx1ZVwiIGRhdGEtbmctcmVxdWlyZWQ9XCJ0cnVlXCIgZGF0YS1uZy1vcHRpb25zPVwicGlja2xpc3ROYW1lIGFzIHBpY2tsaXN0TmFtZSBmb3IgKHBpY2tsaXN0TmFtZSwgcGlja2xpc3RWYWx1ZSkgaW4gcGlja2xpc3ROYW1lc1wiXG4gICAgICAgIGRhdGEtbmctY2hhbmdlPVwidXBkYXRlRmllbGRUeXBlKGZhbHNlLCAnJylcIj5cblxuICAgICAgPC9zZWxlY3Q+XG4gICAgICA8c3BhbiBjbGFzcz1cImZhIGZhLXNvcnQtZGVzY1wiPjwvc3Bhbj5cbiAgICAgIDxkaXYgZGF0YS1jcy1tZXNzYWdlcz1cImZvcm0ucGlja2xpc3RTZWxlY3RcIj48L2Rpdj4gLS0+XG4gIDwvZGl2PlxuICA8IS0tIDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCIgZGF0YS1uZy1zaG93PVwiIWlubGluZVwiPlxuICAgIDxidXR0b24gdHlwZT1cImJ1dHRvblwiIGNsYXNzPVwiYnRuIGJ0bi1zbSBidG4tZGVmYXVsdCBtYXJnaW4tdG9wLTNcIiBkYXRhLW5nLWRpc2FibGVkPVwiZmllbGQuc3lzdGVtID09PSB0cnVlXCIgZGF0YS1uZy1oaWRlPVwibGljZW5zZSAmJiBsaWNlbnNlLmRldGFpbHMuaXNfZGlzdHJpYnV0ZWQgJiYgIGxpY2Vuc2UuZGV0YWlscy5yb2xlICYmIGxpY2Vuc2UuZGV0YWlscy5yb2xlWzBdID09PSAnbWFzdGVyJyAmJiBjdXJyZW50U3RhdGVOYW1lID09PSAnbWFpbi5tdWx0aXRlbmFuY3kucmVtb3RlVGVuYW50TWFuYWdlci5tYW5hZ2VUZW5hbnRNb2R1bGVzLmVkaXRUZW5hbnRNb2R1bGVzJ1wiIGRhdGEtbmctY2xpY2s9XCJxdWlja1BpY2tsaXN0RWRpdG9yKG51bGwpXCIgaWQ9XCJjcmVhdGUtbmV3LXBpY2tsaXN0LWJ0bi0te3sgJGluZGV4IH19XCI+Q3JlYXRlIHBpY2tsaXN0PC9idXR0b24+XG4gICAgPGJ1dHRvbiBkYXRhLW5nLWlmPVwiZmllbGQuZGF0YVNvdXJjZS5xdWVyeS5maWx0ZXJzWzBdLnZhbHVlXCIgdHlwZT1cImJ1dHRvblwiIGNsYXNzPVwiYnRuIGJ0bi1zbSBidG4tZGVmYXVsdCBtYXJnaW4tdG9wLTNcIiBkYXRhLW5nLWRpc2FibGVkPVwiZmllbGQuc3lzdGVtID09PSB0cnVlXCIgZGF0YS1uZy1oaWRlPVwibGljZW5zZSAmJiBsaWNlbnNlLmRldGFpbHMuaXNfZGlzdHJpYnV0ZWQgJiYgIGxpY2Vuc2UuZGV0YWlscy5yb2xlICYmIGxpY2Vuc2UuZGV0YWlscy5yb2xlWzBdID09PSAnbWFzdGVyJyAmJiBjdXJyZW50U3RhdGVOYW1lID09PSAnbWFpbi5tdWx0aXRlbmFuY3kucmVtb3RlVGVuYW50TWFuYWdlci5tYW5hZ2VUZW5hbnRNb2R1bGVzLmVkaXRUZW5hbnRNb2R1bGVzJ1wiIGRhdGEtbmctY2xpY2s9XCJxdWlja1BpY2tsaXN0RWRpdG9yKGZpZWxkLmRhdGFTb3VyY2UucXVlcnkuZmlsdGVyc1swXS52YWx1ZSlcIiBpZD1cIm1vZGlmeS1waWNrbGlzdC1idG5cIj5Nb2RpZnkgcGlja2xpc3Q8L2J1dHRvbj5cbiAgPC9kaXY+IC0tPlxuICA8IS0tIDxkaXYgY2xhc3M9XCJhbGVydCBhbGVydC1pbmZvIG1hcmdpbi10b3Atc21cIiBkYXRhLW5nLXNob3c9XCJsaWNlbnNlICYmIGxpY2Vuc2UuZGV0YWlscy5pc19kaXN0cmlidXRlZCAmJiBsaWNlbnNlLmRldGFpbHMucm9sZSAmJiBsaWNlbnNlLmRldGFpbHMucm9sZVswXSA9PT0gJ21hc3RlcicgJiYgY3VycmVudFN0YXRlTmFtZSA9PT0gJ21haW4ubXVsdGl0ZW5hbmN5LnJlbW90ZVRlbmFudE1hbmFnZXIubWFuYWdlVGVuYW50TW9kdWxlcy5lZGl0VGVuYW50TW9kdWxlcydcIj5cbiAgICAgIDxpIGNsYXNzPVwiaWNvbiBpY29uLWluZm9ybWF0aW9uXCI+PC9pPiZuYnNwOyZuYnNwO1BpY2tsaXN0cyByZWZlcnJlZCBoZXJlIGFyZSBmcm9tIHRoZSBNYXN0ZXIgTm9kZS4gUGxlYXNlIGVuc3VyZSBhIHN5bmMgYmV0d2VlbiB0aGUgcGlja2xpc3RzIGluIE1hc3RlciBhbmQgVGVuYW50IG5vZGVzIGZvciBhbnkgZWRpdCB0byBoYXBwZW4gc3VjY2Vzc2Z1bGx5LlxuICA8L2Rpdj4gLS0+XG4gIDwhLS0gPGRpdiBjbGFzcz1cImZvcm0tZ3JvdXBcIiBkYXRhLW5nLWlmPVwiZmllbGQuZGF0YVNvdXJjZS5xdWVyeS5maWx0ZXJzWzBdLnZhbHVlICYmIHBpY2tsaXN0TmFtZXNbZmllbGQuZGF0YVNvdXJjZS5xdWVyeS5maWx0ZXJzWzBdLnZhbHVlXSAmJiAhaGlkZVZpc2liaWxpdHlcIj5cbiAgICA8ZGl2IGNsYXNzPVwiY2hlY2tib3ggbWFyZ2luLWJvdHRvbS1tZFwiPlxuICAgICAgPGxhYmVsPlxuICAgICAgICA8aW5wdXQgaWQ9XCJwaWNrbGlzdC1pdGVtLXZpc2liaWxpdHlcIiB0eXBlPVwiY2hlY2tib3hcIiBuYW1lPVwicGlja2xpc3QtaXRlbS12aXNpYmlsaXR5XCIgZGF0YS1uZy1tb2RlbD1cIiRwYXJlbnQuZmllbGQuZGF0YVNvdXJjZS51c2VEaXNwbGF5Q29uZGl0aW9uc1wiPiZuYnNwOyZuYnNwO0NvbmZpZ3VyZSBQaWNrbGlzdCBJdGVtIFZpc2liaWxpdHlcbiAgICAgICAgPHNwYW4gZGF0YS11aWItdG9vbHRpcD1cIlBpY2tsaXN0IG9wdGlvbiB2aXNpYmlsaXR5IGFsbG93cyB5b3UgdG8gaGlkZSBwaWNrbGlzdCBpdGVtcyBmb3IgdGhpcyBmaWVsZCBiYXNlZCBvbiBjb25kaXRpb25zXCJcbiAgICAgICAgICBkYXRhLXRvb2x0aXAtYXBwZW5kLXRvLWJvZHk9XCJ0cnVlXCI+PGkgY2xhc3M9XCJpY29uIGljb24taW5mb3JtYXRpb24gZm9udC1TaXplLTEzXCI+PC9pPjwvc3Bhbj5cbiAgICAgIDwvbGFiZWw+XG4gICAgPC9kaXY+XG4gICAgPGRpdiBkYXRhLW5nLXNob3c9XCIkcGFyZW50LmZpZWxkLmRhdGFTb3VyY2UudXNlRGlzcGxheUNvbmRpdGlvbnNcIj5cbiAgICAgIDxkaXYgY2xhc3M9XCJwaWNrbGlzdC1pdGVtLXZpc2liaWxpdHktY29udGFpbmVyXCIgZGF0YS1uZy1yZXBlYXQ9XCIoa2V5LCBvcHRpb24pIGluIHBpY2tsaXN0TmFtZXNbZmllbGQuZGF0YVNvdXJjZS5xdWVyeS5maWx0ZXJzWzBdLnZhbHVlXS5waWNrbGlzdHMgfCBvcmRlckJ5OiAnb3JkZXJJbmRleCdcIj5cbiAgICAgICAgPGRpdiBjbGFzcz1cInJvdyBwYWRkaW5nLWJvdHRvbS1zbVwiPlxuICAgICAgICAgIDxkaXYgY2xhc3M9XCJjb2wtbWQtNCBsYWJlbFwiPlxuICAgICAgICAgICAgPHAgaWQ9XCJ2aWV3LXt7IDo6b3B0aW9uLml0ZW1WYWx1ZSB9fVwiIGRhdGEtbmctaGlkZT1cIm9wdGlvbi5jb2xvclwiIGNsYXNzPVwibWFyZ2luLTAgdGV4dC1sZWZ0IHRleHQtb3ZlcmZsb3cgbGluZS1oZWlnaHQtbm9ybWFsIHt7ZGVmYXVsdENsYXNzfX1cIj5cbiAgICAgICAgICAgICAgPHNwYW4gY2xhc3M9XCJ7eyBkZWZhdWx0Q2xhc3MgPyAncmF0aW5nJzogJycgfX1cIiB0aXRsZT1cInt7IG9wdGlvbi5pdGVtVmFsdWUgJiYgb3B0aW9uLml0ZW1WYWx1ZS5sZW5ndGggPiAwID8gIG9wdGlvbi5pdGVtVmFsdWUgOiAnTm9uZSd9fVwiPnt7IG9wdGlvbi5pdGVtVmFsdWUgJiYgb3B0aW9uLml0ZW1WYWx1ZS5sZW5ndGggPiAwID8gIG9wdGlvbi5pdGVtVmFsdWUgOiAnTm9uZSd9fTwvcD5cbiAgICAgICAgICAgIDxwIGlkPVwidmlldy17eyA6Om9wdGlvbi5pdGVtVmFsdWUgfX1cIiBkYXRhLW5nLXNob3c9XCJvcHRpb24uY29sb3JcIiBjbGFzcz1cIm1hcmdpbi0wIHRleHQtbGVmdCB7e2RlZmF1bHRDbGFzc319XCI+XG4gICAgICAgICAgICA8c3BhbiBjbGFzcz1cInJhdGluZ1wiIGRhdGEtbmctYXR0ci1zdHlsZT1cImJhY2tncm91bmQ6IHt7IG9wdGlvbi5jb2xvciB9fTsgY29sb3I6IHt7IChvcHRpb24uY29sb3IgfCBpc0hleENvbG9yTGlnaHQpID8gJyMwMDAnIDogJyNmZmYnIH19XCI+IHt7IG9wdGlvbi5pdGVtVmFsdWUgfX08L3NwYW4+XG4gICAgICAgICAgICA8L3A+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPGRpdiBjbGFzcz1cImNvbC1tZC04IHZhbFwiPlxuICAgICAgICAgICAgPGRpdiBjbGFzcz1cImNzLXNlbGVjdFwiPlxuICAgICAgICAgICAgICA8c2VsZWN0IGNsYXNzPVwiZm9ybS1jb250cm9sXCIgbmFtZT1cInBpY2tsaXN0LWl0ZW0tdmlzaWJpbGl0eS1kaXNwbGF5LXt7ICRpbmRleCB9fVwiIGRhdGEtbmctbW9kZWw9XCJvcHRpb24uX3Zpc2liaWxpdHlcIiBkYXRhLW5nLXJlcXVpcmVkPVwidHJ1ZVwiIGRhdGEtbmctY2hhbmdlPVwidXBkYXRlUGlja2xpc3RJdGVtVmlzaWJpbGl0eShvcHRpb24pXCI+XG4gICAgICAgICAgICAgICAgPG9wdGlvbiB2YWx1ZT1cInZpc2libGVcIj5WaXNpYmxlPC9vcHRpb24+XG4gICAgICAgICAgICAgICAgPG9wdGlvbiB2YWx1ZT1cImRpc2FibGVkXCIgbmctaWY9XCJmaWVsZC5mb3JtVHlwZSA9PT0gJ3BpY2tsaXN0J1wiPkRpc2FibGVkPC9vcHRpb24+XG4gICAgICAgICAgICAgICAgPG9wdGlvbiB2YWx1ZT1cImhpZGRlblwiPkhpZGRlbjwvb3B0aW9uPlxuICAgICAgICAgICAgICAgIDxvcHRpb24gdmFsdWU9XCJ2aXNpYmxlX2NvbmRpdGlvblwiPkNvbmRpdGlvbmFsbHkgVmlzaWJsZTwvb3B0aW9uPlxuICAgICAgICAgICAgICAgIDxvcHRpb24gdmFsdWU9XCJlbmFibGVkX2NvbmRpdGlvblwiIG5nLWlmPVwiZmllbGQuZm9ybVR5cGUgPT09ICdwaWNrbGlzdCdcIj5Db25kaXRpb25hbGx5IEVuYWJsZWQ8L29wdGlvbj5cbiAgICAgICAgICAgICAgPC9zZWxlY3Q+XG4gICAgICAgICAgICAgIDxzcGFuIGNsYXNzPVwiZmEgZmEtc29ydC1kZXNjXCI+PC9zcGFuPlxuICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgIDwvZGl2PlxuICAgICAgICA8ZGl2IGRhdGEtbmctaWY9XCJvcHRpb24uX3Zpc2liaWxpdHkgPT0gJ3Zpc2libGVfY29uZGl0aW9uJyB8fCBvcHRpb24uX3Zpc2liaWxpdHkgPT0gJ2VuYWJsZWRfY29uZGl0aW9uJ1wiIGNsYXNzPVwicm93XCI+XG4gICAgICAgICAgPGRpdiBjbGFzcz1cImNvbC1tZC0xMiBwYWRkaW5nLWxlZnQtNlwiPlxuICAgICAgICAgICAgPGhyIGNsYXNzPVwibWFyZ2luLXRvcC1zbSBtYXJnaW4tYm90dG9tLW1kXCI+XG4gICAgICAgICAgICA8ZGl2IGRhdGEtY3MtY29uZGl0aW9uYWwgZGF0YS1lbmFibGUtbmVzdGVkLWZpbHRlcj1cIiRwYXJlbnQuZW5hYmxlTmVzdGVkRmlsdGVyXCIgZGF0YS1maWVsZHM9XCIkcGFyZW50Lm1vZHVsZUZpZWxkc1wiIGRhdGEtbmctbW9kZWw9XCJvcHRpb24uX2NvbmRpdGlvbnNcIiBkYXRhLXZhbHVlLWNoYW5nZWQtcGFyYW09XCJvcHRpb25cIiBkYXRhLXZhbHVlLWNoYW5nZWQ9XCJ1cGRhdGVQaWNrbGlzdEl0ZW1WaXNpYmlsaXR5XCIgZGF0YS1mb3JtLW5hbWU9XCInZmllbGRTZWxlY3RGb3JtJ1wiPjwvZGl2PlxuICAgICAgICAgIDwvZGl2PlxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvZGl2PlxuICAgIDwvZGl2PlxuICA8L2Rpdj4gLS0+XG48L2Rpdj5cbiJdfQ==