import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import * as i0 from "@angular/core";
export class EditorService {
    constructor() {
        this.loaded = false;
        this.loadingFinished = new Subject();
    }
    finishLoading() {
        this.loaded = true;
        this.loadingFinished.next();
    }
    load() {
        // load the assets
        const baseUrl = './assets' + '/monaco-editor/min/vs';
        if (typeof window.monaco === 'object') {
            this.finishLoading();
            return;
        }
        const onGotAmdLoader = () => {
            // load Monaco
            window.require.config({ paths: { vs: `${baseUrl}` } });
            window.require([`vs/editor/editor.main`], () => {
                this.finishLoading();
            });
        };
        // load AMD loader, if necessary
        if (!window.require) {
            const loaderScript = document.createElement('script');
            loaderScript.type = 'text/javascript';
            loaderScript.src = `${baseUrl}/loader.js`;
            loaderScript.addEventListener('load', onGotAmdLoader);
            document.body.appendChild(loaderScript);
        }
        else {
            onGotAmdLoader();
        }
    }
    static { this.ɵfac = function EditorService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditorService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: EditorService, factory: EditorService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root',
            }]
    }], () => [], null); })();
//# sourceMappingURL=data:application/json;base64,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