import { Component, Input, ViewChild, ElementRef, ChangeDetectionStrategy } from '@angular/core';
import { TreeComponent } from '@ali-hm/angular-tree-component';
import { CommonModule } from '@angular/common';
import { ContextMenuComponent } from '../context-menu/context-menu.component';
import * as i0 from "@angular/core";
import * as i1 from "./editor.service";
import * as i2 from "@angular/common";
const _c0 = ["editor"];
const _c1 = ["nodeInput"];
const _c2 = a0 => ({ "code-editor": a0 });
const _c3 = (a0, a1) => ({ "col-lg-2": a0, "explorer-collapsed": a1 });
const _c4 = a0 => ({ "tab-selected": a0 });
function IdeComponent_div_2_div_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtext(1, "EXPLORER");
    i0.ɵɵelementEnd();
} }
function IdeComponent_div_2_div_5_div_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 21);
    i0.ɵɵelement(1, "xf-context-menu", 22);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance();
    i0.ɵɵproperty("menuItems", ctx_r1.getMenuOption(ctx_r1.selectedNode.data))("menuClickOut", ctx_r1.menuClickOut)("contextMenuPosition", ctx_r1.contextMenuPosition);
} }
function IdeComponent_div_2_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 17)(1, "div", 18);
    i0.ɵɵelement(2, "div", 19);
    i0.ɵɵtemplate(3, IdeComponent_div_2_div_5_div_3_Template, 2, 3, "div", 20);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance(3);
    i0.ɵɵproperty("ngIf", ctx_r1.contextMenuClicked);
} }
function IdeComponent_div_2_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 10)(1, "div", 11);
    i0.ɵɵtemplate(2, IdeComponent_div_2_div_2_Template, 2, 0, "div", 12);
    i0.ɵɵelementStart(3, "div", 13);
    i0.ɵɵlistener("click", function IdeComponent_div_2_Template_div_click_3_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.collapsed = !ctx_r1.collapsed); });
    i0.ɵɵelementEnd();
    i0.ɵɵelement(4, "div", 14);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, IdeComponent_div_2_div_5_Template, 4, 1, "div", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction2(4, _c3, !ctx_r1.collapsed, ctx_r1.collapsed));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.collapsed);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngClass", ctx_r1.collapsed ? "fa-caret-right fload-start" : "fa-caret-left float-end");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", !ctx_r1.collapsed);
} }
function IdeComponent_div_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 23);
} }
function IdeComponent_div_5_li_2_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "li", 27)(1, "div", 28)(2, "a", 29);
    i0.ɵɵlistener("click", function IdeComponent_div_5_li_2_Template_a_click_2_listener() { const file_r4 = i0.ɵɵrestoreView(_r3).$implicit; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.setSelectedTab(file_r4)); });
    i0.ɵɵelementStart(3, "span");
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(5, "i", 30);
    i0.ɵɵlistener("click", function IdeComponent_div_5_li_2_Template_i_click_5_listener() { const i_r5 = i0.ɵɵrestoreView(_r3).index; const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.closeFile(i_r5)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const file_r4 = ctx.$implicit;
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(2, _c4, file_r4.selected));
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate(file_r4.name);
} }
function IdeComponent_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 24)(1, "ul", 25);
    i0.ɵɵtemplate(2, IdeComponent_div_5_li_2_Template, 6, 4, "li", 26);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngForOf", ctx_r1.openedFiles);
} }
function IdeComponent_div_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtext(1, " Loading Editor ... ");
    i0.ɵɵelementEnd();
} }
export class IdeComponent {
    constructor(EditorService, changeDetectorRef) {
        this.EditorService = EditorService;
        this.changeDetectorRef = changeDetectorRef;
        // Editor
        this.loadIde = false;
        this.editorOptions = {
            theme: 'vs-light',
            automaticLayout: true,
            inlayHints: true
        };
        this.editorLanguageMap = {
            'js': 'javascript',
            'ts': 'typescript',
            'html': 'html',
            'css': 'css',
            'json': 'json',
            'py': 'python',
            'txt': 'javascript'
        };
        this.monacoEditorLoaded = false;
        // Context Menu
        this.contextMenuClicked = false;
        this.contextMenuPosition = {
            x: 0,
            y: 0
        };
        this.nodeCMItems = [{
                label: 'Rename',
                name: 'rename',
                click: () => this.onRenameNode()
            }, {
                label: 'Copy Path',
                name: 'copyPath'
            }, {
                label: 'Delete',
                name: 'deleteNode',
                click: () => this.deleteNode()
            }];
        this.rootNodeCMItems = [{
                label: 'New File',
                name: 'newNode',
                click: () => this.onAddNode()
            }, {
                label: 'New Folder',
                name: 'newGroupNode',
                click: () => this.onAddGroupNode()
            }];
        this.groupNodeCMItems = [{
                label: 'New File',
                name: 'newNode',
                click: () => this.onAddNode()
            }, {
                label: 'New Folder',
                name: 'newGroupNode',
                click: () => this.onAddGroupNode()
            }, {
                label: 'Delete',
                name: 'deleteGroupNode',
                click: () => this.deleteNode()
            }, {
                label: 'Rename',
                name: 'rename',
                click: () => this.onRenameNode()
            }];
        this.contextMeuClickMap = {
            'rename': () => this.onRenameNode(),
            'newNode': () => this.onAddNode(),
            'deleteNode': () => this.deleteNode(),
            'newGroupNode': () => this.onAddGroupNode(),
            'deleteGroupNode': () => this.deleteGroupNode()
        };
        // Tree
        this.collapsed = false;
        this.actionMapping = {
            mouse: {
                click: (tree, node, $event) => this.onOpenNode(node, $event),
                contextMenu: (tree, node, $event) => this.onOpenContextMenu(node, $event)
            },
        };
        this.treeOptions = {
            displayField: 'name',
            idField: 'id',
            isExpandedField: 'expanded',
            hasChildrenField: 'isFolder',
            childrenField: 'files',
            actionMapping: this.actionMapping
        };
        this.menuClickOut = () => {
            this.contextMenuClicked = false;
        };
    }
    ngOnInit() {
        if (!this.EditorService.loaded) {
            this.EditorService.load();
            this.EditorService.loadingFinished.subscribe(() => {
                this.monacoEditorLoaded = true;
                monaco.languages.typescript.typescriptDefaults.setCompilerOptions({
                    experimentalDecorators: true,
                    allowSyntheticDefaultImports: true,
                    moduleResolution: monaco.languages.typescript.ModuleResolutionKind.NodeJs,
                    allowNonTsExtensions: true,
                    target: monaco.languages.typescript.ScriptTarget.ES2020,
                });
                this.changeDetectorRef.detectChanges();
                this.loadEditor();
            });
        }
        else {
            this.monacoEditorLoaded = true;
            this.changeDetectorRef.detectChanges();
            this.loadEditor();
        }
    }
    ngOnDestroy() {
        monaco.editor.getModels().forEach((m) => m.dispose());
        // destroy the editor as well?
    }
    loadEditor() {
        this.editorOptions.language = this.editorLanguageMap[this.openedFiles[0].ext];
        this.openedFiles[0].model = monaco.editor.createModel(this.openedFiles[0].fileContent, this.editorLanguageMap[this.openedFiles[0].ext]);
        this.editorOptions.model = this.openedFiles[0].model;
        this.monacoEditor = monaco.editor.create(this.editor.nativeElement, this.editorOptions);
        this.detectContentChange(this.openedFiles[0]);
    }
    getMenuOption(nodeData) {
        if (nodeData.isRootFolder) {
            return this.rootNodeCMItems;
        }
        else if (nodeData.isFolder && !nodeData.isRootFolder) {
            return this.groupNodeCMItems;
        }
        else {
            return this.nodeCMItems;
        }
    }
    onOpenContextMenu(node, event) {
        event.preventDefault();
        this.contextMenuClicked = true;
        this.selectedNode = node;
        this.contextMenuPosition.x = event.x;
        this.contextMenuPosition.y = event.y;
    }
    inputFileKeyUp(newValue, node) {
        if (newValue === '') {
            node.parent.data.files = node.parent.data.files.filter((file) => { return file.xpath !== node.data.xpath; });
            this.tree.treeModel.update();
        }
        else {
            if (!node.data.isFolder) {
                this.addNode(newValue, node);
            }
            else if (node.data.isFolder) {
                this.addGroupNode(newValue, node);
            }
        }
    }
    inputFocusOut(newValue, node) {
        if (newValue !== '') {
            if (!node.data.isFolder && node.data.new) {
                this.addNode(newValue, node);
            }
            else if (!node.data.isFolder && node.data.rename) {
                this.renameNode(newValue, node);
            }
            else if (node.data.isFolder && node.data.new) {
                this.addGroupNode(newValue, node);
            }
            else if (node.data.isFolder && node.data.rename) {
                this.renameNode(newValue, node);
            }
        }
        else {
            node.parent.data.files = node.parent.data.files.filter((file) => { return file.xpath !== node.data.xpath; });
            this.tree.treeModel.update();
        }
    }
    autoFocusInput() {
        setTimeout(() => {
            this.tref.nativeElement.focus();
        }, 10);
    }
    // File Operations
    onOpenNode(node, event) {
        this.selectedNode = node;
        if (!node.data.isFolder && !node.data.rename && !node.data.new) {
            let file = node.data;
            this.treeOperationAPI.openNode(file).subscribe((response) => {
                file.fileContent = response.fileContent;
                this.openedFiles.push(file);
                this.setSelectedTab(file);
            });
        }
    }
    onAddNode(node = null) {
        this.contextMenuClicked = false;
        if (node) {
            this.selectedNode = node;
        }
        this.selectedNode.data.files.unshift({ name: '', new: true, isFolder: false, xpath: this.selectedNode.data.xpath + '/tmp' });
        this.tree.treeModel.update();
        this.autoFocusInput();
    }
    addNode(newValue, node) {
        node.data.name = false;
        let newNodePath = '/' + node.data.xpath.substr(0, node.data.xpath.lastIndexOf('/')) + '/' + newValue;
        let oldNodePath = node.data.xpath; // in case api fails
        node.data.xpath = newNodePath;
        node.data.name = newValue;
        node.data.ext = newValue.split('/').pop()?.split('.').pop();
        this.treeOperationAPI.createNode(node.data).subscribe(() => {
            node.data.new = false;
            this.openedFiles.push(node.data);
            this.tree.treeModel.update();
            this.setSelectedTab(node.data);
        });
    }
    onRenameNode() {
        this.contextMenuClicked = false;
        this.selectedNode.data.rename = true;
        this.tree.treeModel.update();
        this.autoFocusInput();
    }
    renameNode(newValue, node) {
        node.data.rename = false;
        if (newValue !== node.data.name) {
            let oldValue = node.data.name; // needed in case API call fails
            this.treeOperationAPI.renameNode(node.data).subscribe((response) => {
                node.data.xpath = response.newData.xpath;
                node.data.name = newValue;
                this.tree.treeModel.update();
                this.updateOpenedFiles(response.oldData.xpath, response.newData);
            });
        }
        else {
            this.tree.treeModel.update();
        }
    }
    deleteNode() {
        this.treeOperationAPI.deleteNode(this.selectedNode.data).subscribe(() => {
            this.selectedNode.parent.data.files = this.selectedNode.parent.data.files.filter((file) => { return file.xpath !== this.selectedNode.data.xpath; });
            this.tree.treeModel.update();
            // this.removeOpenedFile(file.identifier);
        });
    }
    // Folder Operations
    onAddGroupNode(node = null) {
        this.contextMenuClicked = false;
        if (node) {
            this.selectedNode = node;
        }
        this.selectedNode.data.files.unshift({ name: '', new: true, isFolder: true, xpath: this.selectedNode.data.xpath + '/tmp', expanded: false, files: [] });
        this.tree.treeModel.update();
        this.autoFocusInput();
    }
    addGroupNode(newValue, node) {
        node.data.name = false;
        let newNodePath = node.data.xpath.substr(0, node.data.xpath.lastIndexOf('/')) + '/' + newValue;
        let oldNodePath = node.data.xpath; // in case api fails
        node.data.xpath = newNodePath;
        node.data.name = newValue;
        this.treeOperationAPI.createGroupNode(node.data).subscribe(() => {
            node.data.new = false;
            this.tree.treeModel.update();
        });
    }
    deleteGroupNode() {
        if (this.selectedNode && !this.selectedNode.data.isRootFolder) {
            this.treeOperationAPI.deleteGroupNode(this.selectedNode.data).subscribe(() => {
                this.selectedNode.parent.data.files = this.selectedNode.parent.data.files.filter((file) => { return file.xpath !== this.selectedNode.data.xpath; });
                this.tree.treeModel.update();
            });
        }
    }
    // Editor Operations
    detectContentChange(file) {
        const model = this.monacoEditor.getModel();
        model.onDidChangeContent(() => {
            this.updateOpenedFiles(file.xpath, { fileContent: model.getValue(), fileContentChanged: true });
        });
    }
    loadSelectedTab(file) {
        this.monacoEditor.setModel(file.model);
        this.monacoEditor.restoreViewState(file.state);
        this.monacoEditor.focus();
        this.detectContentChange(file);
        this.changeDetectorRef.detectChanges();
    }
    setSelectedTab(file) {
        this.openedFiles.forEach((f, i) => {
            if (file.xpath === f.xpath) {
                this.openedFiles[i].selected = true;
                this.openedFiles[i].state = this.monacoEditor.saveViewState();
                if (!this.openedFiles[i].model) {
                    this.openedFiles[i].model = monaco.editor.createModel(file.fileContent, this.editorLanguageMap[file.ext], this.editorLanguageMap[file.ext].compilerOptions);
                    this.editorOptions.model = this.openedFiles[i].model;
                }
                this.loadSelectedTab(file);
            }
            else {
                this.openedFiles[i].selected = false;
            }
        });
        this.changeDetectorRef.detectChanges();
    }
    closeFile(index) {
        this.openedFiles.splice(index, 1);
    }
    updateOpenedFiles(identifier, data) {
        let index = this.openedFiles.findIndex(file => file.identifier === identifier);
        let oldData = this.openedFiles[index];
        let updatedData = { ...oldData, ...data };
        this.openedFiles[index] = updatedData;
    }
    removeOpenedFile(identifier) {
        let index = this.openedFiles.findIndex(file => file.identifier === identifier);
        if (index > -1) {
            this.openedFiles.splice(index, 1);
        }
    }
    static { this.ɵfac = function IdeComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || IdeComponent)(i0.ɵɵdirectiveInject(i1.EditorService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: IdeComponent, selectors: [["xf-ide"]], viewQuery: function IdeComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(_c1, 5, ElementRef);
            i0.ɵɵviewQuery(TreeComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.editor = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.tref = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.tree = _t.first);
        } }, inputs: { treeData: "treeData", openedFiles: "openedFiles", treeOperationAPI: "treeOperationAPI" }, standalone: true, features: [i0.ɵɵStandaloneFeature], decls: 10, vars: 8, consts: [["editor", ""], [1, "ide"], [1, "body"], ["class", "explorer", 3, "ngClass", 4, "ngIf"], [1, "editor-wrapper", 3, "ngClass"], ["class", "editor-settings", 4, "ngIf"], ["class", "editor-tabs", 4, "ngIf"], [4, "ngIf"], [3, "ngClass"], [1, "editor"], [1, "explorer", 3, "ngClass"], [1, "margin-top-sm"], ["class", "float-start font-size-14", 4, "ngIf"], [1, "fa", "padding-top-2", 3, "click", "ngClass"], [1, "clearfix"], ["class", "tree-wrapper", 4, "ngIf"], [1, "float-start", "font-size-14"], [1, "tree-wrapper"], [1, "container"], [1, "box"], ["class", "overlay", 4, "ngIf"], [1, "overlay"], [1, "absolute-position", 3, "menuItems", "menuClickOut", "contextMenuPosition"], [1, "editor-settings"], [1, "editor-tabs"], [1, "nav", "nav-tabs"], ["class", "uib-tab nav-item", 3, "ngClass", 4, "ngFor", "ngForOf"], [1, "uib-tab", "nav-item", 3, "ngClass"], [1, "tab"], [1, "nav-link", "name", 3, "click"], ["role", "button", 1, "close", "fa", "fa-close", 3, "click"]], template: function IdeComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2);
            i0.ɵɵtemplate(2, IdeComponent_div_2_Template, 6, 7, "div", 3);
            i0.ɵɵelementStart(3, "div", 4);
            i0.ɵɵtemplate(4, IdeComponent_div_4_Template, 1, 0, "div", 5)(5, IdeComponent_div_5_Template, 3, 1, "div", 6)(6, IdeComponent_div_6_Template, 2, 0, "div", 7);
            i0.ɵɵelementStart(7, "div", 8);
            i0.ɵɵelement(8, "div", 9, 0);
            i0.ɵɵelementEnd()()()();
        } if (rf & 2) {
            i0.ɵɵadvance(2);
            i0.ɵɵproperty("ngIf", ctx.treeData);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", ctx.collapsed ? "col-lg-11 editor-wrapper-expanded" : "col-lg-10 editor-wrapper-collapsed");
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.openedFiles.length > 0);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.monacoEditorLoaded);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.monacoEditorLoaded);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c2, ctx.monacoEditorLoaded));
        } }, dependencies: [CommonModule, i2.NgClass, i2.NgForOf, i2.NgIf, ContextMenuComponent], styles: [".ide[_ngcontent-%COMP%]{padding-left:25px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]{display:flex}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer[_ngcontent-%COMP%]{padding-top:10px;float:left;width:140px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer[_ngcontent-%COMP%]   .tree-wrapper[_ngcontent-%COMP%]{border:1px solid;overflow-x:auto;overflow-y:auto;height:calc(100vh - 160px);width:auto;padding-left:10px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer[_ngcontent-%COMP%]   .root-node[_ngcontent-%COMP%]   .item[_ngcontent-%COMP%]{margin-left:10px;margin-right:2px;font-size:12px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer[_ngcontent-%COMP%]   .node-selected[_ngcontent-%COMP%]{color:red}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .explorer-collapsed[_ngcontent-%COMP%]{margin-top:5px;border:1px solid;height:calc(100vh - 60px)}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]{margin:5px;float:right}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-settings[_ngcontent-%COMP%]{border:1px solid;height:40px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-tabs[_ngcontent-%COMP%]{margin-top:2px;border:1px solid;height:auto}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-tabs[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]{display:flex}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-tabs[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]   .name[_ngcontent-%COMP%]{padding-left:5px;padding-right:5px;cursor:pointer}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .editor-tabs[_ngcontent-%COMP%]   .tab[_ngcontent-%COMP%]   .close[_ngcontent-%COMP%]{margin-top:13px;margin-right:10px}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .tab-selected[_ngcontent-%COMP%]{background:var(--navbar-active-bg-color)}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   .code-editor[_ngcontent-%COMP%]{height:70vh}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper[_ngcontent-%COMP%]   [hidden][_ngcontent-%COMP%]{display:none!important}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper-collapsed[_ngcontent-%COMP%]{width:calc(80vw - 118px)}.ide[_ngcontent-%COMP%]   .body[_ngcontent-%COMP%]   .editor-wrapper-expanded[_ngcontent-%COMP%]{width:calc(90vw - 45px)}.ide[_ngcontent-%COMP%]   .editor[_ngcontent-%COMP%]{height:100%;border:1px solid!important;overflow:auto}.ide[_ngcontent-%COMP%]   .container[_ngcontent-%COMP%]{position:relative}.ide[_ngcontent-%COMP%]   .box[_ngcontent-%COMP%]{position:absolute;top:0;left:0}.ide[_ngcontent-%COMP%]   .overlay[_ngcontent-%COMP%]{z-index:9}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(IdeComponent, [{
        type: Component,
        args: [{ standalone: true, imports: [CommonModule, ContextMenuComponent], selector: 'xf-ide', changeDetection: ChangeDetectionStrategy.OnPush, template: "<!-- Copyright start\n  Copyright (C) 2008 - 2022 Fortinet Inc.\n  All rights reserved.\n  FORTINET CONFIDENTIAL & FORTINET PROPRIETARY SOURCE CODE\n  Copyright end -->\n\n\n<div class=\"ide\">\n  <div class=\"body\">\n    <!-- Tree -->\n    <div *ngIf=\"treeData\" class=\"explorer\" [ngClass]=\"{'col-lg-2' : !collapsed, 'explorer-collapsed': collapsed}\">\n      <div class=\"margin-top-sm\">\n        <div class=\"float-start font-size-14\" *ngIf=\"!collapsed\">EXPLORER</div>\n        <div class=\"fa padding-top-2\" (click)=\"collapsed = !collapsed\"\n          [ngClass]=\"collapsed ? 'fa-caret-right fload-start' : 'fa-caret-left float-end'\"></div>\n        <div class=\"clearfix\"></div>\n      </div>\n      <div *ngIf=\"!collapsed\" class=\"tree-wrapper\">\n\n        <div class=\"container\">\n          <div class=\"box\">\n            <!-- <tree-root #tree class=\"relative-position\" [nodes]=\"treeData\" [options]=\"treeOptions\">\n              <ng-template #treeNodeTemplate let-node let-index=\"index\">\n                <span *ngIf=\"!node.data.rename && !node.data.new\" [ngClass]=\"{'node-selected': node.isFocused}\">{{\n                  node.data.name\n                  }}</span>\n                <span *ngIf=\"node.data.isRootFolder\" class=\"root-node\">\n                  <em class=\"fa fa-file item\" (click)=\"onAddNode(node)\"></em>\n                  <em class=\"fa fa-folder item\" (click)=\"onAddGroupNode(node)\"></em>\n                  <em class=\" fa fa-upload item\"></em>\n                  <em class=\"fa fa-trash item\" (click)=\"node.data.isFolder ? deleteGroupNode() : deleteNode()\"></em>\n                </span>\n                <input *ngIf=\"node.data.rename || node.data.new\" #nodeInput type=\"text\" value=\"{{ node.data.name }}\"\n                  (keyup.enter)=\"inputFileKeyUp(nodeInput.value, node)\"\n                  (focusout)=\"inputFocusOut(nodeInput.value, node)\">\n\n              </ng-template>\n            </tree-root> -->\n\n          </div>\n          <div *ngIf=\"contextMenuClicked\" class=\"overlay\">\n            <xf-context-menu class=\"absolute-position\" [menuItems]=\"getMenuOption(selectedNode.data)\"\n              [menuClickOut]=\"menuClickOut\" [contextMenuPosition]=\"contextMenuPosition\">\n            </xf-context-menu>\n          </div>\n        </div>\n      </div>\n    </div>\n    <!-- Editor  -->\n    <div class=\"editor-wrapper\"\n      [ngClass]=\"collapsed ? 'col-lg-11 editor-wrapper-expanded' : 'col-lg-10 editor-wrapper-collapsed'\">\n      <div *ngIf=\"openedFiles.length > 0\" class=\"editor-settings\"></div>\n      <div *ngIf=\"monacoEditorLoaded\" class=\"editor-tabs\">\n        <ul class=\"nav nav-tabs\">\n          <li *ngFor=\"let file of openedFiles; let i = index\" class=\"uib-tab nav-item\"\n            [ngClass]=\"{'tab-selected': file.selected}\">\n            <div class=\"tab\">\n              <a (click)=\"setSelectedTab(file)\" class=\"nav-link name\">\n                <span>{{file.name}}</span>\n              </a>\n              <i class=\"close fa fa-close\" (click)=\"closeFile(i)\" role=\"button\"></i>\n            </div>\n\n          </li>\n        </ul>\n      </div>\n      <div *ngIf=\"!monacoEditorLoaded\">\n        Loading Editor ...\n      </div>\n\n      <div [ngClass]=\"{'code-editor': monacoEditorLoaded}\">\n        <div class=\"editor\" #editor></div>\n      </div>\n    </div>\n  </div>\n</div>\n", styles: [".ide{padding-left:25px}.ide .body{display:flex}.ide .body .explorer{padding-top:10px;float:left;width:140px}.ide .body .explorer .tree-wrapper{border:1px solid;overflow-x:auto;overflow-y:auto;height:calc(100vh - 160px);width:auto;padding-left:10px}.ide .body .explorer .root-node .item{margin-left:10px;margin-right:2px;font-size:12px}.ide .body .explorer .node-selected{color:red}.ide .body .explorer-collapsed{margin-top:5px;border:1px solid;height:calc(100vh - 60px)}.ide .body .editor-wrapper{margin:5px;float:right}.ide .body .editor-wrapper .editor-settings{border:1px solid;height:40px}.ide .body .editor-wrapper .editor-tabs{margin-top:2px;border:1px solid;height:auto}.ide .body .editor-wrapper .editor-tabs .tab{display:flex}.ide .body .editor-wrapper .editor-tabs .tab .name{padding-left:5px;padding-right:5px;cursor:pointer}.ide .body .editor-wrapper .editor-tabs .tab .close{margin-top:13px;margin-right:10px}.ide .body .editor-wrapper .tab-selected{background:var(--navbar-active-bg-color)}.ide .body .editor-wrapper .code-editor{height:70vh}.ide .body .editor-wrapper [hidden]{display:none!important}.ide .body .editor-wrapper-collapsed{width:calc(80vw - 118px)}.ide .body .editor-wrapper-expanded{width:calc(90vw - 45px)}.ide .editor{height:100%;border:1px solid!important;overflow:auto}.ide .container{position:relative}.ide .box{position:absolute;top:0;left:0}.ide .overlay{z-index:9}\n"] }]
    }], () => [{ type: i1.EditorService }, { type: i0.ChangeDetectorRef }], { treeData: [{
            type: Input
        }], openedFiles: [{
            type: Input
        }], treeOperationAPI: [{
            type: Input
        }], editor: [{
            type: ViewChild,
            args: ['editor', { static: false }]
        }], tref: [{
            type: ViewChild,
            args: ["nodeInput", { read: ElementRef }]
        }], tree: [{
            type: ViewChild,
            args: [TreeComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(IdeComponent, { className: "IdeComponent", filePath: "lib/components/ide/ide.component.ts", lineNumber: 20 }); })();
//# sourceMappingURL=data:application/json;base64,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