import { Component, Input } from '@angular/core';
import { concatMap, of } from 'rxjs';
import { API } from '../../../core/constants';
import * as i0 from "@angular/core";
import * as i1 from "@ng-bootstrap/ng-bootstrap";
import * as i2 from "@angular/common/http";
import * as i3 from "../../../core/services/modal.service";
import * as i4 from "@angular/common";
import * as i5 from "@angular/forms";
import * as i6 from "@jsverse/transloco";
import * as i7 from "../../../query-filters/filter-group/filter-group.component";
function BulkDeleteModalComponent_form_0_ng_container_9_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵelementStart(1, "xf-filter-group", 11);
    i0.ɵɵtwoWayListener("ngModelChange", function BulkDeleteModalComponent_form_0_ng_container_9_Template_xf_filter_group_ngModelChange_1_listener($event) { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); i0.ɵɵtwoWayBindingSet(ctx_r1.filterGroup, $event) || (ctx_r1.filterGroup = $event); return i0.ɵɵresetView($event); });
    i0.ɵɵlistener("ngModelChange", function BulkDeleteModalComponent_form_0_ng_container_9_Template_xf_filter_group_ngModelChange_1_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.filterGroupChange()); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵtwoWayProperty("ngModel", ctx_r1.filterGroup);
    i0.ɵɵproperty("entity", ctx_r1.entity);
} }
function BulkDeleteModalComponent_form_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "form", 2, 0);
    i0.ɵɵlistener("ngSubmit", function BulkDeleteModalComponent_form_0_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.runDelete()); });
    i0.ɵɵelementStart(2, "div", 3)(3, "h4", 4);
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(5, "button", 5);
    i0.ɵɵlistener("click", function BulkDeleteModalComponent_form_0_Template_button_click_5_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵelementEnd()();
    i0.ɵɵelementStart(6, "div", 6)(7, "p");
    i0.ɵɵtext(8);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(9, BulkDeleteModalComponent_form_0_ng_container_9_Template, 2, 2, "ng-container", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(10, "div", 8)(11, "button", 9);
    i0.ɵɵlistener("click", function BulkDeleteModalComponent_form_0_Template_button_click_11_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.cancel()); });
    i0.ɵɵtext(12, "Cancel");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(13, "button", 10);
    i0.ɵɵtext(14, "Delete");
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("Delete ", ctx_r1.entity.descriptions.plural, " By Condition");
    i0.ɵɵadvance(4);
    i0.ɵɵtextInterpolate1("", ctx_r1.entity.descriptions.plural, " that match the following filters will be deleted:");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.filterGroup && ctx_r1.entity);
} }
export class BulkDeleteModalComponent {
    constructor(activeModal, http, modalService) {
        this.activeModal = activeModal;
        this.http = http;
        this.modalService = modalService;
        this.filterGroup = null;
    }
    ngOnInit() {
        this.filterGroup = this.query;
    }
    filterGroupChange() {
        if (!this.filterGroup) {
            return;
        }
        this.query = this.filterGroup;
    }
    runDelete() {
        const data = this.query.getQueryObject();
        this.http.post(API.QUERY + this.entity.type, data, {
            params: {
                $limit: 1
            }
        }).pipe(concatMap((response) => {
            return this.modalService.confirm('Are you sure you want to delete ' + response['hydra:totalItems'] + ' ' + this.entity.descriptions.plural + '?')
                .pipe(concatMap((result) => {
                if (!result) {
                    return of();
                }
                return this.http.request('delete', API.DELETE_WITH_QUERY + this.entity.type, { body: data });
            }));
        })).subscribe(() => {
            this.activeModal.close();
        });
    }
    cancel() {
        this.activeModal.dismiss();
    }
    static { this.ɵfac = function BulkDeleteModalComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || BulkDeleteModalComponent)(i0.ɵɵdirectiveInject(i1.NgbActiveModal), i0.ɵɵdirectiveInject(i2.HttpClient), i0.ɵɵdirectiveInject(i3.ModalService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: BulkDeleteModalComponent, selectors: [["xf-bulk-delete-modal"]], inputs: { entity: "entity", query: "query" }, decls: 1, vars: 0, consts: [["formElement", ""], ["name", "generate-shifts", "novalidate", "", 3, "ngSubmit", 4, "transloco"], ["name", "generate-shifts", "novalidate", "", 3, "ngSubmit"], [1, "modal-header"], [1, "modal-title"], ["type", "button", "aria-label", "Close", 1, "btn-close", 3, "click"], [1, "modal-body", "px-3", "pb-5"], [4, "ngIf"], [1, "modal-footer"], ["type", "button", 1, "btn", "btn-outline-dark", 3, "click"], ["type", "submit", 1, "btn", "btn-outline-danger"], ["name", "filterGroup", 3, "ngModelChange", "ngModel", "entity"]], template: function BulkDeleteModalComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, BulkDeleteModalComponent_form_0_Template, 15, 3, "form", 1);
        } }, dependencies: [i4.NgIf, i5.ɵNgNoValidate, i5.NgControlStatus, i5.NgControlStatusGroup, i5.NgModel, i5.NgForm, i6.TranslocoDirective, i7.FilterGroupComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(BulkDeleteModalComponent, [{
        type: Component,
        args: [{ selector: 'xf-bulk-delete-modal', template: "<form name=\"generate-shifts\" (ngSubmit)=\"runDelete()\" novalidate #formElement *transloco=\"let t\">\n  <div class=\"modal-header\">\n    <h4 class=\"modal-title\">Delete {{ entity.descriptions.plural }} By Condition</h4>\n    <button type=\"button\" class=\"btn-close\" aria-label=\"Close\" (click)=\"cancel()\"></button>\n  </div>\n  <div class=\"modal-body px-3 pb-5\">\n    <p>{{ entity.descriptions.plural }} that match the following filters will be deleted:</p>\n    <ng-container *ngIf=\"filterGroup && entity\">\n      <xf-filter-group [(ngModel)]=\"filterGroup\" (ngModelChange)=\"filterGroupChange()\" name=\"filterGroup\" [entity]=\"entity\">\n      </xf-filter-group>\n    </ng-container>\n\n  </div>\n  <div class=\"modal-footer\">\n    <button type=\"button\" class=\"btn btn-outline-dark\" (click)=\"cancel()\">Cancel</button>\n    <button type=\"submit\" class=\"btn btn-outline-danger\">Delete</button>\n  </div>\n</form>\n" }]
    }], () => [{ type: i1.NgbActiveModal }, { type: i2.HttpClient }, { type: i3.ModalService }], { entity: [{
            type: Input
        }], query: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(BulkDeleteModalComponent, { className: "BulkDeleteModalComponent", filePath: "lib/components/modals/bulk-delete-modal/bulk-delete-modal.component.ts", lineNumber: 16 }); })();
//# sourceMappingURL=data:application/json;base64,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