import { ChangeDetectionStrategy, Component, forwardRef, Input } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import { flatten, keyBy, uniq } from 'lodash-es';
import { map, of, zip } from 'rxjs';
import { API, FIXED_MODULE } from '../../core/constants';
import { Person } from '../../core/models/person';
import { Team } from '../../core/models/team';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "ng-multiselect-dropdown";
import * as i5 from "@jsverse/transloco";
const _c0 = ["formControlName", ""];
function UserMultiselectComponent_div_0_ng_template_2_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 7);
} }
function UserMultiselectComponent_div_0_ng_template_2_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 8);
} }
function UserMultiselectComponent_div_0_ng_template_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, UserMultiselectComponent_div_0_ng_template_2_span_1_Template, 1, 0, "span", 5)(2, UserMultiselectComponent_div_0_ng_template_2_span_2_Template, 1, 0, "span", 6);
    i0.ɵɵelementStart(3, "label");
    i0.ɵɵtext(4);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const option_r1 = ctx.option;
    const id_r2 = ctx.id;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r2].type === "team");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r2].type === "user");
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", option_r1, " ");
} }
function UserMultiselectComponent_div_0_ng_template_4_span_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 7);
} }
function UserMultiselectComponent_div_0_ng_template_4_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "span", 8);
} }
function UserMultiselectComponent_div_0_ng_template_4_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, UserMultiselectComponent_div_0_ng_template_4_span_1_Template, 1, 0, "span", 5)(2, UserMultiselectComponent_div_0_ng_template_4_span_2_Template, 1, 0, "span", 6);
    i0.ɵɵtext(3);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const option_r4 = ctx.option;
    const id_r5 = ctx.id;
    const ctx_r2 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r5].type === "team");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r2.getItems[id_r5].type === "user");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", option_r4, " ");
} }
function UserMultiselectComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3)(1, "ng-multiselect-dropdown", 4);
    i0.ɵɵtemplate(2, UserMultiselectComponent_div_0_ng_template_2_Template, 5, 3, "ng-template", null, 0, i0.ɵɵtemplateRefExtractor)(4, UserMultiselectComponent_div_0_ng_template_4_Template, 4, 3, "ng-template", null, 1, i0.ɵɵtemplateRefExtractor);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const t_r6 = ctx.$implicit;
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r2.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("placeholder", t_r6("Select users"))("settings", ctx_r2.dropdownSettings)("data", ctx_r2.userTeamList);
} }
export class UserMultiselectComponent {
    constructor(http, changeDetectorRef, formBuilder) {
        this.http = http;
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.dropdownSettings = {
            singleSelection: false,
            idField: 'uuid',
            textField: 'display',
            selectAllText: 'Select All',
            unSelectAllText: 'Deselect All',
            allowSearchFilter: true
        };
        this.includeTeams = false;
        this.excludeIris = [];
        this.userTeamList = [];
        this.value = [];
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.formGroup = this.formBuilder.group({
            users: [[]]
        });
    }
    writeValue(value) {
        this.value = value;
        this.formGroup.controls.users.setValue(value);
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnChanges() {
        this.loadUsersAndTeams();
    }
    loadUsersAndTeams() {
        zip(this.loadUsers(), this.loadTeams())
            .subscribe((result) => {
            let userTeamList = flatten(result);
            let filteredList = userTeamList.filter((item) => this.excludeIris.indexOf(item.uuid) === -1);
            this.userTeamList = filteredList;
            this.changeDetectorRef.detectChanges();
        });
    }
    ngOnInit() {
        this.formGroup.controls.users.valueChanges.subscribe((items) => {
            let users = uniq(flatten(items.map((item) => {
                const userOrTeam = this.getItems[item.uuid];
                if (userOrTeam instanceof Person) {
                    return userOrTeam.iri;
                }
                else {
                    return userOrTeam.users;
                }
            })));
            this.onChange(users);
        });
    }
    loadUsers() {
        let body = {
            logic: 'AND',
            filters: [{
                    field: 'csActive',
                    operator: 'eq',
                    value: true
                }],
            __selectFields: ['firstname', 'lastname', 'uuid']
        };
        return this.http.post(API.QUERY + FIXED_MODULE.PEOPLE, body)
            .pipe(map((response) => {
            return plainToInstance(Person, response['hydra:member']);
        }));
    }
    loadTeams() {
        if (!this.includeTeams) {
            return of([]);
        }
        let body = {
            logic: 'AND',
            filters: [],
            __selectFields: ['actors', 'name', 'uuid']
        };
        return this.http.post(API.QUERY + FIXED_MODULE.TEAMS, body)
            .pipe(map((response) => {
            return plainToInstance(Team, response['hydra:member']);
        }));
    }
    get getItems() {
        return keyBy(this.userTeamList, 'uuid');
    }
    static { this.ɵfac = function UserMultiselectComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || UserMultiselectComponent)(i0.ɵɵdirectiveInject(i1.HttpClient), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: UserMultiselectComponent, selectors: [["xf-user-multiselect", "formControlName", ""]], inputs: { includeTeams: "includeTeams", excludeIris: "excludeIris" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => UserMultiselectComponent),
                    multi: true
                }]), i0.ɵɵNgOnChangesFeature], attrs: _c0, decls: 1, vars: 0, consts: [["optionsTemplate", ""], ["optionSelectedTemplate", ""], ["class", "minw-300px", 3, "formGroup", 4, "transloco"], [1, "minw-300px", 3, "formGroup"], ["formControlName", "users", "name", "module-select", 3, "placeholder", "settings", "data"], ["class", "fa fa-users me-1", 4, "ngIf"], ["class", "fa fa-user me-1", 4, "ngIf"], [1, "fa", "fa-users", "me-1"], [1, "fa", "fa-user", "me-1"]], template: function UserMultiselectComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, UserMultiselectComponent_div_0_Template, 6, 4, "div", 2);
        } }, dependencies: [i3.NgIf, i4.MultiSelectComponent, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i5.TranslocoDirective], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(UserMultiselectComponent, [{
        type: Component,
        args: [{ selector: 'xf-user-multiselect[formControlName]', changeDetection: ChangeDetectionStrategy.OnPush, providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => UserMultiselectComponent),
                        multi: true
                    }], template: "<div class=\"minw-300px\" *transloco=\"let t\" [formGroup]=\"formGroup\">\n  <ng-multiselect-dropdown [placeholder]=\"t('Select users')\" [settings]=\"dropdownSettings\" [data]=\"userTeamList\"\n    formControlName=\"users\" name=\"module-select\">\n    <ng-template #optionsTemplate let-item let-option=\"option\" let-id=\"id\" let-isSelected=\"isSelected\">\n      <div>\n        <span *ngIf=\"getItems[id].type === 'team'\" class=\"fa fa-users me-1\"></span>\n        <span *ngIf=\"getItems[id].type === 'user'\" class=\"fa fa-user me-1\"></span>\n        <label>\n          {{option}}\n        </label>\n      </div>\n    </ng-template>\n    <ng-template #optionSelectedTemplate let-option=\"option\" let-id=\"id\">\n      <div>\n        <span *ngIf=\"getItems[id].type === 'team'\" class=\"fa fa-users me-1\"></span>\n        <span *ngIf=\"getItems[id].type === 'user'\" class=\"fa fa-user me-1\"></span>\n        {{option}}\n      </div>\n    </ng-template>\n  </ng-multiselect-dropdown>\n</div>\n" }]
    }], () => [{ type: i1.HttpClient }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { includeTeams: [{
            type: Input
        }], excludeIris: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(UserMultiselectComponent, { className: "UserMultiselectComponent", filePath: "lib/components/user-multiselect/user-multiselect.component.ts", lineNumber: 23 }); })();
//# sourceMappingURL=data:application/json;base64,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