import { isArray, isNumber, isString } from "lodash-es";
export class Bitmask {
    constructor(value, padding = 8) {
        this.padding = padding;
        if (isNumber(value) || isString(value)) {
            this.integer = parseInt(value, padding);
            this.bits = this.integerToArray(this.integer, padding);
        }
        else if (isArray(value)) {
            this.bits = value.map((el) => { return parseInt(el) & 1; });
            this.integer = this.arrayToInteger(this.bits);
        }
        else {
            throw "Constructor needs either a number or an array o bits";
        }
    }
    getInteger() {
        return this.integer;
    }
    getBits() {
        return this.bits;
    }
    hasBit(bit) {
        return this.bits[bit] & 1;
    }
    setBit(bit, status) {
        status = status === true ? 1 : 0;
        this.bits[bit] = status;
        this.integer = this.arrayToInteger(this.bits);
    }
    toggleBit(bit) {
        let status = !(this.hasBit(bit));
        this.setBit(bit, status);
    }
    rShift(positions) {
        positions = positions || 1;
        this.integer = this.integer >> positions;
        this.bits = this.integerToArray(this.integer, this.padding);
    }
    lShift(positions) {
        positions = positions || 1;
        this.integer = this.integer << positions;
        this.bits = this.integerToArray(this.integer, this.padding);
    }
    integerToArray(integer, padding) {
        let bits = [];
        while (integer !== 0) {
            bits.push(integer & 1);
            integer = integer >> 1;
            padding--;
        }
        while (padding-- > 0) {
            bits.push(0);
        }
        return bits;
    }
    arrayToInteger(array) {
        return array.reduce((p, c, i) => { return p + Math.pow(2, i) * c; });
    }
}
//# sourceMappingURL=data:application/json;base64,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