import { __decorate } from "tslib";
import { Expose, Type } from "class-transformer";
import { Field } from "./field";
import { CheckboxField } from "../../form-fields/field-types/checkbox";
import { DatetimeField } from "../../form-fields/field-types/datetime";
import { DecimalField } from "../../form-fields/field-types/decimal";
import { EmailField } from "../../form-fields/field-types/email";
import { IntegerField } from "../../form-fields/field-types/integer";
import { ManyToManyField } from "../../form-fields/field-types/manytomany";
import { MultiselectPicklistField } from "../../form-fields/field-types/multiselect-picklist";
import { OneToManyField } from "../../form-fields/field-types/onetomany";
import { PicklistField } from "../../form-fields/field-types/picklist";
import { TextField } from "../../form-fields/field-types/text";
import { FileField } from "../../form-fields/field-types/file";
import { JSONField } from "../../form-fields/field-types/json";
import { PhoneField } from "../../form-fields/field-types/phone";
import { DomainField } from "../../form-fields/field-types/domain";
import { FilehashField } from "../../form-fields/field-types/fileHash";
import { IPv4Field } from "../../form-fields/field-types/ipv4";
import { IPv6Field } from "../../form-fields/field-types/ipv6";
import { RichtextHTMLField } from "../../form-fields/field-types/richtext-html";
import { RichtextMarkdownField } from "../../form-fields/field-types/richtext-markdown";
import { TextareaField } from "../../form-fields/field-types/textarea";
import { URLField } from "../../form-fields/field-types/url";
import { LookupField } from "../../form-fields/field-types/lookup";
import { ArrayField } from "../../form-fields/field-types/array";
import { SelectField } from "../../form-fields/field-types/select";
import { API } from "../constants";
import { forEach } from "lodash-es";
import { ToggleDropdownField } from "../../form-fields/field-types/toggleDropdown";
import { CertificateField } from "../../form-fields/field-types/certificate";
import { TagsField } from "../../form-fields/field-types/tags";
export class Entity {
    constructor(type) {
        this.module = '';
        this.displayName = '';
        this.descriptions = {
            singular: '',
            plural: ''
        };
        this.moduleDescription = '';
        this.defaultSort = [];
        this.uniqueConstraint = [];
        this.display = '';
        //TODO: Use external way to typecast the Field to specific Field type
        this.attributes = [];
        this.values = {};
        this.ownable = false;
        this.primaryKey = 'uuid';
        this.userOwnable = false;
        this.trackable = true;
        this.softDeleteable = false;
        this.queueable = false;
        this.indexable = true;
        this.peerReplicable = false;
        this.system = false;
        this.tableName = '';
        this.taggable = true;
        this.conditionalOwnable = false;
        this.writeable = true;
        this.bulkAction = {
            allow: false,
            buttonClass: 'btn btn-secondary btn-sm',
            buttonIcon: '',
            buttonText: '',
        };
        this.parentType = '';
        this.type = type;
        this.baseUrl = API.BASE + this.type;
    }
    get fields() {
        let fields = {};
        this.attributes.forEach((attribute) => {
            fields[attribute.name] = attribute;
        });
        return fields;
    }
    set fields(_fields) {
        forEach(_fields, (field) => {
            this.fields[field.name] = field;
            const index = this.attributes.findIndex((value) => {
                return value.name === field.name;
            });
            if (index === -1) {
                this.attributes.push(field);
            }
            else {
                this.attributes.splice(index, 0, field);
            }
        });
    }
    get relationships() {
        return this.attributes.filter((attribute) => attribute.isRelationship);
    }
    get iri() {
        return this.baseUrl + this.type + '/' + this.uuid;
    }
    evaluateAllFields() {
        this.attributes.forEach((field) => { });
    }
    get title() {
        return this.descriptions.plural;
    }
    getFormFields() {
        return this.attributes.filter((attribute) => attribute.isFormField);
    }
}
__decorate([
    Expose({ name: 'displayName' })
], Entity.prototype, "displayName", void 0);
__decorate([
    Type(() => Field, {
        discriminator: {
            property: 'formType',
            // Builtins
            subTypes: [
                { value: TextField, name: Field.BuiltInType.TEXT },
                { value: IntegerField, name: Field.BuiltInType.INTEGER },
                { value: CheckboxField, name: Field.BuiltInType.CHECKBOX },
                { value: DecimalField, name: Field.BuiltInType.DECIMAL },
                { value: EmailField, name: Field.BuiltInType.EMAIL },
                { value: DatetimeField, name: Field.BuiltInType.DATETIME },
                { value: MultiselectPicklistField, name: Field.BuiltInType.MULTISELECT_PICKLIST },
                { value: PicklistField, name: Field.BuiltInType.PICKLIST },
                { value: ManyToManyField, name: Field.BuiltInType.MANY_TO_MANY },
                { value: OneToManyField, name: Field.BuiltInType.ONE_TO_MANY },
                { value: FileField, name: Field.BuiltInType.FILE },
                { value: JSONField, name: Field.BuiltInType.JSON },
                { value: ArrayField, name: Field.BuiltInType.ARRAY },
                { value: TagsField, name: Field.BuiltInType.TAGS },
                { value: PhoneField, name: Field.BuiltInType.PHONE },
                { value: DomainField, name: Field.BuiltInType.DOMAIN },
                { value: FilehashField, name: Field.BuiltInType.FILEHASH },
                { value: IPv4Field, name: Field.BuiltInType.IPv4 },
                { value: IPv6Field, name: Field.BuiltInType.IPv6 },
                { value: RichtextHTMLField, name: Field.BuiltInType.RICHTEXTHTML },
                { value: RichtextMarkdownField, name: Field.BuiltInType.RICHTEXTMARKDOWN },
                { value: TextareaField, name: Field.BuiltInType.TEXTAREA },
                { value: LookupField, name: Field.BuiltInType.LOOKUP },
                { value: URLField, name: Field.BuiltInType.URL },
                { value: SelectField, name: Field.BuiltInType.SELECT },
                { value: ToggleDropdownField, name: Field.BuiltInType.TOGGLEDROPDOWN },
                { value: CertificateField, name: Field.BuiltInType.CERTIFICATE }
            ],
        },
    })
], Entity.prototype, "attributes", void 0);
(function (Entity) {
    ;
})(Entity || (Entity = {}));
//# sourceMappingURL=data:application/json;base64,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