import { EventEmitter } from "@angular/core";
import { of } from "rxjs";
export class Wizard {
    constructor(title, steps, currentStepIndex, data) {
        this.title = title;
        this.steps = steps;
        this.currentStepIndex = currentStepIndex;
        this.data = data;
        this.close = () => { };
        this.next = () => of();
        this.back = () => { };
        this.wizardChanged$ = new EventEmitter();
    }
    // get loadingPercentage(): number {
    //   if (this.itemsLoading === 0) {
    //     return 100;
    //   } else {
    //     const tick = this.itemsLoading > 0 ? (100 / this.itemsLoading) : 0;
    //     return tick * this.itemsLoaded;
    //   }
    // }
    get currentStep() {
        const enabledSteps = this.steps.filter((step) => !step.disabled);
        return enabledSteps[this.currentStepIndex];
    }
}
export class WizardStep {
    constructor(title, buttons, 
    // public icon: string,
    component, visible, disabled) {
        this.title = title;
        this.buttons = buttons;
        this.component = component;
        this.visible = visible;
        this.disabled = disabled;
        this.isComplete = false;
        this.visible = true;
    }
}
export class WizardButton {
    constructor(text, action) {
        this.text = text;
        this.action = action;
        this.pullRight = false;
        this.name = '';
        this.disabled = false;
        this.hidden = false;
        this.type = 'secondary';
        this.iconPosition = 'left';
    }
}
//# sourceMappingURL=data:application/json;base64,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