import { HttpClient, HttpContext } from '@angular/common/http';
import { Injectable, inject } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import { map } from 'rxjs';
import { API, IGNORE_ERRORS } from '../constants';
import * as i0 from "@angular/core";
export class ApiService {
    constructor() {
        this.http = inject(HttpClient);
    }
    getList(entity, type, params = {}) {
        return this.http.get(`${entity.baseUrl}${entity.type}/`, {
            params: params
        }).pipe(map((response) => {
            return type ? plainToInstance(type, response['hydra:member']) : response['hydra:member'];
        }));
    }
    getRecord(entity, uuid, type, ignoreErrors = false) {
        return this.http.get(`${entity.baseUrl}${entity.type}/${uuid}/`, {
            context: new HttpContext().set(IGNORE_ERRORS, ignoreErrors)
        }).pipe(map((response) => {
            return type ? plainToInstance(type, response) : response;
        }));
    }
    query(entity, queryBody, params = {}, ignoreErrors = false) {
        return this.http.post(`${entity.baseUrl}${API.QUERY_PART}${entity.type}/`, queryBody, {
            params: params,
            context: new HttpContext().set(IGNORE_ERRORS, ignoreErrors)
        }).pipe(map((response) => {
            return response;
        }));
    }
    updateRecord(entity, uuid, payload) {
        return this.http.patch(`${entity.baseUrl}${entity.type}/${uuid}/`, payload);
    }
    createRecord(entity, payload) {
        let url = `${entity.baseUrl}${entity.type}/`;
        return this.http.post(url, payload);
    }
    upsertRecord(entity, payload) {
        if (payload.uuid) {
            return this.updateRecord(entity, payload.uuid, payload);
        }
        else {
            return this.createRecord(entity, payload);
        }
    }
    deleteRecord(entity, uuid, ignoreErrors = false) {
        return this.http.delete(`${entity.baseUrl}${entity.type}/${uuid}/`, {
            context: new HttpContext().set(IGNORE_ERRORS, ignoreErrors)
        });
    }
    static { this.ɵfac = function ApiService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ApiService)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ApiService, factory: ApiService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ApiService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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