import { HttpParams } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import { ALL_RECORDS_SIZE, API, FIXED_MODULE } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "./permission.service";
import * as i2 from "@angular/common/http";
export class CollectionService {
    constructor(permission, http) {
        this.permission = permission;
        this.http = http;
    }
    getCollectionNames() {
        const workflowsReadPermission = this.permission.availablePermission(FIXED_MODULE.PLAYBOOK, 'read');
        let collectionSub = new Subject();
        if (!workflowsReadPermission) {
            collectionSub.next({});
            collectionSub.complete();
        }
        const params = new HttpParams().set('__selectFields', 'name');
        this.http.post(`${API.QUERY}workflow_collections`, {
            limit: ALL_RECORDS_SIZE
        }, { params }).subscribe((response) => {
            const collectionNamesList = response['hydra:member'];
            let collectionNames = {};
            collectionNamesList.forEach((collection) => {
                if (collection.hasOwnProperty('@id') && collection.hasOwnProperty('name')) {
                    Object.defineProperty(collectionNames, collection['@id'], collection.name);
                }
            });
            collectionSub.next(collectionNames);
            collectionSub.complete();
        });
        //}
        return collectionSub;
    }
    static { this.ɵfac = function CollectionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || CollectionService)(i0.ɵɵinject(i1.PermissionService), i0.ɵɵinject(i2.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: CollectionService, factory: CollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(CollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.PermissionService }, { type: i2.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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