import { Injectable } from '@angular/core';
import { map } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "ngx-filesaver";
export class FileService {
    constructor(http, fileSaverService) {
        this.http = http;
        this.fileSaverService = fileSaverService;
    }
    download(file) {
        return this.downloadBinaryFromIri(file.iri, file.mimeType, file.filename);
    }
    downloadBinaryFromIri(filePath, mimeType = '', filename = 'file') {
        return this.http.get(filePath, {
            responseType: 'arraybuffer',
            headers: {
            // 'Accept': 'application/octet-stream'
            }
        }).pipe(map((response) => {
            let blob = new Blob([response], {
                type: mimeType
            });
            this.fileSaverService.save(blob, filename);
        }));
    }
    upload(file, iri) {
        const formData = new FormData();
        formData.append('file', file);
        return this.http.post(iri, formData);
    }
    downloadJsonFile(data, fileName) {
        let json = JSON.stringify(data);
        let blob = new Blob([json], {
            type: 'application/json;charset=utf-8;'
        });
        this.fileSaverService.save(blob, fileName + '.json');
    }
    static { this.ɵfac = function FileService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FileService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.FileSaverService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FileService, factory: FileService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FileService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.FileSaverService }], null); })();
//# sourceMappingURL=data:application/json;base64,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