import { Injectable } from '@angular/core';
import { cloneDeep, forEach, isArray, isString, isUndefined } from 'lodash-es';
import { forkJoin, of } from 'rxjs';
import { map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API } from '../constants';
import * as i0 from "@angular/core";
import * as i1 from "./subscription-queue.service";
import * as i2 from "@angular/common/http";
import * as i3 from "../../utility/pipes/get-end-path-name.pipe";
import * as i4 from "../../form-fields/field-renderers/built-ins/picklist/picklist.service";
import * as i5 from "./model-metadata.service";
import * as i6 from "../../utility/pipes/interpolate.pipe";
import * as i7 from "./system-settings.service";
export class FilterCollectionService {
    constructor(subscriptionService, http, getEndPathNamePipe, picklistService, modelMetadatasService, interpolate, settingsService) {
        this.subscriptionService = subscriptionService;
        this.http = http;
        this.getEndPathNamePipe = getEndPathNamePipe;
        this.picklistService = picklistService;
        this.modelMetadatasService = modelMetadatasService;
        this.interpolate = interpolate;
        this.settingsService = settingsService;
    }
    load(type) {
        let KEY = `queries_${type}`;
        let _subscription = this.subscriptionService.get(KEY);
        if (isUndefined(_subscription)) {
            _subscription = this.http.get(`${API.API_3_BASE}queries?$limit=${ALL_RECORDS_SIZE}&$relationships=true&models__type=${type}`);
            this.subscriptionService.set(KEY, _subscription);
        }
        return _subscription.pipe(map((response) => {
            return response['hydra:member'];
        }));
    }
    saveUserQuery(query) {
        return this.save(query, 'user_queries');
    }
    saveSystemQuery(query) {
        return this.save(query, 'system_queries');
    }
    save(query, queryType) {
        if (isUndefined(queryType)) {
            queryType = query['@type'] === 'UserQuery' ? 'user_queries' : 'system_queries';
        }
        let queryToSave = cloneDeep(query);
        queryToSave.models = isArray(queryToSave.models) ? queryToSave.models[0] : null;
        let _subscription;
        if (query['@id']) {
            _subscription = this.http.put(`${API.API_3_BASE}${queryType}/${this.getEndPathNamePipe.transform(query['@id'])}?$relationships=true`, queryToSave);
        }
        else {
            _subscription = this.http.post(`${API.API_3_BASE}${queryType}?$relationships=true`, queryToSave);
        }
        return _subscription.pipe(map((response) => {
            return response.data;
        }));
    }
    deleteQuery(query) {
        let module = query['@type'] === 'UserQuery' ? 'user_queries' : 'system_queries';
        return this.http.delete(`${API.API_3_BASE}${module}/${this.getEndPathNamePipe.transform(query['@id'])}`);
    }
    loadQueryFilterValues(query) {
        let filters = query ? query.query.filters : [];
        let _subscriptions = [];
        forEach(filters, (filter) => {
            if (filter.value && filter.type) {
                if (filter.type === 'object' && isString(filter.value)) {
                    let _subscription = this._loadResource(filter.value).subscribe((data) => {
                        filter.value = data;
                    });
                    _subscriptions.push(_subscription);
                }
                else if (filter.type === 'array') {
                    forEach(filter.value, (item, index) => {
                        if (isString(item)) {
                            let _subscription = this._loadResource(item).subscribe((data) => {
                                filter.value[index] = data;
                            });
                            _subscriptions.push(_subscription);
                        }
                    });
                }
            }
        });
        if (_subscriptions.length) {
            return forkJoin(_subscriptions);
        }
        else {
            return of(filters);
        }
    }
    _loadResource(iri) {
        let _subscription = this.subscriptionService.get(iri);
        if (!_subscription) {
            if (iri.indexOf('picklist') >= 0) {
                _subscription = this.picklistService.getPicklistByIri(iri);
            }
            else {
                //_subscription = this.http.get(CommonUtils.getIriApiPath(iri)).get({})
                _subscription = this.http.get(iri);
            }
            this.subscriptionService.set(iri, _subscription);
        }
        return _subscription.pipe(map((data) => {
            let type = data['@type'];
            if (type !== 'Picklist') {
                var classMetaData = this.modelMetadatasService.getMetadataByModuleType(type);
                data.display = classMetaData ? this.interpolate.transform(classMetaData.displayName, data) : '';
            }
            return data;
        }));
    }
    static { this.ɵfac = function FilterCollectionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterCollectionService)(i0.ɵɵinject(i1.SubscriptionQueueService), i0.ɵɵinject(i2.HttpClient), i0.ɵɵinject(i3.GetEndPathNamePipe), i0.ɵɵinject(i4.PicklistService), i0.ɵɵinject(i5.ModelMetadataService), i0.ɵɵinject(i6.InterpolatePipe), i0.ɵɵinject(i7.SystemSettingsService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FilterCollectionService, factory: FilterCollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterCollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.SubscriptionQueueService }, { type: i2.HttpClient }, { type: i3.GetEndPathNamePipe }, { type: i4.PicklistService }, { type: i5.ModelMetadataService }, { type: i6.InterpolatePipe }, { type: i7.SystemSettingsService }], null); })();
//# sourceMappingURL=data:application/json;base64,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