import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "./theme.service";
export class HtmlEditorService {
    constructor(platformLocation, themeService) {
        this.platformLocation = platformLocation;
        this.themeService = themeService;
    }
    getDefaultConfig(toolbarSelector, theme) {
        return {
            debounce: true,
            inline: true,
            toolbar_mode: 'wrap',
            fixed_toolbar_container: toolbarSelector,
            browser_spellcheck: true,
            plugins: 'advlist lists code image link  media table fullscreen',
            height: 350,
            max_height: 600,
            menubar: false,
            toolbar: 'bold italic underline strikethrough superscript | blocks | removeformat | fontsize | forecolor backcolor | table bullist numlist | link image media | alignleft aligncenter alignright alignjustify | code fullscreen | dynamicValueButton',
            paste_data_images: true,
            extended_valid_elements: 'svg[*],defs[*],pattern[*],desc[*],metadata[*],g[*],mask[*],path[*],line[*],marker[*],rect[*],circle[*],ellipse[*],polygon[*],polyline[*],linearGradient[*],radialGradient[*],stop[*],image[*],view[*],text[*],textPath[*],title[*],tspan[*],glyph[*],symbol[*],switch[*],use[*]',
            autocompleteEnterKeyEvent: false
        };
    }
    getBasicConfig(toolbarSelector, theme) {
        return {
            debounce: true,
            inline: true,
            toolbar_mode: 'wrap',
            fixed_toolbar_container: toolbarSelector,
            browser_spellcheck: true,
            allow_script_urls: true,
            plugins: 'advlist lists code fullscreen table',
            height: 350,
            max_height: 600,
            menubar: false,
            toolbar: 'bold italic underline strikethrough table code fullscreen',
            toolbar_items_size: 'small',
            paste_data_images: true,
            autocompleteEnterKeyEvent: false
        };
    }
    static { this.ɵfac = function HtmlEditorService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || HtmlEditorService)(i0.ɵɵinject(i1.PlatformLocation), i0.ɵɵinject(i2.ThemeService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: HtmlEditorService, factory: HtmlEditorService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(HtmlEditorService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.PlatformLocation }, { type: i2.ThemeService }], null); })();
//# sourceMappingURL=data:application/json;base64,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