import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { map } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class PagedCollectionService {
    constructor(http) {
        this.http = http;
        this.countCache = {};
    }
    getCount(uuid) {
        this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        return this.countCache[uuid];
    }
    setCount(uuid, count) {
        this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        this.countCache[uuid].next(count);
    }
    load(pagedCollection, query, uuid) {
        if (uuid) {
            this.countCache[uuid] = this.countCache[uuid] || new BehaviorSubject(0);
        }
        let params = pagedCollection.getURLData(query);
        // if (params.requestType === 'post') {
        //   return this.http.post(params.url, params.payload, { params: params.queryParams }).pipe(
        //     map((result: any) => {
        //       pagedCollection.setPage(result, query);
        //       if (uuid) {
        //         this.setCount(uuid, pagedCollection.totalItems || 0);
        //       }
        //       return pagedCollection;
        //     })
        //   );
        // } else {
        let queryParams = query.getURLQuery(pagedCollection.entity);
        return this.http.get(params.url, { params: queryParams }).pipe(map((result) => {
            pagedCollection.setPage(result, query);
            if (uuid) {
                this.setCount(uuid, pagedCollection.totalItems || 0);
            }
            return pagedCollection;
        }));
        // }
    }
    static { this.ɵfac = function PagedCollectionService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PagedCollectionService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PagedCollectionService, factory: PagedCollectionService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PagedCollectionService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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