import { Injectable } from '@angular/core';
import { API, FIXED_MODULE, IGNORE_ERRORS, OPERATOR_MAPPINGS } from '../constants';
import { HttpContext } from '@angular/common/http';
import { Schedule } from '../models/schedule';
import { plainToInstance } from 'class-transformer';
import { map } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class ScheduleService {
    constructor(http) {
        this.http = http;
        // TODO: use schedule model instead of Observable<any>
        this.scheduleListApi = `${API.SCHEDULE}?format=json&task=workflow.tasks.periodic_task`;
    }
    // Schedule Detail
    create(schedule) {
        schedule.interval = null; //TODO : Do not hardcode
        schedule.task = 'workflow.tasks.periodic_task'; // TODO: is this a static value?
        return this.http.post(`${API.SCHEDULE}`, schedule);
    }
    update(schedule) {
        schedule.interval = null; //TODO : Do not hardcode
        schedule.task = schedule.task || 'workflow.tasks.periodic_task';
        return this.http.put(`${API.SCHEDULE}${schedule.id}/?format=json`, schedule);
    }
    getById(id) {
        let api = `${API.SCHEDULE}${id}/?format=json`;
        return this.http.get(api, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        }).pipe(map((result) => {
            return plainToInstance(Schedule, result);
        }));
    }
    getByTaskName(taskName) {
        let api = `${API.SCHEDULE}?format=json&task=${taskName}`;
        return this.http.get(api, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        }).pipe(map((result) => {
            return plainToInstance(Schedule, result['hydra:member'][0]);
        }));
    }
    getByName(name) {
        let api = `${API.WORKFLOW}${API.QUERY_PART}${FIXED_MODULE.SCHEDULES}/?format=json`;
        return this.http.post(api, {
            filters: [{
                    field: 'name',
                    operator: OPERATOR_MAPPINGS.startsWith,
                    value: name
                }]
        }, {
            context: new HttpContext().set(IGNORE_ERRORS, true)
        }).pipe(map((result) => {
            if (!result['hydra:member'].length) {
                throw new Error('Not found');
            }
            return plainToInstance(Schedule, result['hydra:member'][0]);
        }));
    }
    delete(id) {
        return this.http.delete(`${API.SCHEDULE}${id}/?format=json`);
    }
    trigger(id) {
        return this.http.post(`${API.SCHEDULE}trigger-now/`, { 'id': id });
    }
    static { this.ɵfac = function ScheduleService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScheduleService)(i0.ɵɵinject(i1.HttpClient)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ScheduleService, factory: ScheduleService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScheduleService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }], null); })();
//# sourceMappingURL=data:application/json;base64,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