import { Component, EventEmitter, Input, Output, ViewChildren } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { plainToInstance } from 'class-transformer';
import _ from 'lodash-es';
import { forEach, isArray, isUndefined } from 'lodash-es';
import { ModuleAttributeMap } from '../../core/models/attribute-map';
import { ConnectorFieldRendererParameter } from '../../core/models/connector-field-renderer-parameter';
import { Field } from '../../core/models/field';
import { FormFieldComponent } from '../field-renderers/built-ins/form-field/form-field.component';
import { debounceTime } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "../field-renderers/built-ins/form-field/form-field.component";
const _c0 = a0 => ({ "margin-bottom-lg": a0 });
function FieldRendererComponent_div_0_div_1_div_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵelement(1, "xf-field-renderer", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = i0.ɵɵnextContext(2).$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("parameters", actionField_r1.parameters)("fieldValues", ctx_r1.fieldValues)("enableRecordFields", ctx_r1.enableRecordFields)("ignoreRequired", ctx_r1.ignoreRequired)("enableJinja", ctx_r1.enableJinja)("connectorFormGroup", ctx_r1.connectorFormGroup);
} }
function FieldRendererComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3)(1, "div")(2, "form", 4);
    i0.ɵɵelement(3, "xf-form-field", 5, 0);
    i0.ɵɵelementEnd()();
    i0.ɵɵtemplate(5, FieldRendererComponent_div_0_div_1_div_5_Template, 2, 6, "div", 6);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = i0.ɵɵnextContext().$implicit;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(6, _c0, actionField_r1.field.formType === ctx_r1.checkbox));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("formGroup", ctx_r1.connectorFormGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", actionField_r1.field)("formControlName", actionField_r1.field.name)("fieldClass", "form-control-sm margin-bottom-8px w-100");
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", actionField_r1.parameters.length > 0);
} }
function FieldRendererComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div");
    i0.ɵɵtemplate(1, FieldRendererComponent_div_0_div_1_Template, 6, 8, "div", 2);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const actionField_r1 = ctx.$implicit;
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", actionField_r1.visible);
} }
export class FieldRendererComponent {
    constructor(changeDetectorRef) {
        this.changeDetectorRef = changeDetectorRef;
        this.fieldValues = {};
        this.parameters = [];
        //@Input() fieldForm: FormGroup = new FormGroup({});
        this.formMode = 'add';
        this.ignoreRequired = false;
        this.enableJinja = false;
        //@Input() focusMethod: any;
        //@Input() fieldModifyFunc: any;
        this.onFieldChange = new EventEmitter();
        this.actionFields = [];
        this.actionFieldsToRender = [];
        this.checkbox = Field.BuiltInType.SELECT;
        this.deletedParams = [];
        this.emitted = false;
        this.error = false;
        this.formControlNames = [];
    }
    ngOnChanges(changes) {
        if ((changes.parameters && !changes.parameters.firstChange) || (changes.fieldValues && !changes.fieldValues.firstChange)) {
            this.transformFields();
        }
    }
    ngOnInit() {
        this.connectorFormGroup = this.connectorFormGroup || new FormGroup({});
        this.transformFields();
    }
    ngOnDestroy() {
        this.removeExistingFormControls();
    }
    transformFields() {
        this.actionFields = plainToInstance(ConnectorFieldRendererParameter, this.parameters || []);
        this.actionFieldsToRender = [];
        this.removeExistingFormControls();
        this.changeDetectorRef.detectChanges();
        this.actionFields.forEach((actionField, index) => {
            let field = this.createField(actionField);
            let parameters = [];
            if (isUndefined(this.fieldValues[actionField.name]) && !isUndefined(actionField.value)) {
                this.fieldValues[actionField.name] = actionField.value;
            }
            this.fieldValues[actionField.name] = isUndefined(this.fieldValues[actionField.name]) ? (actionField.formType === Field.BuiltInType.CHECKBOX ? false : '') : this.fieldValues[actionField.name];
            if (Object.keys(actionField.onchange).length > 0) {
                let value = isUndefined(this.fieldValues[actionField.name]) ? actionField.value : this.fieldValues[actionField.name];
                if (actionField.formType === Field.BuiltInType.MULTISELECT && isArray(value)) {
                    value.forEach((selected) => {
                        if (actionField.onchange[selected]) {
                            parameters = parameters.concat(actionField.onchange[selected] || []);
                        }
                    });
                }
                else {
                    parameters = !isUndefined(value) && actionField.onchange[value] ? actionField.onchange[value] : [];
                }
            }
            let value = isUndefined(this.fieldValues[actionField.name]) ? (actionField.value || '') : this.fieldValues[actionField.name];
            let validators = actionField.required ? [Validators.required] : [];
            let formControl = new FormControl(value, validators);
            this.connectorFormGroup.addControl(actionField.name, formControl);
            this.formControlNames.push(actionField.name);
            this.parameters[index].value = value;
            this.connectorFormGroup.controls[actionField.name].valueChanges.pipe(debounceTime(300)).subscribe((value) => {
                this.parameters[index].value = value;
                this.setOnValuechanges(value, actionField, this.actionFieldsToRender[index]);
            });
            this.fetchOperationData(actionField);
            let obj = _.merge(actionField, { field: field, parameters: parameters });
            this.actionFieldsToRender.push(obj);
        });
    }
    //TODO: Need to implement for apiOperation
    fetchOperationData(field) {
        // if(field.apiOperation && (CommonUtils.isUndefined(field.processing) || field.processing === false)){
        //   field.processing = true;
        //   var argument = angular.copy(scope.connectorData);
        //   argument.targetField = field.name;
        //   argument.operation = field.apiOperation;
        //   argument.params = scope.params;
        //   scope.error = undefined;
        //   connectorService.getFieldData(argument).then(function(data) {
        //      if(data.id){
        //          websocketService.subscribe(data.id, function (result) {
        //            processOnApiChangeData(result, field);
        //            if (actionTimeout) {
        //              $timeout.cancel(actionTimeout);
        //            }
        //            actionSubscription = undefined;
        //            field.processing = false;
        //          }).then(function (sub) {
        //            actionSubscription = sub;
        //            setActionTimeout(field);
        //          }, function (error) {
        //              scope.error = error.data.message;
        //              field.processing = false;
        //          });
        //      }else{
        //        field.processing = false;
        //        processOnApiChangeData(data, field);
        //      }
        //     }, function (error) {
        //       field.processing = false;
        //       scope.error = error.data.message;
        //     });
        // }else{
        //   if(!CommonUtils.isUndefined(field.value) && field.value!==''){
        //    scope.onChange(field.value,field, true);
        //   }
        // }
        // if(scope.fieldModifyFunc){
        //   scope.fieldModifyFunc(field);
        // }
    }
    //TODO: Need to implment for apiOperation
    processOnApiChangeData(processeData, field) {
        // var dataTemplate = {};
        // if (field.apiOnchange) {
        //   dataTemplate = processeData.data;
        //   for (var key in dataTemplate) {
        //     if (key !== 'value') {
        //       field[key] = dataTemplate[key];
        //     }
        //   }
        // }
        // else {
        //   field.options = processeData.data;
        // }
        // if (!CommonUtils.isUndefined(field.value) && field.value !== '') {
        //   scope.onChange(field.value, field);
        // }
    }
    createField(action) {
        let field = new ModuleAttributeMap[action.formType].field(action.name);
        field.title = action.title;
        field.descriptions.singular = action.description;
        field.tooltip = action.tooltip;
        field.visible = action.visible;
        field.editable = action.editable;
        field.enableJinja = this.enableJinja;
        field.placeholder = action.placeholder;
        field.validation.required = this.ignoreRequired ? false : action.required;
        if (action.formType === Field.BuiltInType.SELECT || action.formType === Field.BuiltInType.MULTISELECT) {
            field.options = action.options;
        }
        if (action.formType === Field.BuiltInType.JSON) {
            field.modes = ['code', 'view'];
        }
        return field;
    }
    setOnValuechanges(value, actionField, renderField) {
        let parameters = [];
        if (Object.keys(actionField.onchange).length > 0) {
            this.deletedParams = [];
            this.deleteFieldParameters(renderField);
            if (actionField.formType === Field.BuiltInType.MULTISELECT && isArray(value)) {
                value.forEach((selected) => {
                    if (actionField.onchange[selected]) {
                        parameters = parameters.concat(actionField.onchange[selected] || []);
                    }
                });
            }
            else {
                parameters = actionField.onchange[value] || [];
            }
            renderField.parameters = parameters;
            this.changeDetectorRef.detectChanges();
        }
        this.fieldValues[actionField.name] = value;
        this.onFieldChange.emit(this.fieldValues);
    }
    deleteFieldParameters(field) {
        forEach(field.parameters, (param) => {
            if (param.onchange) {
                if (param.parameters) {
                    this.deleteFieldParameters(param);
                }
                else if (param.value) {
                    let tempField = {
                        parameters: param.onchange[param.value] || []
                    };
                    this.deleteFieldParameters(tempField);
                }
            }
            this.deletedParams.push(param.name);
            delete this.fieldValues[param.name];
        });
        return this.deletedParams;
    }
    removeExistingFormControls() {
        this.formControlNames.forEach((key) => {
            this.connectorFormGroup.removeControl(key, { emitEvent: false });
        });
        this.formControlNames = [];
    }
    focusOnFirstInvalidInput() {
        this.connectorFormGroup.markAllAsTouched();
        for (let formField of this.formFields) {
            if (!formField.valid) {
                formField.focus();
                return true;
            }
        }
        return false;
    }
    static { this.ɵfac = function FieldRendererComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FieldRendererComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FieldRendererComponent, selectors: [["xf-field-renderer"]], viewQuery: function FieldRendererComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(FormFieldComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formFields = _t);
        } }, inputs: { fieldValues: "fieldValues", parameters: "parameters", formMode: "formMode", ignoreRequired: "ignoreRequired", enableJinja: "enableJinja", enableRecordFields: "enableRecordFields", connectorFormGroup: "connectorFormGroup" }, outputs: { onFieldChange: "onFieldChange" }, features: [i0.ɵɵNgOnChangesFeature], decls: 1, vars: 1, consts: [["formField", ""], [4, "ngFor", "ngForOf"], ["class", "form-group margin-top-10px", 3, "ngClass", 4, "ngIf"], [1, "form-group", "margin-top-10px", 3, "ngClass"], [3, "formGroup"], [3, "field", "formControlName", "fieldClass"], [4, "ngIf"], [3, "parameters", "fieldValues", "enableRecordFields", "ignoreRequired", "enableJinja", "connectorFormGroup"]], template: function FieldRendererComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, FieldRendererComponent_div_0_Template, 2, 1, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngForOf", ctx.actionFieldsToRender);
        } }, dependencies: [i1.NgClass, i1.NgForOf, i1.NgIf, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.FormFieldComponent, FieldRendererComponent] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FieldRendererComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-renderer', template: "<div *ngFor=\"let actionField of actionFieldsToRender;\">\n  <div class=\"form-group margin-top-10px\" *ngIf=\"actionField.visible\"\n    [ngClass]=\"{'margin-bottom-lg': actionField.field.formType === checkbox}\">\n    <div>\n      <form [formGroup]=\"connectorFormGroup\">\n        <xf-form-field [field]=\"actionField.field\" #formField [formControlName]=\"actionField.field.name\"\n          [fieldClass]=\"'form-control-sm margin-bottom-8px w-100'\"></xf-form-field>\n      </form>\n      <!-- <span class='fa fa-refresh fa-spin margin-left-8px active-color' *ngIf=\"field.processing\"></span> -->\n    </div>\n    <div *ngIf=\"actionField.parameters.length > 0\">\n      <xf-field-renderer [parameters]=\"actionField.parameters\" [fieldValues]=\"fieldValues\"\n        [enableRecordFields]=\"enableRecordFields\" [ignoreRequired]=\"ignoreRequired\"\n        [enableJinja]=\"enableJinja\" [connectorFormGroup]=\"connectorFormGroup\"></xf-field-renderer>\n    </div>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }], { fieldValues: [{
            type: Input
        }], parameters: [{
            type: Input
        }], formMode: [{
            type: Input
        }], ignoreRequired: [{
            type: Input
        }], enableJinja: [{
            type: Input
        }], enableRecordFields: [{
            type: Input
        }], onFieldChange: [{
            type: Output
        }], formFields: [{
            type: ViewChildren,
            args: [FormFieldComponent]
        }], connectorFormGroup: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FieldRendererComponent, { className: "FieldRendererComponent", filePath: "lib/form-fields/field-renderer/field-renderer.component.ts", lineNumber: 17 }); })();
//# sourceMappingURL=data:application/json;base64,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