import { Component, EventEmitter, inject, Input, Output, ViewChild } from '@angular/core';
import { FieldOptions } from '../../models/field-options';
import { FieldService } from '../../../core/services/field.service';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
const _c0 = ["inputField"];
export class AbstractFieldComponent {
    constructor(changeDetectorRef, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.formBuilder = formBuilder;
        this.fieldOptions = new FieldOptions();
        this.autoFocus = false;
        this.jinjaToggled = new EventEmitter();
        this.onSubmit = new EventEmitter();
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.isDisabled = false;
        this.fieldService = inject(FieldService);
    }
    ngAfterViewInit() {
        if (this.autoFocus) {
            this.inputField?.nativeElement.focus();
            this.inputField?.nativeElement.setAttribute('ngbAutofocus', '');
        }
        if (this.isDisabled) {
            this.fieldGroup?.get('input')?.disable();
        }
    }
    ngOnInit() {
        this.fieldGroup = this.formBuilder.group({
            input: [this.value, this.fieldService.getValidators(this.field)]
        });
    }
    setDisabledState(isDisabled) {
        this.isDisabled = isDisabled;
        if (isDisabled) {
            this.fieldGroup?.get('input')?.disable();
        }
        else {
            this.fieldGroup?.get('input')?.enable();
        }
    }
    get value() {
        return this._value;
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.onChange(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    writeValue(value) {
        this.value = value;
        if (this.fieldGroup && this.fieldGroup.controls.input) {
            this.fieldGroup.controls.input.setValue(value);
        }
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    onBlur() {
        this.onTouched();
    }
    onFocus() {
        // setTimeout(() => {
        //   if (this.inputField && 'select' in this.inputField.nativeElement) {
        //     this.inputField.nativeElement.select();
        //   }
        // });
    }
    validate(control) {
        this.control = control;
        return this.fieldGroup?.controls.input?.valid ? null : this.fieldGroup?.controls.input?.errors ?? null;
    }
    get valid() {
        return this.fieldGroup?.valid === false ? false : true;
    }
    focus() {
        this.inputField?.nativeElement.focus();
    }
    ngDoCheck() {
        if (this.fieldGroup?.touched) {
            this.control?.markAsTouched();
            return;
        }
        if (this.control?.touched && this.fieldGroup?.controls.input) {
            this.fieldGroup?.controls.input.markAsTouched();
        }
    }
    toggleJinja(jinjaEnabled) {
        this.jinjaToggled.emit(jinjaEnabled);
    }
    static { this.ɵfac = function AbstractFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || AbstractFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: AbstractFieldComponent, selectors: [["xf-abstract-field"]], viewQuery: function AbstractFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.inputField = _t.first);
        } }, inputs: { field: "field", fieldOptions: "fieldOptions", fieldClass: "fieldClass", autoFocus: "autoFocus" }, outputs: { jinjaToggled: "jinjaToggled", onSubmit: "onSubmit" }, decls: 0, vars: 0, template: function AbstractFieldComponent_Template(rf, ctx) { }, encapsulation: 2 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(AbstractFieldComponent, [{
        type: Component,
        args: [{
                selector: 'xf-abstract-field',
                template: ''
            }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.FormBuilder }], { field: [{
            type: Input
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], jinjaToggled: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], inputField: [{
            type: ViewChild,
            args: ['inputField']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(AbstractFieldComponent, { className: "AbstractFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/abstract-field.component.ts", lineNumber: 11 }); })();
//# sourceMappingURL=data:application/json;base64,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