import { Component, ViewChild, forwardRef } from '@angular/core';
import { FormControl, NG_VALIDATORS, NG_VALUE_ACCESSOR } from '@angular/forms';
import { NgbDropdown } from '@ng-bootstrap/ng-bootstrap';
import { AbstractFieldComponent } from '../../abstract-field.component';
import * as i0 from "@angular/core";
import * as i1 from "../../../../../core/services/system-settings.service";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "@ng-bootstrap/ng-bootstrap";
import * as i5 from "../../../../form-messages/form-messages.component";
const _c0 = ["toggleButton"];
const _c1 = a0 => ({ "is-invalid": a0 });
function DatetimeFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 21);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function DatetimeFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 22);
    i0.ɵɵelement(1, "i", 23);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r1.field.tooltip);
} }
function DatetimeFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 18);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, DatetimeFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 19)(3, DatetimeFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 20);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "input-" + ctx_r1.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r1.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.tooltip);
} }
function DatetimeFieldComponent_div_0_button_19_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 24);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_button_19_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r1.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function DatetimeFieldComponent_div_0_xf_form_messages_20_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 25);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r1.fieldGroup.controls.inputDate);
} }
function DatetimeFieldComponent_div_0_xf_form_messages_21_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 25);
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r1.fieldGroup.controls.inputTime);
} }
function DatetimeFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, DatetimeFieldComponent_div_0_label_1_Template, 4, 4, "label", 4);
    i0.ɵɵelementStart(2, "div", 5)(3, "div", 6)(4, "div", 7);
    i0.ɵɵlistener("openChange", function DatetimeFieldComponent_div_0_Template_div_openChange_4_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.setDefaultValue($event)); });
    i0.ɵɵelementStart(5, "button", 8, 0);
    i0.ɵɵtext(7);
    i0.ɵɵpipe(8, "date");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(9, "div", 9)(10, "ngb-datepicker", 10, 1);
    i0.ɵɵlistener("dateSelect", function DatetimeFieldComponent_div_0_Template_ngb_datepicker_dateSelect_10_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.dateSelected($event)); });
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(12, "div", 11);
    i0.ɵɵelement(13, "ngb-timepicker", 12);
    i0.ɵɵelementStart(14, "div", 13)(15, "button", 14);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_Template_button_click_15_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.ngbDropdown.close()); });
    i0.ɵɵtext(16, "Apply");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(17, "button", 15);
    i0.ɵɵlistener("click", function DatetimeFieldComponent_div_0_Template_button_click_17_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.clear()); });
    i0.ɵɵtext(18, "Clear");
    i0.ɵɵelementEnd()()()()();
    i0.ɵɵtemplate(19, DatetimeFieldComponent_div_0_button_19_Template, 2, 3, "button", 16);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(20, DatetimeFieldComponent_div_0_xf_form_messages_20_Template, 1, 1, "xf-form-messages", 17)(21, DatetimeFieldComponent_div_0_xf_form_messages_21_Template, 1, 1, "xf-form-messages", 17);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    let tmp_7_0;
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showLabel);
    i0.ɵɵadvance(4);
    i0.ɵɵclassMapInterpolate1("datepicker btn btn-input text-start w-100 ", ctx_r1.fieldClass, "");
    i0.ɵɵproperty("id", "input-" + ctx_r1.field.name)("ngClass", i0.ɵɵpureFunction1(14, _c1, ((tmp_7_0 = ctx_r1.fieldGroup.get("inputDate")) == null ? null : tmp_7_0.touched) && ((tmp_7_0 = ctx_r1.fieldGroup.get("inputDate")) == null ? null : tmp_7_0.invalid)));
    i0.ɵɵadvance(2);
    i0.ɵɵtextInterpolate1(" ", ctx_r1.value ? i0.ɵɵpipeBind2(8, 11, ctx_r1.value, ctx_r1.systemSettings.preferences.dateTimeFormat) : "Select Date", " ");
    i0.ɵɵadvance(12);
    i0.ɵɵproperty("ngIf", ctx_r1.field.allowJinjaToggle);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showError);
} }
export class DatetimeFieldComponent extends AbstractFieldComponent {
    constructor(systemSettingsService, changeDetectorRef, formBuilder) {
        super(changeDetectorRef, formBuilder);
        this.systemSettingsService = systemSettingsService;
        this.isFirstChange = true;
        this.systemSettings = this.systemSettingsService.get();
    }
    get value() {
        return this._value;
    }
    set value(value) {
        super.value = value;
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.removeControl('input');
        const date = this.getDateFromValue();
        const time = this.getTimeFromValue();
        this.fieldGroup?.addControl('inputDate', new FormControl(date, this.fieldService.getValidators(this.field)));
        this.fieldGroup?.addControl('inputTime', new FormControl(time));
        this.fieldGroup?.valueChanges
            .subscribe((value) => {
            this.isFirstChange = false;
            if (!value.inputDate || !value.inputTime) {
                this.value = null;
                this.changeDetectorRef.detectChanges();
                return;
            }
            let date = new Date(Date.UTC(value.inputDate.year, value.inputDate.month - 1, value.inputDate.day, value.inputTime ? value.inputTime.hour : 0, value.inputTime ? value.inputTime.minute : 0));
            let timezoneOffset = new Date().getTimezoneOffset();
            date.setMinutes(date.getMinutes() + timezoneOffset);
            //this.value = date.getTime() / 1000;
            this.value = date;
            this.changeDetectorRef.detectChanges();
        });
    }
    getTimeFromValue() {
        if (!this.value) {
            return null;
        }
        let currentDate = new Date(this.value);
        return {
            minute: currentDate.getMinutes(),
            hour: currentDate.getHours()
        };
    }
    getDateFromValue() {
        if (!this.value) {
            return null;
        }
        let currentDate = new Date(this.value);
        return {
            year: currentDate.getFullYear(),
            month: currentDate.getMonth() + 1,
            day: currentDate.getDate()
        };
    }
    writeValue(value) {
        this.value = value;
        if (this.fieldGroup && this.fieldGroup.controls.inputDate && this.fieldGroup.controls.inputTime) {
            const date = this.getDateFromValue();
            const time = this.getTimeFromValue();
            this.fieldGroup.controls.inputDate.setValue(date);
            this.fieldGroup.controls.inputTime.setValue(time);
        }
    }
    validate(control) {
        this.control = control;
        if (!this.fieldGroup?.controls.inputDate?.valid) {
            return this.fieldGroup?.controls.inputDate?.errors || null;
        }
        if (!this.fieldGroup.controls.inputTime?.valid) {
            return this.fieldGroup.controls.inputTime?.errors || null;
        }
        return null;
    }
    dateSelected(event) {
        if (this.isFirstChange && event.day === this.fieldGroup?.controls.inputDate.value.day) {
            this.fieldGroup?.controls.inputDate.setValue(event);
        }
        this.isFirstChange = false;
    }
    setDefaultValue(opened) {
        if (opened && !this.value) {
            this.writeValue(new Date());
        }
    }
    clear() {
        this.writeValue(null);
        this.ngbDropdown.close();
    }
    focus() {
        this.ngbDropdownToggle.nativeElement.focus();
        this.fieldGroup?.markAllAsTouched();
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function DatetimeFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || DatetimeFieldComponent)(i0.ɵɵdirectiveInject(i1.SystemSettingsService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: DatetimeFieldComponent, selectors: [["xf-datetime-field"]], viewQuery: function DatetimeFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(NgbDropdown, 5);
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.ngbDropdown = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.ngbDropdownToggle = _t.first);
        } }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => AbstractFieldComponent),
                    multi: true
                }]), i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["toggleButton", ""], ["dp", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "input-group", "mw-250px", "w-100"], [1, "d-flex"], ["ngbDropdown", "", 1, "flex-grow-1", "datepicker-container", 3, "openChange"], ["type", "button", "ngbDropdownToggle", "", 3, "id", "ngClass"], ["ngbDropdownMenu", ""], ["formControlName", "inputDate", 3, "dateSelect"], [1, "d-flex", "align-items-center", "justify-content-center"], ["formControlName", "inputTime"], [1, "ms-2"], ["type", "button", 1, "btn", "btn-sm", "btn-primary", 3, "click"], ["type", "button", 1, "btn", "btn-sm", "btn-default", "mt-1", 3, "click"], ["type", "button", "class", "ms-2 btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], [3, "control", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], ["type", "button", "title", "Add Custom Expression", 1, "ms-2", "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"], [3, "control"]], template: function DatetimeFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, DatetimeFieldComponent_div_0_Template, 22, 16, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i3.NgClass, i3.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i4.NgbTooltip, i4.NgbDatepicker, i4.NgbTimepicker, i4.NgbDropdown, i4.NgbDropdownToggle, i4.NgbDropdownMenu, i5.FormMessagesComponent, i3.DatePipe] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(DatetimeFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-datetime-field', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => AbstractFieldComponent),
                        multi: true
                    }], template: "<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"input-group mw-250px w-100\">\n    <div class=\"d-flex\">\n      <div ngbDropdown class=\"flex-grow-1 datepicker-container\" (openChange)=\"setDefaultValue($event)\">\n        <button type=\"button\" [id]=\"'input-' + field.name\"\n          class=\"datepicker btn btn-input text-start w-100 {{fieldClass}}\" #toggleButton\n          [ngClass]=\"{'is-invalid': fieldGroup.get('inputDate')?.touched && fieldGroup.get('inputDate')?.invalid}\"\n          ngbDropdownToggle>\n          {{ value ? ( value | date: systemSettings.preferences.dateTimeFormat) : 'Select Date' }}\n        </button>\n        <div ngbDropdownMenu>\n          <ngb-datepicker #dp formControlName=\"inputDate\" (dateSelect)=\"dateSelected($event)\"></ngb-datepicker>\n          <div class=\"d-flex align-items-center justify-content-center\">\n            <ngb-timepicker formControlName=\"inputTime\"></ngb-timepicker>\n            <div class=\"ms-2\">\n              <button type=\"button\" class=\"btn btn-sm btn-primary\" (click)=\"ngbDropdown.close()\">Apply</button>\n              <button type=\"button\" class=\"btn btn-sm btn-default mt-1\" (click)=\"clear()\">Clear</button>\n            </div>\n          </div>\n        </div>\n      </div>\n      <button type=\"button\" class=\"ms-2 btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n    <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.inputDate\"></xf-form-messages>\n    <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.inputTime\"></xf-form-messages>\n  </div>\n</div>\n" }]
    }], () => [{ type: i1.SystemSettingsService }, { type: i0.ChangeDetectorRef }, { type: i2.FormBuilder }], { ngbDropdown: [{
            type: ViewChild,
            args: [NgbDropdown]
        }], ngbDropdownToggle: [{
            type: ViewChild,
            args: ['toggleButton']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(DatetimeFieldComponent, { className: "DatetimeFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/datetime/datetime-field/datetime-field.component.ts", lineNumber: 22 }); })();
//# sourceMappingURL=data:application/json;base64,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