import { ChangeDetectionStrategy, Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { isEqual, isObject } from 'lodash-es';
import { distinctUntilChanged, map } from 'rxjs/operators';
import { FieldOptions } from '../../../models/field-options';
import * as i0 from "@angular/core";
import * as i1 from "../../../../core/services/utility.service";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "../form-field/form-field.component";
import * as i5 from "../form-view/form-view.component";
const _c0 = ["formField"];
const _c1 = a0 => ({ "editable": a0 });
function EditableFieldComponent_div_0_div_1_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 6);
    i0.ɵɵlistener("click", function EditableFieldComponent_div_0_div_1_Template_div_click_0_listener() { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.toggleEditMode()); });
    i0.ɵɵelement(1, "xf-form-view", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(5, _c1, !ctx_r1.readOnly));
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.field)("fieldClass", ctx_r1.fieldClass)("value", ctx_r1.value)("fieldOptions", ctx_r1.fieldOptions);
} }
function EditableFieldComponent_div_0_form_2_Template(rf, ctx) { if (rf & 1) {
    const _r3 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "form", 8);
    i0.ɵɵlistener("ngSubmit", function EditableFieldComponent_div_0_form_2_Template_form_ngSubmit_0_listener() { i0.ɵɵrestoreView(_r3); const ctx_r1 = i0.ɵɵnextContext(2); return i0.ɵɵresetView(ctx_r1.onSave()); });
    i0.ɵɵelement(1, "xf-form-field", 9, 0);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵclassMapInterpolate1("", ctx_r1.field.formType, "-form-type-container");
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(9, _c1, ctx_r1.field.alwaysEditMode))("formGroup", ctx_r1.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r1.field)("fieldOptions", ctx_r1.fieldOptions)("fieldClass", ctx_r1.fieldClass)("autoFocus", ctx_r1.autoFocus);
} }
function EditableFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 3);
    i0.ɵɵtemplate(1, EditableFieldComponent_div_0_div_1_Template, 2, 7, "div", 4)(2, EditableFieldComponent_div_0_form_2_Template, 3, 11, "form", 5);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", !ctx_r1.editMode && !ctx_r1.field.alwaysEditMode || ctx_r1.readOnly);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", (ctx_r1.editMode || ctx_r1.field.alwaysEditMode) && ctx_r1.formGroup && !ctx_r1.readOnly);
} }
function EditableFieldComponent_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "div", 10);
} }
export class EditableFieldComponent {
    constructor(utilityService, formBuilder, elementRef, changeDetectorRef) {
        this.utilityService = utilityService;
        this.formBuilder = formBuilder;
        this.elementRef = elementRef;
        this.changeDetectorRef = changeDetectorRef;
        this.editMode = false;
        this.readOnly = false;
        this.showLabel = false;
        this.showInline = false;
        this.disableSubmitOnEnter = false;
        this.autoFocus = false;
        this.editModeChange = new EventEmitter();
        this.valueChange = new EventEmitter();
        this.onSubmit = new EventEmitter();
    }
    ngOnChanges(changes) {
        if (changes.value && !changes.value.firstChange) {
            this.formGroup?.setValue({
                editableField: this.value
            });
        }
        this.changeDetectorRef.detectChanges();
    }
    ngDoCheck() {
        if (isObject(this.value) && this.value['@id'] !== this.oldValueIri) {
            this.oldValueIri = this.value['@id'];
            this.formGroup?.setValue({
                editableField: this.value
            });
            this.changeDetectorRef.detectChanges();
        }
    }
    ngOnInit() {
        this.formGroup = this.formBuilder.group({
            editableField: []
        });
        this.fieldOptions = new FieldOptions({
            showLabel: this.showLabel,
            size: this.size
        });
        if (this.value) {
            this.formGroup?.setValue({
                editableField: this.value
            });
        }
        this.changeDetectorRef.detectChanges();
        this.formGroup.valueChanges
            .pipe(distinctUntilChanged(), map(values => values.editableField)).subscribe((value) => {
            if (!this.field) {
                return;
            }
            if (isEqual(this.value, value)) {
                return;
            }
            this.value = value;
            this.valueChange.emit(this.value);
            if (this.field.alwaysEditMode) {
                this.onSave();
            }
        });
    }
    ngOnDestroy() {
        this.unsubscribe();
    }
    subscribe() {
        this.subscription = this.utilityService.documentClickedTarget
            .subscribe(event => this.handleClickEvent(event));
    }
    unsubscribe() {
        this.subscription?.unsubscribe();
        this.subscription = undefined;
    }
    toggleEditMode() {
        if (this.readOnly) {
            return;
        }
        this.editMode = true;
        this.editModeChange.emit(this.editMode);
        this.changeDetectorRef.detectChanges();
        this.formField.focus();
        this.unsubscribe();
        setTimeout(() => this.subscribe());
    }
    handleClickEvent(event) {
        if (!this.elementRef.nativeElement.contains(event.target) && this.editMode) {
            this.onSave();
        }
    }
    onSave() {
        if (this.formGroup?.invalid) {
            return;
        }
        this.value = this.formGroup?.value.editableField;
        this.valueChange.emit(this.value);
        this.editMode = false;
        this.editModeChange.emit(this.editMode);
        this.onSubmit.emit();
        this.unsubscribe();
        this.changeDetectorRef.detectChanges();
    }
    static { this.ɵfac = function EditableFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || EditableFieldComponent)(i0.ɵɵdirectiveInject(i1.UtilityService), i0.ɵɵdirectiveInject(i2.FormBuilder), i0.ɵɵdirectiveInject(i0.ElementRef), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: EditableFieldComponent, selectors: [["xf-editable-field"]], viewQuery: function EditableFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formField = _t.first);
        } }, inputs: { editMode: "editMode", readOnly: "readOnly", showLabel: "showLabel", size: "size", showInline: "showInline", disableSubmitOnEnter: "disableSubmitOnEnter", autoFocus: "autoFocus", field: "field", value: "value", fieldOptions: "fieldOptions", fieldClass: "fieldClass" }, outputs: { editModeChange: "editModeChange", valueChange: "valueChange", onSubmit: "onSubmit" }, features: [i0.ɵɵProvidersFeature([FormBuilder]), i0.ɵɵNgOnChangesFeature], decls: 2, vars: 2, consts: [["formField", ""], ["class", "editable-field-container", 4, "ngIf"], ["class", "bg-shimmer title-line", 4, "ngIf"], [1, "editable-field-container"], [3, "ngClass", "click", 4, "ngIf"], [3, "ngClass", "class", "formGroup", "ngSubmit", 4, "ngIf"], [3, "click", "ngClass"], [3, "field", "fieldClass", "value", "fieldOptions"], [3, "ngSubmit", "ngClass", "formGroup"], ["formControlName", "editableField", 3, "field", "fieldOptions", "fieldClass", "autoFocus"], [1, "bg-shimmer", "title-line"]], template: function EditableFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, EditableFieldComponent_div_0_Template, 3, 2, "div", 1)(1, EditableFieldComponent_div_1_Template, 1, 0, "div", 2);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.field && ctx.fieldOptions);
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", !ctx.editMode && (!ctx.field || ctx.value === undefined));
        } }, dependencies: [i3.NgClass, i3.NgIf, i2.ɵNgNoValidate, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i4.FormFieldComponent, i5.FormViewComponent], styles: [".editable-field-container[_ngcontent-%COMP%]   .editable[_ngcontent-%COMP%]:hover{background:var(--form-default-bg-color);cursor:pointer}.editable-field-container[_ngcontent-%COMP%]   .editable[_ngcontent-%COMP%]:hover.form-select{background:inherit}.editable-field-container[_ngcontent-%COMP%]   .editable.picklist-form-type-container[_ngcontent-%COMP%]:hover{background:none}.editable-field-container[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%]:focus, .editable-field-container[_ngcontent-%COMP%]   .form-control[_ngcontent-%COMP%]:active{background:var(--form-default-bg-color)}"], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(EditableFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-editable-field', providers: [FormBuilder], changeDetection: ChangeDetectionStrategy.OnPush, template: "<div *ngIf=\"field && fieldOptions\" class=\"editable-field-container\">\n  <div [ngClass]=\"{'editable': !readOnly}\" *ngIf=\"(!editMode && !field.alwaysEditMode) || readOnly\" (click)=\"toggleEditMode()\">\n    <xf-form-view [field]=\"field\" [fieldClass]=\"fieldClass\" [value]=\"value\" [fieldOptions]=\"fieldOptions\"></xf-form-view>\n  </div>\n  <form *ngIf=\"(editMode || field.alwaysEditMode) && formGroup && !readOnly\" [ngClass]=\"{'editable': field.alwaysEditMode}\" class=\"{{field.formType}}-form-type-container\" [formGroup]=\"formGroup\" (ngSubmit)=\"onSave()\">\n    <xf-form-field formControlName=\"editableField\" [field]=\"field\" [fieldOptions]=\"fieldOptions\" [fieldClass]=\"fieldClass\" #formField [autoFocus]=\"autoFocus\"></xf-form-field>\n  </form>\n</div>\n<div *ngIf=\"!editMode && (!field || value === undefined)\" class=\"bg-shimmer title-line\"></div>\n", styles: [".editable-field-container .editable:hover{background:var(--form-default-bg-color);cursor:pointer}.editable-field-container .editable:hover.form-select{background:inherit}.editable-field-container .editable.picklist-form-type-container:hover{background:none}.editable-field-container .form-control:focus,.editable-field-container .form-control:active{background:var(--form-default-bg-color)}\n"] }]
    }], () => [{ type: i1.UtilityService }, { type: i2.FormBuilder }, { type: i0.ElementRef }, { type: i0.ChangeDetectorRef }], { editMode: [{
            type: Input
        }], readOnly: [{
            type: Input
        }], showLabel: [{
            type: Input
        }], size: [{
            type: Input
        }], showInline: [{
            type: Input
        }], disableSubmitOnEnter: [{
            type: Input
        }], autoFocus: [{
            type: Input
        }], editModeChange: [{
            type: Output
        }], valueChange: [{
            type: Output
        }], onSubmit: [{
            type: Output
        }], field: [{
            type: Input
        }], value: [{
            type: Input
        }], formField: [{
            type: ViewChild,
            args: ['formField']
        }], fieldOptions: [{
            type: Input
        }], fieldClass: [{
            type: Input
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(EditableFieldComponent, { className: "EditableFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/editable-field/editable-field.component.ts", lineNumber: 19 }); })();
//# sourceMappingURL=data:application/json;base64,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