import { Component, ViewChild, inject } from '@angular/core';
import { Subject } from 'rxjs';
import { map } from 'rxjs/operators';
import { SearchableDropdownComponent } from '../../../../components/searchable-dropdown/searchable-dropdown.component';
import { SearchableItem } from '../../../../components/searchable-dropdown/searchable-item';
import { ApiService } from '../../../../core/services/api.service';
import { EntityService } from '../../../../core/services/entity.service';
import { Query } from '../../../../query-filters/models/query';
import { AbstractFieldComponent } from '../abstract-field.component';
import { DEFAULT_LOOKUP_RECORDS } from '../../../../core/constants';
import { plainToInstance } from 'class-transformer';
import * as i0 from "@angular/core";
import * as i1 from "@angular/forms";
import * as i2 from "../../../../utility/pipes/interpolate.pipe";
import * as i3 from "@angular/common";
import * as i4 from "../../../../components/searchable-dropdown/searchable-dropdown.component";
import * as i5 from "@ng-bootstrap/ng-bootstrap";
const _c0 = ["searchInput"];
function LookupFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 8);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function LookupFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 9);
    i0.ɵɵelement(1, "i", 10);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r1.field.tooltip);
} }
function LookupFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 5);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, LookupFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 6)(3, LookupFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 7);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", ctx_r1.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1("", ctx_r1.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.validation == null ? null : ctx_r1.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.field.tooltip);
} }
function LookupFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    const _r1 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵtemplate(1, LookupFieldComponent_div_0_label_1_Template, 4, 4, "label", 2);
    i0.ɵɵelementStart(2, "div", 3)(3, "xf-searchable-dropdown", 4);
    i0.ɵɵlistener("searchQueryChange", function LookupFieldComponent_div_0_Template_xf_searchable_dropdown_searchQueryChange_3_listener($event) { i0.ɵɵrestoreView(_r1); const ctx_r1 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r1.loadItems($event)); });
    i0.ɵɵelementEnd()()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r1.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r1.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("items", ctx_r1.items)("buttonStyle", ctx_r1.field.params == null ? null : ctx_r1.field.params.style)("placeholder", ctx_r1.field.placeholder)("clearText", ctx_r1.field.params == null ? null : ctx_r1.field.params.clearText);
} }
export class LookupFieldComponent extends AbstractFieldComponent {
    constructor(_changeDetectorRef, _formBuilder, interpolate) {
        super(_changeDetectorRef, _formBuilder);
        this.interpolate = interpolate;
        this.searchText = '';
        this.loading = false;
        this.searchQueryChange = new Subject();
        this.items = [];
        this.entityService = inject(EntityService);
        this.apiService = inject(ApiService);
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((item) => {
            this.value = item?.value || null;
        });
    }
    ngAfterViewInit() {
        if (this.field && this.field.model) {
            this.entityService.build(this.field.model).subscribe((entity) => {
                this.entity = entity;
                if (this._value) {
                    this.setDisplayValue(this._value);
                }
            });
        }
    }
    loadItems(search) {
        if (!this.field.dataSource) {
            console.warn('No model specified for lookup');
            return;
        }
        let queryObject = new Query({
            filters: [],
            logic: 'AND'
        });
        if (this.field.dataSource.query) {
            queryObject.filters.push(this.field.dataSource.query);
        }
        if (search) {
            let searchQuery = this.entityService.buildSearchQueryFromDisplayName(this.entity, search);
            queryObject.filters.push(searchQuery.asFilterGroup());
        }
        const query = plainToInstance(Query, queryObject);
        this.apiService.query(this.entity, query.getQueryObject(), {
            limit: DEFAULT_LOOKUP_RECORDS
        }).pipe(map((response) => {
            let data = response['hydra:member'];
            let searchableItems = data.map((item) => {
                const display = this.interpolate.transform(this.entity.displayName, item);
                return new SearchableItem(display, item, item.uuid);
            });
            return searchableItems;
        }))
            .subscribe((searchableItems) => {
            this.items = searchableItems;
            this.changeDetectorRef.detectChanges();
        });
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.setDisplayValue(value);
            this.onChange(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    writeValue(value) {
        this.value = value;
        this.setDisplayValue(value);
    }
    setDisplayValue(value) {
        if (value && this.entity) {
            const display = this.interpolate.transform(this.entity.displayName, value);
            this.fieldGroup?.get('input')?.setValue(new SearchableItem(display, value, value.uuid));
        }
    }
    selectItem(item) {
        this.value = item;
        this.inputField?.nativeElement.focus();
    }
    focus() {
        this.dropdown.focus();
    }
    static { this.ɵfac = function LookupFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LookupFieldComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.FormBuilder), i0.ɵɵdirectiveInject(i2.InterpolatePipe)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LookupFieldComponent, selectors: [["xf-field-lookup"]], viewQuery: function LookupFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.searchInput = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dropdown = _t.first);
        } }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label", 3, "for", 4, "ngIf"], [1, "picklist-field-container"], ["container", "body", "formControlName", "input", 3, "searchQueryChange", "items", "buttonStyle", "placeholder", "clearText"], [1, "form-label", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"]], template: function LookupFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LookupFieldComponent_div_0_Template, 4, 6, "div", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i3.NgIf, i1.NgControlStatus, i1.NgControlStatusGroup, i1.FormGroupDirective, i1.FormControlName, i4.SearchableDropdownComponent, i5.NgbTooltip] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LookupFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-field-lookup', template: "<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"field.name\" *ngIf=\"fieldOptions.showLabel\" class=\"form-label\">{{ field.title}}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"picklist-field-container\">\n    <xf-searchable-dropdown container=\"body\" formControlName=\"input\" [items]=\"items\"\n      (searchQueryChange)=\"loadItems($event)\" [buttonStyle]=\"field.params?.style\"\n      [placeholder]=\"field.placeholder\" [clearText]=\"field.params?.clearText\"></xf-searchable-dropdown>\n  </div>\n</div>\n" }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.FormBuilder }, { type: i2.InterpolatePipe }], { searchInput: [{
            type: ViewChild,
            args: ['searchInput']
        }], dropdown: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LookupFieldComponent, { className: "LookupFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/lookup/lookup-field.component.ts", lineNumber: 21 }); })();
//# sourceMappingURL=data:application/json;base64,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