import { Component, inject } from '@angular/core';
import { FormBuilder } from '@angular/forms';
import { TranslocoService } from '@jsverse/transloco';
import { FieldOptions } from '../../../../models/field-options';
import * as i0 from "@angular/core";
function LookupFloatingFilterComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵelement(1, "xf-form-field", 3, 0);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.formGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("field", ctx_r0.lookupField)("fieldOptions", ctx_r0.fieldOptions);
} }
export class LookupFloatingFilterComponent {
    constructor() {
        this.formBuilder = inject(FormBuilder);
        this.translocoService = inject(TranslocoService);
        this.formGroup = this.formBuilder.group({
            value: [null]
        });
        this.formGroup.valueChanges.subscribe((values) => {
            this.currentValue = values.value?.uuid || null;
            this.updateFilter();
        });
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
    }
    agInit(params) {
        this.params = params;
        let lookupField = params.column.getColDef().headerComponentParams?.field;
        lookupField.placeholder = this.translocoService.translate('Choose');
        lookupField.validation = {
            required: false
        };
        lookupField.params = {
            clearText: 'Any'
        };
        this.lookupField = lookupField;
    }
    onParentModelChanged(parentModel) {
        // When the filter is empty we will receive a null value here
        if (!parentModel) {
            this.currentValue = null;
        }
        else {
            this.currentValue = parentModel.filter;
        }
    }
    updateFilter() {
        if (!this.currentValue) {
            this.params.parentFilterInstance((instance) => {
                instance.onFloatingFilterChanged(null, null);
            });
        }
        this.params.parentFilterInstance((instance) => {
            instance.onFloatingFilterChanged('eq', this.currentValue);
        });
    }
    static { this.ɵfac = function LookupFloatingFilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || LookupFloatingFilterComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: LookupFloatingFilterComponent, selectors: [["xf-lookup-floating-filter"]], decls: 1, vars: 1, consts: [["formField", ""], ["style", "display: inline-block;", 3, "formGroup", 4, "ngIf"], [2, "display", "inline-block", 3, "formGroup"], ["formControlName", "value", "fieldClass", "form-control-xs", 3, "field", "fieldOptions"]], template: function LookupFloatingFilterComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, LookupFloatingFilterComponent_div_0_Template, 3, 3, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.lookupField);
        } } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(LookupFloatingFilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-lookup-floating-filter', template: "<div style=\"display: inline-block;\" [formGroup]=\"formGroup\" *ngIf=\"lookupField\">\n  <xf-form-field [field]=\"lookupField\" #formField formControlName=\"value\" [fieldOptions]=\"fieldOptions\" fieldClass=\"form-control-xs\"></xf-form-field>\n</div>\n" }]
    }], () => [], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(LookupFloatingFilterComponent, { className: "LookupFloatingFilterComponent", filePath: "lib/form-fields/field-renderers/built-ins/lookup/lookup-floating-filter/lookup-floating-filter.component.ts", lineNumber: 14 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9va3VwLWZsb2F0aW5nLWZpbHRlci5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9mb3JtLWZpZWxkcy9maWVsZC1yZW5kZXJlcnMvYnVpbHQtaW5zL2xvb2t1cC9sb29rdXAtZmxvYXRpbmctZmlsdGVyL2xvb2t1cC1mbG9hdGluZy1maWx0ZXIuY29tcG9uZW50LnRzIiwiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL3NyYy9saWIvZm9ybS1maWVsZHMvZmllbGQtcmVuZGVyZXJzL2J1aWx0LWlucy9sb29rdXAvbG9va3VwLWZsb2F0aW5nLWZpbHRlci9sb29rdXAtZmxvYXRpbmctZmlsdGVyLmNvbXBvbmVudC5odG1sIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsTUFBTSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQ2xELE9BQU8sRUFBRSxXQUFXLEVBQWEsTUFBTSxnQkFBZ0IsQ0FBQztBQUN4RCxPQUFPLEVBQUUsZ0JBQWdCLEVBQUUsTUFBTSxvQkFBb0IsQ0FBQztBQUd0RCxPQUFPLEVBQUUsWUFBWSxFQUFFLE1BQU0sa0NBQWtDLENBQUM7OztJQ0xoRSw4QkFBZ0Y7SUFDOUUsc0NBQW1KO0lBQ3JKLGlCQUFNOzs7SUFGOEIsNENBQXVCO0lBQzFDLGNBQXFCO0lBQW9DLEFBQXpELDBDQUFxQixxQ0FBaUU7O0FEWXZHLE1BQU0sT0FBTyw2QkFBNkI7SUFTeEM7UUFQQSxnQkFBVyxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUtsQyxxQkFBZ0IsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUcxQyxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDO1lBQ3RDLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQztTQUNkLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDLE1BQVcsRUFBRSxFQUFFO1lBQ3BELElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLEtBQUssRUFBRSxJQUFJLElBQUksSUFBSSxDQUFDO1lBQy9DLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztRQUN0QixDQUFDLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxZQUFZLENBQUM7WUFDbkMsU0FBUyxFQUFFLEtBQUs7U0FDakIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELE1BQU0sQ0FBQyxNQUE2QjtRQUNsQyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztRQUNyQixJQUFJLFdBQVcsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxDQUFDLHFCQUFxQixFQUFFLEtBQUssQ0FBQztRQUN6RSxXQUFXLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDcEUsV0FBVyxDQUFDLFVBQVUsR0FBRztZQUN2QixRQUFRLEVBQUUsS0FBSztTQUNoQixDQUFDO1FBQ0YsV0FBVyxDQUFDLE1BQU0sR0FBRztZQUNuQixTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDO1FBQ0YsSUFBSSxDQUFDLFdBQVcsR0FBRyxXQUFXLENBQUM7SUFDakMsQ0FBQztJQUVELG9CQUFvQixDQUFDLFdBQWdCO1FBQ25DLDZEQUE2RDtRQUM3RCxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7WUFDakIsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLENBQUM7UUFDM0IsQ0FBQzthQUFNLENBQUM7WUFDTixJQUFJLENBQUMsWUFBWSxHQUFHLFdBQVcsQ0FBQyxNQUFNLENBQUM7UUFDekMsQ0FBQztJQUNILENBQUM7SUFHRCxZQUFZO1FBQ1YsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUN2QixJQUFJLENBQUMsTUFBTSxDQUFDLG9CQUFvQixDQUFDLENBQUMsUUFBUSxFQUFFLEVBQUU7Z0JBQzVDLFFBQVEsQ0FBQyx1QkFBdUIsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUM7WUFDL0MsQ0FBQyxDQUFDLENBQUM7UUFDTCxDQUFDO1FBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLFFBQVEsRUFBRSxFQUFFO1lBQzVDLFFBQVEsQ0FBQyx1QkFBdUIsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQzVELENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs4SEF0RFUsNkJBQTZCO29FQUE3Qiw2QkFBNkI7WUNiMUMsOEVBQWdGOztZQUFuQixzQ0FBaUI7OztpRkRhakUsNkJBQTZCO2NBTHpDLFNBQVM7MkJBQ0UsMkJBQTJCOztrRkFJMUIsNkJBQTZCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBpbmplY3QgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEZvcm1CdWlsZGVyLCBGb3JtR3JvdXAgfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XG5pbXBvcnQgeyBUcmFuc2xvY29TZXJ2aWNlIH0gZnJvbSAnQGpzdmVyc2UvdHJhbnNsb2NvJztcbmltcG9ydCB7IElGbG9hdGluZ0ZpbHRlckFuZ3VsYXJDb21wIH0gZnJvbSAnYWctZ3JpZC1hbmd1bGFyJztcbmltcG9ydCB7IElGbG9hdGluZ0ZpbHRlclBhcmFtcyB9IGZyb20gJ2FnLWdyaWQtY29tbXVuaXR5JztcbmltcG9ydCB7IEZpZWxkT3B0aW9ucyB9IGZyb20gJy4uLy4uLy4uLy4uL21vZGVscy9maWVsZC1vcHRpb25zJztcbmltcG9ydCB7IExvb2t1cEZpZWxkIH0gZnJvbSAnLi4vLi4vLi4vLi4vZmllbGQtdHlwZXMvbG9va3VwJztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAneGYtbG9va3VwLWZsb2F0aW5nLWZpbHRlcicsXG4gIHRlbXBsYXRlVXJsOiAnLi9sb29rdXAtZmxvYXRpbmctZmlsdGVyLmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vbG9va3VwLWZsb2F0aW5nLWZpbHRlci5jb21wb25lbnQuc2NzcyddXG59KVxuZXhwb3J0IGNsYXNzIExvb2t1cEZsb2F0aW5nRmlsdGVyQ29tcG9uZW50IGltcGxlbWVudHMgSUZsb2F0aW5nRmlsdGVyQW5ndWxhckNvbXAge1xuICBwYXJhbXMhOiBJRmxvYXRpbmdGaWx0ZXJQYXJhbXM7XG4gIGZvcm1CdWlsZGVyID0gaW5qZWN0KEZvcm1CdWlsZGVyKTtcbiAgZm9ybUdyb3VwOiBGb3JtR3JvdXA7XG4gIGN1cnJlbnRWYWx1ZTogYW55O1xuICBsb29rdXBGaWVsZCE6IExvb2t1cEZpZWxkO1xuICBmaWVsZE9wdGlvbnM6IEZpZWxkT3B0aW9ucztcbiAgdHJhbnNsb2NvU2VydmljZSA9IGluamVjdChUcmFuc2xvY29TZXJ2aWNlKTtcblxuICBjb25zdHJ1Y3RvcigpIHtcbiAgICB0aGlzLmZvcm1Hcm91cCA9IHRoaXMuZm9ybUJ1aWxkZXIuZ3JvdXAoe1xuICAgICAgdmFsdWU6IFtudWxsXVxuICAgIH0pO1xuICAgIHRoaXMuZm9ybUdyb3VwLnZhbHVlQ2hhbmdlcy5zdWJzY3JpYmUoKHZhbHVlczogYW55KSA9PiB7XG4gICAgICB0aGlzLmN1cnJlbnRWYWx1ZSA9IHZhbHVlcy52YWx1ZT8udXVpZCB8fCBudWxsO1xuICAgICAgdGhpcy51cGRhdGVGaWx0ZXIoKTtcbiAgICB9KTtcbiAgICB0aGlzLmZpZWxkT3B0aW9ucyA9IG5ldyBGaWVsZE9wdGlvbnMoe1xuICAgICAgc2hvd0xhYmVsOiBmYWxzZVxuICAgIH0pO1xuICB9XG5cbiAgYWdJbml0KHBhcmFtczogSUZsb2F0aW5nRmlsdGVyUGFyYW1zKTogdm9pZCB7XG4gICAgdGhpcy5wYXJhbXMgPSBwYXJhbXM7XG4gICAgbGV0IGxvb2t1cEZpZWxkID0gcGFyYW1zLmNvbHVtbi5nZXRDb2xEZWYoKS5oZWFkZXJDb21wb25lbnRQYXJhbXM/LmZpZWxkO1xuICAgIGxvb2t1cEZpZWxkLnBsYWNlaG9sZGVyID0gdGhpcy50cmFuc2xvY29TZXJ2aWNlLnRyYW5zbGF0ZSgnQ2hvb3NlJyk7XG4gICAgbG9va3VwRmllbGQudmFsaWRhdGlvbiA9IHtcbiAgICAgIHJlcXVpcmVkOiBmYWxzZVxuICAgIH07XG4gICAgbG9va3VwRmllbGQucGFyYW1zID0ge1xuICAgICAgY2xlYXJUZXh0OiAnQW55J1xuICAgIH07XG4gICAgdGhpcy5sb29rdXBGaWVsZCA9IGxvb2t1cEZpZWxkO1xuICB9XG5cbiAgb25QYXJlbnRNb2RlbENoYW5nZWQocGFyZW50TW9kZWw6IGFueSkge1xuICAgIC8vIFdoZW4gdGhlIGZpbHRlciBpcyBlbXB0eSB3ZSB3aWxsIHJlY2VpdmUgYSBudWxsIHZhbHVlIGhlcmVcbiAgICBpZiAoIXBhcmVudE1vZGVsKSB7XG4gICAgICB0aGlzLmN1cnJlbnRWYWx1ZSA9IG51bGw7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuY3VycmVudFZhbHVlID0gcGFyZW50TW9kZWwuZmlsdGVyO1xuICAgIH1cbiAgfVxuXG5cbiAgdXBkYXRlRmlsdGVyKCkge1xuICAgIGlmICghdGhpcy5jdXJyZW50VmFsdWUpIHtcbiAgICAgIHRoaXMucGFyYW1zLnBhcmVudEZpbHRlckluc3RhbmNlKChpbnN0YW5jZSkgPT4ge1xuICAgICAgICBpbnN0YW5jZS5vbkZsb2F0aW5nRmlsdGVyQ2hhbmdlZChudWxsLCBudWxsKTtcbiAgICAgIH0pO1xuICAgIH1cbiAgICB0aGlzLnBhcmFtcy5wYXJlbnRGaWx0ZXJJbnN0YW5jZSgoaW5zdGFuY2UpID0+IHtcbiAgICAgIGluc3RhbmNlLm9uRmxvYXRpbmdGaWx0ZXJDaGFuZ2VkKCdlcScsIHRoaXMuY3VycmVudFZhbHVlKTtcbiAgICB9KTtcbiAgfVxufVxuXG5cbiIsIjxkaXYgc3R5bGU9XCJkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XCIgW2Zvcm1Hcm91cF09XCJmb3JtR3JvdXBcIiAqbmdJZj1cImxvb2t1cEZpZWxkXCI+XG4gIDx4Zi1mb3JtLWZpZWxkIFtmaWVsZF09XCJsb29rdXBGaWVsZFwiICNmb3JtRmllbGQgZm9ybUNvbnRyb2xOYW1lPVwidmFsdWVcIiBbZmllbGRPcHRpb25zXT1cImZpZWxkT3B0aW9uc1wiIGZpZWxkQ2xhc3M9XCJmb3JtLWNvbnRyb2wteHNcIj48L3hmLWZvcm0tZmllbGQ+XG48L2Rpdj5cbiJdfQ==