import { Component, Input, ViewChild } from '@angular/core';
import { of } from 'rxjs';
import { concatMap, map } from 'rxjs/operators';
import { API } from '../../../../core/constants';
import { AbstractFieldComponent } from '../abstract-field.component';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "../../../../core/services/entity.service";
import * as i3 from "@angular/forms";
import * as i4 from "@angular/common";
import * as i5 from "ng-multiselect-dropdown";
import * as i6 from "@ng-bootstrap/ng-bootstrap";
import * as i7 from "../../../form-messages/form-messages.component";
const _c0 = ["multiselect"];
const _c1 = a0 => ({ "pe-0": a0 });
const _c2 = a0 => ({ "is-invalid": a0 });
function MultiselectFieldComponent_div_0_label_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 12);
    i0.ɵɵtext(1, "*");
    i0.ɵɵelementEnd();
} }
function MultiselectFieldComponent_div_0_label_1_span_3_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 13);
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate("ngbTooltip", ctx_r0.field.tooltip);
} }
function MultiselectFieldComponent_div_0_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 9);
    i0.ɵɵtext(1);
    i0.ɵɵtemplate(2, MultiselectFieldComponent_div_0_label_1_span_2_Template, 2, 0, "span", 10)(3, MultiselectFieldComponent_div_0_label_1_span_3_Template, 2, 1, "span", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("for", "multiselect-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.validation == null ? null : ctx_r0.field.validation.required);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.tooltip);
} }
function MultiselectFieldComponent_div_0_xf_form_messages_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "xf-form-messages", 15);
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵproperty("control", ctx_r0.fieldGroup.controls.input);
} }
function MultiselectFieldComponent_div_0_div_7_button_1_Template(rf, ctx) { if (rf & 1) {
    const _r2 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 18);
    i0.ɵɵlistener("click", function MultiselectFieldComponent_div_0_div_7_button_1_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r2); const ctx_r0 = i0.ɵɵnextContext(3); return i0.ɵɵresetView(ctx_r0.toggleJinja(true)); });
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(3);
    i0.ɵɵpropertyInterpolate1("id", "toggle-jinja-checkbox-", ctx_r0.field.name, "");
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate("{}");
} }
function MultiselectFieldComponent_div_0_div_7_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 16);
    i0.ɵɵtemplate(1, MultiselectFieldComponent_div_0_div_7_button_1_Template, 2, 3, "button", 17);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext(2);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
function MultiselectFieldComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 2);
    i0.ɵɵtemplate(1, MultiselectFieldComponent_div_0_label_1_Template, 4, 4, "label", 3);
    i0.ɵɵelementStart(2, "div", 4)(3, "div", 5);
    i0.ɵɵelement(4, "ng-multiselect-dropdown", 6, 0);
    i0.ɵɵtemplate(6, MultiselectFieldComponent_div_0_xf_form_messages_6_Template, 1, 1, "xf-form-messages", 7);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(7, MultiselectFieldComponent_div_0_div_7_Template, 2, 1, "div", 8);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("formGroup", ctx_r0.fieldGroup);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showLabel);
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngClass", i0.ɵɵpureFunction1(10, _c1, ctx_r0.field.allowJinjaToggle));
    i0.ɵɵadvance();
    i0.ɵɵproperty("id", "multiselect-" + ctx_r0.field.name)("placeholder", ctx_r0.field.placeholder || "")("settings", ctx_r0.dropdownSettings)("data", ctx_r0.options)("ngClass", i0.ɵɵpureFunction1(12, _c2, ctx_r0.fieldGroup.controls.input.invalid && ctx_r0.fieldGroup.controls.input.touched));
    i0.ɵɵadvance(2);
    i0.ɵɵproperty("ngIf", ctx_r0.fieldOptions.showError);
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngIf", ctx_r0.field.allowJinjaToggle);
} }
export class MultiselectFieldComponent extends AbstractFieldComponent {
    constructor(http, entityService, changeDetectorRef, formBuilder) {
        super(changeDetectorRef, formBuilder);
        this.http = http;
        this.entityService = entityService;
        this.options = [];
        this.dropdownSettings = {
            singleSelection: false,
            idField: 'value',
            textField: 'label',
            selectAllText: 'Select All',
            unSelectAllText: 'Deselect All',
            allowSearchFilter: true
        };
    }
    get value() {
        return this._value;
    }
    set value(value) {
        if (this._value !== value) {
            this._value = value;
            this.onChange(value);
            this.setSelectedOptions(value);
            this.changeDetectorRef.detectChanges();
        }
    }
    ngOnInit() {
        super.ngOnInit();
        this.fieldGroup?.valueChanges
            .pipe(map(values => values.input))
            .subscribe((options) => {
            const value = options.map((option) => option.value);
            this.onChange(value);
        });
        let options$;
        if (this.fieldOptions.options.length || this.field.options.length) {
            let options = this.fieldOptions.options.length > 0 ? this.fieldOptions.options : this.field.options || [];
            options$ = of(options);
        }
        else if (this.field.dataSource?.model) {
            options$ = this.entityService.build(this.field.dataSource.model).pipe(concatMap((entity) => {
                const url = `${this.field.dataSource.baseURL || API.QUERY}${this.field.dataSource.model}/`;
                const request = this.field.dataSource.requestType === 'GET' ? this.http.get(url, this.field.dataSource.query) : this.http.post(url, this.field.dataSource.query);
                return request.pipe(map((response) => {
                    return response['hydra:member'].map((item) => {
                        return {
                            value: item['@id'] || item.uuid,
                            label: this.entityService.getDisplayValue(entity, item)
                        };
                    });
                }));
            }));
        }
        else {
            options$ = of([]);
        }
        options$.subscribe((options) => {
            this.options = options;
            this.setSelectedOptions(this.value, false);
            this.changeDetectorRef.detectChanges();
        });
    }
    setSelectedOptions(value, emitEvent = true) {
        if (value && this.fieldGroup && this.fieldGroup.controls.input) {
            const selectedOptions = this.options.filter((option) => value.indexOf(option.value) > -1);
            this.fieldGroup?.controls.input.setValue(selectedOptions, { emitEvent: emitEvent });
        }
    }
    focus() {
        // not possible with ng-multiselect :/
    }
    static { this.ɵfac = function MultiselectFieldComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || MultiselectFieldComponent)(i0.ɵɵdirectiveInject(i1.HttpClient), i0.ɵɵdirectiveInject(i2.EntityService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i3.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: MultiselectFieldComponent, selectors: [["xf-multiselect-field"]], viewQuery: function MultiselectFieldComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.multiselect = _t.first);
        } }, inputs: { field: "field" }, features: [i0.ɵɵInheritDefinitionFeature], decls: 1, vars: 1, consts: [["multiselect", ""], ["class", "form-group", 3, "formGroup", 4, "ngIf"], [1, "form-group", 3, "formGroup"], ["class", "form-label margin-bottom-4px", 3, "for", 4, "ngIf"], [1, "d-flex"], [1, "flex-grow-1", 3, "ngClass"], ["formControlName", "input", 1, "multiselect-dropdown-wrapper", 3, "id", "placeholder", "settings", "data", "ngClass"], [3, "control", 4, "ngIf"], ["class", "w-auto ps-2", 4, "ngIf"], [1, "form-label", "margin-bottom-4px", 3, "for"], ["class", "text-danger margin-right-4px", 4, "ngIf"], [3, "ngbTooltip", 4, "ngIf"], [1, "text-danger", "margin-right-4px"], [3, "ngbTooltip"], [1, "fa", "fa-duotone", "fa-info-circle"], [3, "control"], [1, "w-auto", "ps-2"], ["type", "button", "class", "btn btn-secondary btn-sm h-36px", "title", "Add Custom Expression", 3, "id", "click", 4, "ngIf"], ["type", "button", "title", "Add Custom Expression", 1, "btn", "btn-secondary", "btn-sm", "h-36px", 3, "click", "id"]], template: function MultiselectFieldComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, MultiselectFieldComponent_div_0_Template, 8, 14, "div", 1);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.fieldGroup);
        } }, dependencies: [i4.NgClass, i4.NgIf, i3.NgControlStatus, i3.NgControlStatusGroup, i3.FormGroupDirective, i3.FormControlName, i5.MultiSelectComponent, i6.NgbTooltip, i7.FormMessagesComponent], styles: [".multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn{border-color:var(--form-default-border-color)!important;padding:8px!important;font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .selected-item{font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .selected-item a{color:rgb(var(--bs-danger-rgb))!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret{background-image:var(--form-select-dropdown-svg);background-repeat:no-repeat;background-position:right .75rem center;background-size:16px 12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret:before{content:unset!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list{background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);box-shadow:0 1px 5px var(--form-default-border-color);margin-top:0}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .item1 .multiselect-item-checkbox{border-bottom:1px solid var(--form-default-border-color)!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .no-filtered-data h5{font-size:14px;opacity:.7}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox{border-bottom:1px solid var(--form-default-border-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox input{color:var(--form-field-input-font-color);background-color:var(--form-default-bg-color);border:1px solid var(--form-default-border-color)!important;padding:5px 5px 5px 40px!important;font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox input:focus{box-shadow:var(--form-default-box-shadow);background-color:var(--form-default-bg-color);color:var(--form-field-input-focus-font-color);border-color:var(--form-default-focus-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .filter-textbox:before{content:\"\\f002\";display:inline-block;position:absolute;font-family:\"Font Awesome 6 Pro\";opacity:.5;font-size:14px;top:11px;left:12px;padding:4px 8px;border-right:1px solid var(--border-primary-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]{background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]:checked+div:before{background-color:var(--highlight-active-color);background-image:var(--form-checkbox-bg-svg);background-position:center}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div{color:var(--font-primary-color);font-size:12px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:before{background-color:var(--form-default-bg-color);border-color:var(--form-check-border-color);color:var(--form-field-input-font-color);border-radius:4px}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:after{content:unset!important}.multiselect-dropdown-wrapper[_ngcontent-%COMP%]     .multiselect-dropdown .dropdown-list .multiselect-item-checkbox:hover{background-color:var(--element-inverse-bg-color)}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(MultiselectFieldComponent, [{
        type: Component,
        args: [{ selector: 'xf-multiselect-field', template: "<div class=\"form-group\" *ngIf=\"fieldGroup\" [formGroup]=\"fieldGroup\">\n  <label [for]=\"'multiselect-' + field.name\" class=\"form-label margin-bottom-4px\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n    <span *ngIf=\"field.validation?.required\" class=\"text-danger margin-right-4px\">*</span>\n    <span *ngIf=\"field.tooltip\" ngbTooltip=\"{{field.tooltip}}\">\n      <i class=\"fa fa-duotone fa-info-circle\"></i>\n    </span>\n  </label>\n  <div class=\"d-flex\">\n    <div class=\"flex-grow-1\" [ngClass]=\"{'pe-0': field.allowJinjaToggle}\">\n      <ng-multiselect-dropdown [id]=\"'multiselect-' + field.name\" [placeholder]=\"field.placeholder || ''\"\n        [settings]=\"dropdownSettings\" [data]=\"options\" formControlName=\"input\" class=\"multiselect-dropdown-wrapper\"\n        [ngClass]=\"{'is-invalid': fieldGroup.controls.input.invalid && fieldGroup.controls.input.touched}\"\n        #multiselect></ng-multiselect-dropdown>\n      <xf-form-messages *ngIf=\"fieldOptions.showError\" [control]=\"fieldGroup.controls.input\"></xf-form-messages>\n    </div>\n    <div class=\"w-auto ps-2\" *ngIf=\"field.allowJinjaToggle\">\n      <button type=\"button\" class=\"btn btn-secondary btn-sm h-36px\" (click)=\"toggleJinja(true)\"\n        *ngIf=\"field.allowJinjaToggle\" title=\"Add Custom Expression\" id=\"toggle-jinja-checkbox-{{ field.name }}\">{{ '{}'\n        }}</button>\n    </div>\n  </div>\n\n</div>\n", styles: [".multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn{border-color:var(--form-default-border-color)!important;padding:8px!important;font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .selected-item{font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .selected-item a{color:rgb(var(--bs-danger-rgb))!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret{background-image:var(--form-select-dropdown-svg);background-repeat:no-repeat;background-position:right .75rem center;background-size:16px 12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-btn .dropdown-multiselect__caret:before{content:unset!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list{background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);box-shadow:0 1px 5px var(--form-default-border-color);margin-top:0}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .item1 .multiselect-item-checkbox{border-bottom:1px solid var(--form-default-border-color)!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .no-filtered-data h5{font-size:14px;opacity:.7}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox{border-bottom:1px solid var(--form-default-border-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox input{color:var(--form-field-input-font-color);background-color:var(--form-default-bg-color);border:1px solid var(--form-default-border-color)!important;padding:5px 5px 5px 40px!important;font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox input:focus{box-shadow:var(--form-default-box-shadow);background-color:var(--form-default-bg-color);color:var(--form-field-input-focus-font-color);border-color:var(--form-default-focus-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .filter-textbox:before{content:\"\\f002\";display:inline-block;position:absolute;font-family:\"Font Awesome 6 Pro\";opacity:.5;font-size:14px;top:11px;left:12px;padding:4px 8px;border-right:1px solid var(--border-primary-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]{background-color:var(--form-default-bg-color);border-color:var(--form-default-border-color);color:var(--form-field-input-font-color)}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]:checked+div:before{background-color:var(--highlight-active-color);background-image:var(--form-checkbox-bg-svg);background-position:center}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div{color:var(--font-primary-color);font-size:12px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:before{background-color:var(--form-default-bg-color);border-color:var(--form-check-border-color);color:var(--form-field-input-font-color);border-radius:4px}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox input[type=checkbox]+div:after{content:unset!important}.multiselect-dropdown-wrapper ::ng-deep .multiselect-dropdown .dropdown-list .multiselect-item-checkbox:hover{background-color:var(--element-inverse-bg-color)}\n"] }]
    }], () => [{ type: i1.HttpClient }, { type: i2.EntityService }, { type: i0.ChangeDetectorRef }, { type: i3.FormBuilder }], { field: [{
            type: Input
        }], multiselect: [{
            type: ViewChild,
            args: ['multiselect']
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(MultiselectFieldComponent, { className: "MultiselectFieldComponent", filePath: "lib/form-fields/field-renderers/built-ins/multiselect/multiselect-field.component.ts", lineNumber: 23 }); })();
//# sourceMappingURL=data:application/json;base64,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