import { ChangeDetectionStrategy, Component } from '@angular/core';
import { isString } from 'lodash-es';
import { AbstractViewComponent } from '../abstract-view.component';
import * as i0 from "@angular/core";
import * as i1 from "../../../../core/services/theme.service";
import * as i2 from "./picklist.service";
import * as i3 from "@angular/common";
import * as i4 from "../../../../utility/pipes/is-hex-color-light.pipe";
const _c0 = (a0, a1) => ({ "background": a0, "color": a1 });
function PicklistViewComponent_label_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "label", 3);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵproperty("for", "input-" + ctx_r0.field.name);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate1(" ", ctx_r0.field.title, " ");
} }
export class PicklistViewComponent extends AbstractViewComponent {
    constructor(themeService, _changeDetectorRef, picklistService) {
        super(_changeDetectorRef);
        this.themeService = themeService;
        this._changeDetectorRef = _changeDetectorRef;
        this.picklistService = picklistService;
        this.currentTheme = this.themeService.getTheme();
    }
    ngOnInit() {
        super.ngOnInit();
        if (isString(this.value)) {
            this.picklistService.getPicklistByUUID(this.value).subscribe((value) => {
                this.value = value;
                this._changeDetectorRef.detectChanges();
            });
        }
    }
    static { this.ɵfac = function PicklistViewComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistViewComponent)(i0.ɵɵdirectiveInject(i1.ThemeService), i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i2.PicklistService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: PicklistViewComponent, selectors: [["xf-picklist-view"]], features: [i0.ɵɵInheritDefinitionFeature], decls: 5, vars: 12, consts: [[1, "form-group"], ["class", "form-label margin-bottom-4px d-block", 3, "for", 4, "ngIf"], [3, "ngClass", "ngStyle"], [1, "form-label", "margin-bottom-4px", "d-block", 3, "for"]], template: function PicklistViewComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0);
            i0.ɵɵtemplate(1, PicklistViewComponent_label_1_Template, 2, 2, "label", 1);
            i0.ɵɵelementStart(2, "p", 2);
            i0.ɵɵpipe(3, "isHexColorLight");
            i0.ɵɵtext(4);
            i0.ɵɵelementEnd()();
        } if (rf & 2) {
            i0.ɵɵadvance();
            i0.ɵɵproperty("ngIf", ctx.fieldOptions.showLabel);
            i0.ɵɵadvance();
            i0.ɵɵclassMapInterpolate1("d-inline-block font-size-14px lh-1 minw-100px mw-fit-content picklist-view text-center ", ctx.fieldClass, "");
            i0.ɵɵproperty("ngClass", (ctx.value == null ? null : ctx.value.color) ? "content-font" : "")("ngStyle", i0.ɵɵpureFunction2(9, _c0, (ctx.value == null ? null : ctx.value.color) ? ctx.value.color : "", (ctx.value == null ? null : ctx.value.color) && i0.ɵɵpipeBind1(3, 7, ctx.value == null ? null : ctx.value.color) ? "rgba(0, 0, 0, 0.8)" : (ctx.value == null ? null : ctx.value.color) ? "rgba(255, 255, 255, 0.8)" : !(ctx.value == null ? null : ctx.value.color) && ctx.currentTheme === "light" ? "rgba(0, 0, 0, 0.8)" : "rgba(255, 255, 255, 0.8)"));
            i0.ɵɵadvance(2);
            i0.ɵɵtextInterpolate(ctx.value ? ctx.value.itemValue : "--");
        } }, dependencies: [i3.NgClass, i3.NgIf, i3.NgStyle, i4.IsHexColorLightPipe], changeDetection: 0 }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistViewComponent, [{
        type: Component,
        args: [{ selector: 'xf-picklist-view', changeDetection: ChangeDetectionStrategy.OnPush, template: "<div class=\"form-group\">\n  <label [for]=\"'input-' + field.name\" class=\"form-label margin-bottom-4px d-block\" *ngIf=\"fieldOptions.showLabel\">\n    {{ field.title }}\n  </label>\n  <p class=\"d-inline-block font-size-14px lh-1 minw-100px mw-fit-content picklist-view text-center {{fieldClass}}\"\n    [ngClass]=\"value?.color ? 'content-font' : ''\" [ngStyle]=\"{\n    'background': value?.color ? value.color : '',\n    'color': (value?.color) && (value?.color | isHexColorLight) ? 'rgba(0, 0, 0, 0.8)' : value?.color ? 'rgba(255, 255, 255, 0.8)' : (!value?.color && currentTheme === 'light') ? 'rgba(0, 0, 0, 0.8)' : 'rgba(255, 255, 255, 0.8)'\n  }\">{{ value ? value.itemValue : '--' }}</p>\n</div>\n" }]
    }], () => [{ type: i1.ThemeService }, { type: i0.ChangeDetectorRef }, { type: i2.PicklistService }], null); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(PicklistViewComponent, { className: "PicklistViewComponent", filePath: "lib/form-fields/field-renderers/built-ins/picklist/picklist-view.component.ts", lineNumber: 14 }); })();
//# sourceMappingURL=data:application/json;base64,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