import { Injectable } from '@angular/core';
import { plainToInstance } from 'class-transformer';
import * as _ from 'lodash-es';
import { isObject } from 'lodash-es';
import { forEach } from 'lodash-es';
import { of, throwError, catchError, Subject } from 'rxjs';
import { map } from 'rxjs/operators';
import { ALL_RECORDS_SIZE, API } from '../../../../core/constants';
import { PicklistName } from './models/picklistName';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "../../../../core/services/storage.service";
import * as i3 from "../../../../core/services/entity.service";
export class PicklistService {
    constructor(http, storage, entityService) {
        this.http = http;
        this.storage = storage;
        this.entityService = entityService;
        this.picklists = null;
    }
    loadPicklistName(picklistName) {
        if (this.picklists && this.picklists[picklistName]) {
            return of(plainToInstance(PicklistName, this.picklists[picklistName]));
        }
        return this.http
            .get(API.API_3_BASE + 'picklist_names', {
            params: {
                name: picklistName
            }
        })
            .pipe(map((response) => plainToInstance(PicklistName, response['hydra:member'][0])));
    }
    getPicklistByIri(iri) {
        let iriParts = iri.split('/');
        let getChildPicklistValue = iriParts[3] === 'picklists';
        return this.loadAllPicklists().pipe(map((picklistNames) => {
            let result;
            if (getChildPicklistValue) {
                for (let i = 0; i < picklistNames.length; i++) {
                    let _picklistName = picklistNames[i];
                    result = _.find(_picklistName.picklists, (picklist) => {
                        return picklist['@id'] === iri;
                    });
                    if (result) {
                        break;
                    }
                }
            }
            else {
                result = _.find(picklistNames, (picklistName) => {
                    return picklistName['@id'] === iri;
                });
            }
            if (result) {
                return result;
            }
            else {
                return;
            }
        }));
    }
    getPicklistByUUID(uuid) {
        return this.loadAllPicklists().pipe(map((picklists) => {
            let result = _.find(picklists, (picklist) => {
                return picklist.uuid === uuid;
            });
            return result;
        }));
    }
    removeFromCache(picklist) {
        if (isObject(picklist)) {
            // this.storage.remove('picklists.'+picklist.name);
            // localStorageService.remove('picklists.'+$filter('getEndPathName')(picklist['@id']));
        }
        else {
            //localStorageService.remove('picklists.'+picklist);
        }
    }
    loadAllPicklists(useExport = false) {
        // TODO: Picklist URL needs to change
        //const url = `${API.API_3_BASE}picklist_names?$export=${useExport}&$limit=${ALL_RECORDS_SIZE}&$orderby=name&$relationships=true`;
        const url = 'assets/dummyData/picklists.json';
        if (this.picklists) {
            return of(this.picklists);
        }
        return this.http.get(url).pipe(map((response) => {
            this.picklists = {};
            forEach(response['hydra:member'], (picklist) => {
                this.picklists[picklist.name] = picklist;
            });
            return response['hydra:member'];
        }));
    }
    loadPicklists(field, metadata) {
        let picklists$ = new Subject();
        let entity$;
        if (!metadata) {
            entity$ = this.entityService.build('picklists').pipe(map((entity) => {
                metadata = entity;
                return metadata;
            }));
        }
        else {
            entity$ = of(metadata);
        }
        entity$.subscribe({
            next: (entity) => {
                if (field?.dataSource?.query?.filters?.length > 0 && field.dataSource?.query.filters[0]?.value) {
                    const picklists = this.storage.getItem('picklists.' + field.dataSource.query.filters[0].value);
                    if (picklists && picklists.length > 0) {
                        field.options = picklists;
                        this.entityService.setDisplayName(field, entity);
                        picklists$.next(field);
                        picklists$.complete();
                    }
                    else {
                        this.loadPicklistsByParams(field.dataSource.query.filters[0].value, 'name').subscribe({
                            next: (result) => {
                                if (result && result.length > 0) {
                                    field.options = result;
                                    this.entityService.setDisplayName(field, entity);
                                    this.storage.setItem('picklists.' + field.dataSource.query.filters[0].value, field.options);
                                    picklists$.next(field);
                                    picklists$.complete();
                                }
                                else {
                                    picklists$.next({});
                                    picklists$.complete();
                                }
                            }, error: (error) => {
                                picklists$.error(error);
                            }
                        });
                    }
                }
                else {
                    picklists$.error(false);
                }
            }, error: (error) => {
                picklists$.error(error);
            }
        });
        return picklists$.asObservable();
    }
    loadPicklistsByParams(itemVal, itemKey) {
        let picklists = this.storage.getItem(`picklists.${itemVal}`);
        if (picklists && picklists.length > 0) {
            return of(picklists);
        }
        else {
            let query = {
                limit: ALL_RECORDS_SIZE,
                $orderby: 'orderIndex'
            };
            query['listName__' + itemKey] = itemVal;
            return this.http.get(`${API.BASE}picklists`, { params: query }).pipe(map((result) => {
                if (result && result['hydra:member']) {
                    this.storage.setItem('picklists.' + itemVal, picklists);
                    return result['hydra:member'];
                }
                else {
                    return throwError(() => new Error('Not a valid picklist query'));
                }
            }), catchError(error => {
                return throwError(() => error);
            }));
        }
    }
    static { this.ɵfac = function PicklistService_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || PicklistService)(i0.ɵɵinject(i1.HttpClient), i0.ɵɵinject(i2.StorageService), i0.ɵɵinject(i3.EntityService)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: PicklistService, factory: PicklistService.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(PicklistService, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], () => [{ type: i1.HttpClient }, { type: i2.StorageService }, { type: i3.EntityService }], null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlja2xpc3Quc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zcmMvbGliL2Zvcm0tZmllbGRzL2ZpZWxkLXJlbmRlcmVycy9idWlsdC1pbnMvcGlja2xpc3QvcGlja2xpc3Quc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzNDLE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQztBQUNwRCxPQUFPLEtBQUssQ0FBQyxNQUFNLFdBQVcsQ0FBQztBQUMvQixPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQ3JDLE9BQU8sRUFBRSxPQUFPLEVBQUUsTUFBTSxXQUFXLENBQUM7QUFDcEMsT0FBTyxFQUFjLEVBQUUsRUFBRSxVQUFVLEVBQUUsVUFBVSxFQUFFLE9BQU8sRUFBRSxNQUFNLE1BQU0sQ0FBQztBQUN2RSxPQUFPLEVBQUUsR0FBRyxFQUFhLE1BQU0sZ0JBQWdCLENBQUM7QUFDaEQsT0FBTyxFQUFFLGdCQUFnQixFQUFFLEdBQUcsRUFBRSxNQUFNLDRCQUE0QixDQUFDO0FBU25FLE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSx1QkFBdUIsQ0FBQzs7Ozs7QUFLckQsTUFBTSxPQUFPLGVBQWU7SUFHMUIsWUFDVSxJQUFnQixFQUNoQixPQUF1QixFQUN2QixhQUE0QjtRQUY1QixTQUFJLEdBQUosSUFBSSxDQUFZO1FBQ2hCLFlBQU8sR0FBUCxPQUFPLENBQWdCO1FBQ3ZCLGtCQUFhLEdBQWIsYUFBYSxDQUFlO1FBTHRDLGNBQVMsR0FBb0MsSUFBSSxDQUFDO0lBTTlDLENBQUM7SUFFTCxnQkFBZ0IsQ0FBQyxZQUFvQjtRQUNuQyxJQUFJLElBQUksQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUMsRUFBRSxDQUFDO1lBQ25ELE9BQU8sRUFBRSxDQUFDLGVBQWUsQ0FBQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQVcsQ0FBQyxDQUFDLENBQUM7UUFDbkYsQ0FBQztRQUNELE9BQU8sSUFBSSxDQUFDLElBQUk7YUFDYixHQUFHLENBQUMsR0FBRyxDQUFDLFVBQVUsR0FBRyxnQkFBZ0IsRUFBRTtZQUN0QyxNQUFNLEVBQUU7Z0JBQ04sSUFBSSxFQUFFLFlBQVk7YUFDbkI7U0FDRixDQUFDO2FBQ0QsSUFBSSxDQUNILEdBQUcsQ0FBQyxDQUFDLFFBQWEsRUFBRSxFQUFFLENBQUMsZUFBZSxDQUFDLFlBQVksRUFBRSxRQUFRLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxDQUFXLENBQUMsQ0FBQyxDQUM3RixDQUFDO0lBQ04sQ0FBQztJQUVELGdCQUFnQixDQUFDLEdBQVc7UUFDMUIsSUFBSSxRQUFRLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUM5QixJQUFJLHFCQUFxQixHQUFHLFFBQVEsQ0FBQyxDQUFDLENBQUMsS0FBSyxXQUFXLENBQUM7UUFDeEQsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsYUFBa0IsRUFBRSxFQUFFO1lBQzdELElBQUksTUFBTSxDQUFDO1lBQ1gsSUFBSSxxQkFBcUIsRUFBRSxDQUFDO2dCQUMxQixLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsYUFBYSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDO29CQUM5QyxJQUFJLGFBQWEsR0FBRyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUM7b0JBQ3JDLE1BQU0sR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxTQUFTLEVBQUUsQ0FBQyxRQUFRLEVBQUUsRUFBRTt3QkFDcEQsT0FBTyxRQUFRLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxDQUFDO29CQUNqQyxDQUFDLENBQUMsQ0FBQztvQkFDSCxJQUFJLE1BQU0sRUFBRSxDQUFDO3dCQUNYLE1BQU07b0JBQ1IsQ0FBQztnQkFDSCxDQUFDO1lBQ0gsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE1BQU0sR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDLFlBQVksRUFBRSxFQUFFO29CQUM5QyxPQUFPLFlBQVksQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLENBQUM7Z0JBQ3JDLENBQUMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztZQUNELElBQUksTUFBTSxFQUFFLENBQUM7Z0JBQ1gsT0FBTyxNQUFNLENBQUM7WUFDaEIsQ0FBQztpQkFBTSxDQUFDO2dCQUNOLE9BQU87WUFDVCxDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNOLENBQUM7SUFFRCxpQkFBaUIsQ0FBQyxJQUFZO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFNBQXlCLEVBQUUsRUFBRTtZQUNwRSxJQUFJLE1BQU0sR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDLFFBQWtCLEVBQUUsRUFBRTtnQkFDcEQsT0FBTyxRQUFRLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQztZQUNoQyxDQUFDLENBQUMsQ0FBQztZQUNILE9BQU8sTUFBTSxDQUFDO1FBQ2hCLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDTixDQUFDO0lBRUQsZUFBZSxDQUFDLFFBQWE7UUFDM0IsSUFBSSxRQUFRLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQztZQUN2QixtREFBbUQ7WUFDbkQsdUZBQXVGO1FBQ3pGLENBQUM7YUFBTSxDQUFDO1lBQ04sb0RBQW9EO1FBQ3RELENBQUM7SUFDSCxDQUFDO0lBRUQsZ0JBQWdCLENBQUMsWUFBcUIsS0FBSztRQUN6QyxxQ0FBcUM7UUFDckMsa0lBQWtJO1FBQ2xJLE1BQU0sR0FBRyxHQUFHLGlDQUFpQyxDQUFDO1FBQzlDLElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ25CLE9BQU8sRUFBRSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUM1QixDQUFDO1FBQ0QsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsUUFBYSxFQUFFLEVBQUU7WUFDbkQsSUFBSSxDQUFDLFNBQVMsR0FBRyxFQUFFLENBQUM7WUFDcEIsT0FBTyxDQUFDLFFBQVEsQ0FBQyxjQUFjLENBQUMsRUFBRSxDQUFDLFFBQWtCLEVBQUUsRUFBRTtnQkFDdkQsSUFBSSxDQUFDLFNBQVUsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEdBQUcsUUFBUSxDQUFDO1lBQzVDLENBQUMsQ0FBQyxDQUFDO1lBQ0gsT0FBTyxRQUFRLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDbEMsQ0FBQyxDQUFDLENBQ0QsQ0FBQztJQUNKLENBQUM7SUFFRCxhQUFhLENBQUMsS0FBb0IsRUFBRSxRQUFjO1FBQ2hELElBQUksVUFBVSxHQUFHLElBQUksT0FBTyxFQUFPLENBQUM7UUFDcEMsSUFBSSxPQUEyQixDQUFDO1FBQ2hDLElBQUksQ0FBQyxRQUFRLEVBQUUsQ0FBQztZQUNkLE9BQU8sR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsTUFBTSxFQUFFLEVBQUU7Z0JBQ2xFLFFBQVEsR0FBRyxNQUFNLENBQUM7Z0JBQ2xCLE9BQU8sUUFBUSxDQUFDO1lBQ2xCLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDTixDQUFDO2FBQU0sQ0FBQztZQUNOLE9BQU8sR0FBRyxFQUFFLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDekIsQ0FBQztRQUNELE9BQU8sQ0FBQyxTQUFTLENBQUM7WUFDaEIsSUFBSSxFQUFFLENBQUMsTUFBYyxFQUFFLEVBQUU7Z0JBQ3ZCLElBQUksS0FBSyxFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsT0FBTyxFQUFFLE1BQU0sR0FBRyxDQUFDLElBQUksS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUFFLEtBQUssRUFBRSxDQUFDO29CQUMvRixNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDO29CQUMvRixJQUFJLFNBQVMsSUFBSSxTQUFTLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO3dCQUN0QyxLQUFLLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQzt3QkFDMUIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDO3dCQUNqRCxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO3dCQUN2QixVQUFVLENBQUMsUUFBUSxFQUFFLENBQUM7b0JBQ3hCLENBQUM7eUJBQU0sQ0FBQzt3QkFDTixJQUFJLENBQUMscUJBQXFCLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxNQUFNLENBQUMsQ0FBQyxTQUFTLENBQUM7NEJBQ3BGLElBQUksRUFBRSxDQUFDLE1BQVcsRUFBRSxFQUFFO2dDQUNwQixJQUFJLE1BQU0sSUFBSSxNQUFNLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDO29DQUNoQyxLQUFLLENBQUMsT0FBTyxHQUFHLE1BQU0sQ0FBQztvQ0FDdkIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLE1BQU0sQ0FBQyxDQUFDO29DQUNqRCxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUM7b0NBQzVGLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7b0NBQ3ZCLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQ0FDeEIsQ0FBQztxQ0FBTSxDQUFDO29DQUNOLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUM7b0NBQ3BCLFVBQVUsQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQ0FDeEIsQ0FBQzs0QkFDSCxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUMsS0FBSyxFQUFFLEVBQUU7Z0NBQ2xCLFVBQVUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7NEJBQzFCLENBQUM7eUJBQ0YsQ0FBQyxDQUFDO29CQUNMLENBQUM7Z0JBQ0gsQ0FBQztxQkFBTSxDQUFDO29CQUNOLFVBQVUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQzFCLENBQUM7WUFDSCxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUMsS0FBSyxFQUFFLEVBQUU7Z0JBQ2xCLFVBQVUsQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDMUIsQ0FBQztTQUNGLENBQUMsQ0FBQztRQUNILE9BQU8sVUFBVSxDQUFDLFlBQVksRUFBRSxDQUFDO0lBQ25DLENBQUM7SUFFRCxxQkFBcUIsQ0FBQyxPQUFlLEVBQUUsT0FBZTtRQUNwRCxJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxhQUFhLE9BQU8sRUFBRSxDQUFDLENBQUM7UUFDN0QsSUFBSSxTQUFTLElBQUksU0FBUyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztZQUN0QyxPQUFPLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUN2QixDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksS0FBSyxHQUFRO2dCQUNmLEtBQUssRUFBRSxnQkFBZ0I7Z0JBQ3ZCLFFBQVEsRUFBRSxZQUFZO2FBQ3ZCLENBQUM7WUFDRixLQUFLLENBQUMsWUFBWSxHQUFHLE9BQU8sQ0FBQyxHQUFHLE9BQU8sQ0FBQztZQUN4QyxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsR0FBRyxDQUFDLElBQUksV0FBVyxFQUFFLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLE1BQVcsRUFBRSxFQUFFO2dCQUN2RixJQUFJLE1BQU0sSUFBSSxNQUFNLENBQUMsY0FBYyxDQUFDLEVBQUUsQ0FBQztvQkFDckMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsWUFBWSxHQUFHLE9BQU8sRUFBRSxTQUFTLENBQUMsQ0FBQztvQkFDeEQsT0FBTyxNQUFNLENBQUMsY0FBYyxDQUFDLENBQUM7Z0JBQ2hDLENBQUM7cUJBQU0sQ0FBQztvQkFDTixPQUFPLFVBQVUsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxJQUFJLEtBQUssQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDLENBQUM7Z0JBQ25FLENBQUM7WUFDSCxDQUFDLENBQUMsRUFBRSxVQUFVLENBQUMsS0FBSyxDQUFDLEVBQUU7Z0JBQ3JCLE9BQU8sVUFBVSxDQUFDLEdBQUcsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ2pDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDTixDQUFDO0lBQ0gsQ0FBQztnSEE1SlUsZUFBZTt1RUFBZixlQUFlLFdBQWYsZUFBZSxtQkFGZCxNQUFNOztpRkFFUCxlQUFlO2NBSDNCLFVBQVU7ZUFBQztnQkFDVixVQUFVLEVBQUUsTUFBTTthQUNuQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEh0dHBDbGllbnQgfSBmcm9tICdAYW5ndWxhci9jb21tb24vaHR0cCc7XG5pbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBwbGFpblRvSW5zdGFuY2UgfSBmcm9tICdjbGFzcy10cmFuc2Zvcm1lcic7XG5pbXBvcnQgKiBhcyBfIGZyb20gJ2xvZGFzaC1lcyc7XG5pbXBvcnQgeyBpc09iamVjdCB9IGZyb20gJ2xvZGFzaC1lcyc7XG5pbXBvcnQgeyBmb3JFYWNoIH0gZnJvbSAnbG9kYXNoLWVzJztcbmltcG9ydCB7IE9ic2VydmFibGUsIG9mLCB0aHJvd0Vycm9yLCBjYXRjaEVycm9yLCBTdWJqZWN0IH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBtYXAsIHN3aXRjaE1hcCB9IGZyb20gJ3J4anMvb3BlcmF0b3JzJztcbmltcG9ydCB7IEFMTF9SRUNPUkRTX1NJWkUsIEFQSSB9IGZyb20gJy4uLy4uLy4uLy4uL2NvcmUvY29uc3RhbnRzJztcbmltcG9ydCB7IEVudGl0eSB9IGZyb20gJy4uLy4uLy4uLy4uL2NvcmUvbW9kZWxzL2VudGl0eSc7XG5pbXBvcnQgeyBGaWVsZCB9IGZyb20gJy4uLy4uLy4uLy4uL2NvcmUvbW9kZWxzL2ZpZWxkJztcbmltcG9ydCB7IEVudGl0eVNlcnZpY2UgfSBmcm9tICcuLi8uLi8uLi8uLi9jb3JlL3NlcnZpY2VzL2VudGl0eS5zZXJ2aWNlJztcbmltcG9ydCB7IE1vZGVsTWV0YWRhdGFTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy9tb2RlbC1tZXRhZGF0YS5zZXJ2aWNlJztcbmltcG9ydCB7IFN0b3JhZ2VTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy9zdG9yYWdlLnNlcnZpY2UnO1xuaW1wb3J0IHsgU3Vic2NyaXB0aW9uUXVldWVTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy9zdWJzY3JpcHRpb24tcXVldWUuc2VydmljZSc7XG5pbXBvcnQgeyBQaWNrbGlzdEZpZWxkIH0gZnJvbSAnLi4vLi4vLi4vZmllbGQtdHlwZXMvcGlja2xpc3QnO1xuaW1wb3J0IHsgUGlja2xpc3QgfSBmcm9tICcuL21vZGVscy9waWNrbGlzdCc7XG5pbXBvcnQgeyBQaWNrbGlzdE5hbWUgfSBmcm9tICcuL21vZGVscy9waWNrbGlzdE5hbWUnO1xuXG5ASW5qZWN0YWJsZSh7XG4gIHByb3ZpZGVkSW46ICdyb290J1xufSlcbmV4cG9ydCBjbGFzcyBQaWNrbGlzdFNlcnZpY2Uge1xuICBwaWNrbGlzdHM6IFJlY29yZDxzdHJpbmcsIFBpY2tsaXN0PiB8IG51bGwgPSBudWxsO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgaHR0cDogSHR0cENsaWVudCxcbiAgICBwcml2YXRlIHN0b3JhZ2U6IFN0b3JhZ2VTZXJ2aWNlLFxuICAgIHByaXZhdGUgZW50aXR5U2VydmljZTogRW50aXR5U2VydmljZVxuICApIHsgfVxuXG4gIGxvYWRQaWNrbGlzdE5hbWUocGlja2xpc3ROYW1lOiBzdHJpbmcpOiBPYnNlcnZhYmxlPFBpY2tsaXN0TmFtZT4ge1xuICAgIGlmICh0aGlzLnBpY2tsaXN0cyAmJiB0aGlzLnBpY2tsaXN0c1twaWNrbGlzdE5hbWVdKSB7XG4gICAgICByZXR1cm4gb2YocGxhaW5Ub0luc3RhbmNlKFBpY2tsaXN0TmFtZSwgdGhpcy5waWNrbGlzdHNbcGlja2xpc3ROYW1lXSBhcyBvYmplY3QpKTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuaHR0cFxuICAgICAgLmdldChBUEkuQVBJXzNfQkFTRSArICdwaWNrbGlzdF9uYW1lcycsIHtcbiAgICAgICAgcGFyYW1zOiB7XG4gICAgICAgICAgbmFtZTogcGlja2xpc3ROYW1lXG4gICAgICAgIH1cbiAgICAgIH0pXG4gICAgICAucGlwZShcbiAgICAgICAgbWFwKChyZXNwb25zZTogYW55KSA9PiBwbGFpblRvSW5zdGFuY2UoUGlja2xpc3ROYW1lLCByZXNwb25zZVsnaHlkcmE6bWVtYmVyJ11bMF0gYXMgb2JqZWN0KSlcbiAgICAgICk7XG4gIH1cblxuICBnZXRQaWNrbGlzdEJ5SXJpKGlyaTogc3RyaW5nKTogT2JzZXJ2YWJsZTxQaWNrbGlzdE5hbWU+IHtcbiAgICBsZXQgaXJpUGFydHMgPSBpcmkuc3BsaXQoJy8nKTtcbiAgICBsZXQgZ2V0Q2hpbGRQaWNrbGlzdFZhbHVlID0gaXJpUGFydHNbM10gPT09ICdwaWNrbGlzdHMnO1xuICAgIHJldHVybiB0aGlzLmxvYWRBbGxQaWNrbGlzdHMoKS5waXBlKG1hcCgocGlja2xpc3ROYW1lczogYW55KSA9PiB7XG4gICAgICBsZXQgcmVzdWx0O1xuICAgICAgaWYgKGdldENoaWxkUGlja2xpc3RWYWx1ZSkge1xuICAgICAgICBmb3IgKGxldCBpID0gMDsgaSA8IHBpY2tsaXN0TmFtZXMubGVuZ3RoOyBpKyspIHtcbiAgICAgICAgICBsZXQgX3BpY2tsaXN0TmFtZSA9IHBpY2tsaXN0TmFtZXNbaV07XG4gICAgICAgICAgcmVzdWx0ID0gXy5maW5kKF9waWNrbGlzdE5hbWUucGlja2xpc3RzLCAocGlja2xpc3QpID0+IHtcbiAgICAgICAgICAgIHJldHVybiBwaWNrbGlzdFsnQGlkJ10gPT09IGlyaTtcbiAgICAgICAgICB9KTtcbiAgICAgICAgICBpZiAocmVzdWx0KSB7XG4gICAgICAgICAgICBicmVhaztcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIHJlc3VsdCA9IF8uZmluZChwaWNrbGlzdE5hbWVzLCAocGlja2xpc3ROYW1lKSA9PiB7XG4gICAgICAgICAgcmV0dXJuIHBpY2tsaXN0TmFtZVsnQGlkJ10gPT09IGlyaTtcbiAgICAgICAgfSk7XG4gICAgICB9XG4gICAgICBpZiAocmVzdWx0KSB7XG4gICAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm47XG4gICAgICB9XG4gICAgfSkpO1xuICB9XG5cbiAgZ2V0UGlja2xpc3RCeVVVSUQodXVpZDogc3RyaW5nKTogT2JzZXJ2YWJsZTxhbnkgfCB1bmRlZmluZWQ+IHtcbiAgICByZXR1cm4gdGhpcy5sb2FkQWxsUGlja2xpc3RzKCkucGlwZShtYXAoKHBpY2tsaXN0czogUGlja2xpc3ROYW1lW10pID0+IHtcbiAgICAgIGxldCByZXN1bHQgPSBfLmZpbmQocGlja2xpc3RzLCAocGlja2xpc3Q6IFBpY2tsaXN0KSA9PiB7XG4gICAgICAgIHJldHVybiBwaWNrbGlzdC51dWlkID09PSB1dWlkO1xuICAgICAgfSk7XG4gICAgICByZXR1cm4gcmVzdWx0O1xuICAgIH0pKTtcbiAgfVxuXG4gIHJlbW92ZUZyb21DYWNoZShwaWNrbGlzdDogYW55KSB7XG4gICAgaWYgKGlzT2JqZWN0KHBpY2tsaXN0KSkge1xuICAgICAgLy8gdGhpcy5zdG9yYWdlLnJlbW92ZSgncGlja2xpc3RzLicrcGlja2xpc3QubmFtZSk7XG4gICAgICAvLyBsb2NhbFN0b3JhZ2VTZXJ2aWNlLnJlbW92ZSgncGlja2xpc3RzLicrJGZpbHRlcignZ2V0RW5kUGF0aE5hbWUnKShwaWNrbGlzdFsnQGlkJ10pKTtcbiAgICB9IGVsc2Uge1xuICAgICAgLy9sb2NhbFN0b3JhZ2VTZXJ2aWNlLnJlbW92ZSgncGlja2xpc3RzLicrcGlja2xpc3QpO1xuICAgIH1cbiAgfVxuXG4gIGxvYWRBbGxQaWNrbGlzdHModXNlRXhwb3J0OiBib29sZWFuID0gZmFsc2UpIHtcbiAgICAvLyBUT0RPOiBQaWNrbGlzdCBVUkwgbmVlZHMgdG8gY2hhbmdlXG4gICAgLy9jb25zdCB1cmwgPSBgJHtBUEkuQVBJXzNfQkFTRX1waWNrbGlzdF9uYW1lcz8kZXhwb3J0PSR7dXNlRXhwb3J0fSYkbGltaXQ9JHtBTExfUkVDT1JEU19TSVpFfSYkb3JkZXJieT1uYW1lJiRyZWxhdGlvbnNoaXBzPXRydWVgO1xuICAgIGNvbnN0IHVybCA9ICdhc3NldHMvZHVtbXlEYXRhL3BpY2tsaXN0cy5qc29uJztcbiAgICBpZiAodGhpcy5waWNrbGlzdHMpIHtcbiAgICAgIHJldHVybiBvZih0aGlzLnBpY2tsaXN0cyk7XG4gICAgfVxuICAgIHJldHVybiB0aGlzLmh0dHAuZ2V0KHVybCkucGlwZShtYXAoKHJlc3BvbnNlOiBhbnkpID0+IHtcbiAgICAgIHRoaXMucGlja2xpc3RzID0ge307XG4gICAgICBmb3JFYWNoKHJlc3BvbnNlWydoeWRyYTptZW1iZXInXSwgKHBpY2tsaXN0OiBQaWNrbGlzdCkgPT4ge1xuICAgICAgICB0aGlzLnBpY2tsaXN0cyFbcGlja2xpc3QubmFtZV0gPSBwaWNrbGlzdDtcbiAgICAgIH0pO1xuICAgICAgcmV0dXJuIHJlc3BvbnNlWydoeWRyYTptZW1iZXInXTtcbiAgICB9KVxuICAgICk7XG4gIH1cblxuICBsb2FkUGlja2xpc3RzKGZpZWxkOiBQaWNrbGlzdEZpZWxkLCBtZXRhZGF0YT86IGFueSkge1xuICAgIGxldCBwaWNrbGlzdHMkID0gbmV3IFN1YmplY3Q8YW55PigpO1xuICAgIGxldCBlbnRpdHkkOiBPYnNlcnZhYmxlPEVudGl0eT47XG4gICAgaWYgKCFtZXRhZGF0YSkge1xuICAgICAgZW50aXR5JCA9IHRoaXMuZW50aXR5U2VydmljZS5idWlsZCgncGlja2xpc3RzJykucGlwZShtYXAoKGVudGl0eSkgPT4ge1xuICAgICAgICBtZXRhZGF0YSA9IGVudGl0eTtcbiAgICAgICAgcmV0dXJuIG1ldGFkYXRhO1xuICAgICAgfSkpO1xuICAgIH0gZWxzZSB7XG4gICAgICBlbnRpdHkkID0gb2YobWV0YWRhdGEpO1xuICAgIH1cbiAgICBlbnRpdHkkLnN1YnNjcmliZSh7XG4gICAgICBuZXh0OiAoZW50aXR5OiBFbnRpdHkpID0+IHtcbiAgICAgICAgaWYgKGZpZWxkPy5kYXRhU291cmNlPy5xdWVyeT8uZmlsdGVycz8ubGVuZ3RoID4gMCAmJiBmaWVsZC5kYXRhU291cmNlPy5xdWVyeS5maWx0ZXJzWzBdPy52YWx1ZSkge1xuICAgICAgICAgIGNvbnN0IHBpY2tsaXN0cyA9IHRoaXMuc3RvcmFnZS5nZXRJdGVtKCdwaWNrbGlzdHMuJyArIGZpZWxkLmRhdGFTb3VyY2UucXVlcnkuZmlsdGVyc1swXS52YWx1ZSk7XG4gICAgICAgICAgaWYgKHBpY2tsaXN0cyAmJiBwaWNrbGlzdHMubGVuZ3RoID4gMCkge1xuICAgICAgICAgICAgZmllbGQub3B0aW9ucyA9IHBpY2tsaXN0cztcbiAgICAgICAgICAgIHRoaXMuZW50aXR5U2VydmljZS5zZXREaXNwbGF5TmFtZShmaWVsZCwgZW50aXR5KTtcbiAgICAgICAgICAgIHBpY2tsaXN0cyQubmV4dChmaWVsZCk7XG4gICAgICAgICAgICBwaWNrbGlzdHMkLmNvbXBsZXRlKCk7XG4gICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIHRoaXMubG9hZFBpY2tsaXN0c0J5UGFyYW1zKGZpZWxkLmRhdGFTb3VyY2UucXVlcnkuZmlsdGVyc1swXS52YWx1ZSwgJ25hbWUnKS5zdWJzY3JpYmUoe1xuICAgICAgICAgICAgICBuZXh0OiAocmVzdWx0OiBhbnkpID0+IHtcbiAgICAgICAgICAgICAgICBpZiAocmVzdWx0ICYmIHJlc3VsdC5sZW5ndGggPiAwKSB7XG4gICAgICAgICAgICAgICAgICBmaWVsZC5vcHRpb25zID0gcmVzdWx0O1xuICAgICAgICAgICAgICAgICAgdGhpcy5lbnRpdHlTZXJ2aWNlLnNldERpc3BsYXlOYW1lKGZpZWxkLCBlbnRpdHkpO1xuICAgICAgICAgICAgICAgICAgdGhpcy5zdG9yYWdlLnNldEl0ZW0oJ3BpY2tsaXN0cy4nICsgZmllbGQuZGF0YVNvdXJjZS5xdWVyeS5maWx0ZXJzWzBdLnZhbHVlLCBmaWVsZC5vcHRpb25zKTtcbiAgICAgICAgICAgICAgICAgIHBpY2tsaXN0cyQubmV4dChmaWVsZCk7XG4gICAgICAgICAgICAgICAgICBwaWNrbGlzdHMkLmNvbXBsZXRlKCk7XG4gICAgICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAgIHBpY2tsaXN0cyQubmV4dCh7fSk7XG4gICAgICAgICAgICAgICAgICBwaWNrbGlzdHMkLmNvbXBsZXRlKCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICB9LCBlcnJvcjogKGVycm9yKSA9PiB7XG4gICAgICAgICAgICAgICAgcGlja2xpc3RzJC5lcnJvcihlcnJvcik7XG4gICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICAgIH1cbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBwaWNrbGlzdHMkLmVycm9yKGZhbHNlKTtcbiAgICAgICAgfVxuICAgICAgfSwgZXJyb3I6IChlcnJvcikgPT4ge1xuICAgICAgICBwaWNrbGlzdHMkLmVycm9yKGVycm9yKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgICByZXR1cm4gcGlja2xpc3RzJC5hc09ic2VydmFibGUoKTtcbiAgfVxuXG4gIGxvYWRQaWNrbGlzdHNCeVBhcmFtcyhpdGVtVmFsOiBzdHJpbmcsIGl0ZW1LZXk6IHN0cmluZyk6IE9ic2VydmFibGU8YW55PiB7XG4gICAgbGV0IHBpY2tsaXN0cyA9IHRoaXMuc3RvcmFnZS5nZXRJdGVtKGBwaWNrbGlzdHMuJHtpdGVtVmFsfWApO1xuICAgIGlmIChwaWNrbGlzdHMgJiYgcGlja2xpc3RzLmxlbmd0aCA+IDApIHtcbiAgICAgIHJldHVybiBvZihwaWNrbGlzdHMpO1xuICAgIH0gZWxzZSB7XG4gICAgICBsZXQgcXVlcnk6IGFueSA9IHtcbiAgICAgICAgbGltaXQ6IEFMTF9SRUNPUkRTX1NJWkUsXG4gICAgICAgICRvcmRlcmJ5OiAnb3JkZXJJbmRleCdcbiAgICAgIH07XG4gICAgICBxdWVyeVsnbGlzdE5hbWVfXycgKyBpdGVtS2V5XSA9IGl0ZW1WYWw7XG4gICAgICByZXR1cm4gdGhpcy5odHRwLmdldChgJHtBUEkuQkFTRX1waWNrbGlzdHNgLCB7IHBhcmFtczogcXVlcnkgfSkucGlwZShtYXAoKHJlc3VsdDogYW55KSA9PiB7XG4gICAgICAgIGlmIChyZXN1bHQgJiYgcmVzdWx0WydoeWRyYTptZW1iZXInXSkge1xuICAgICAgICAgIHRoaXMuc3RvcmFnZS5zZXRJdGVtKCdwaWNrbGlzdHMuJyArIGl0ZW1WYWwsIHBpY2tsaXN0cyk7XG4gICAgICAgICAgcmV0dXJuIHJlc3VsdFsnaHlkcmE6bWVtYmVyJ107XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgcmV0dXJuIHRocm93RXJyb3IoKCkgPT4gbmV3IEVycm9yKCdOb3QgYSB2YWxpZCBwaWNrbGlzdCBxdWVyeScpKTtcbiAgICAgICAgfVxuICAgICAgfSksIGNhdGNoRXJyb3IoZXJyb3IgPT4ge1xuICAgICAgICByZXR1cm4gdGhyb3dFcnJvcigoKSA9PiBlcnJvcik7XG4gICAgICB9KSk7XG4gICAgfVxuICB9XG59XG4iXX0=