import { Field } from "../../core/models/field";
import { InputFieldComponent } from '../field-renderers/built-ins/input/input-field.component';
import { InputViewComponent } from '../field-renderers/built-ins/input/input-view.component';
export class EmailField extends Field {
    constructor(name) {
        super(name, Field.BuiltInType.EMAIL);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    getFieldLength() {
        return {
            minlength: 0,
            maxlength: 255
        };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW1haWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9mb3JtLWZpZWxkcy9maWVsZC10eXBlcy9lbWFpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0seUJBQXlCLENBQUM7QUFDaEQsT0FBTyxFQUFFLG1CQUFtQixFQUFFLE1BQU0sMERBQTBELENBQUM7QUFDL0YsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0seURBQXlELENBQUM7QUFDN0YsTUFBTSxPQUFPLFVBQVcsU0FBUSxLQUFLO0lBRW5DLFlBQVksSUFBWTtRQUN0QixLQUFLLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDckMsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUM7UUFDeEIsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7UUFDNUIsSUFBSSxDQUFDLGNBQWMsR0FBRyxtQkFBbUIsQ0FBQztRQUMxQyxJQUFJLENBQUMsYUFBYSxHQUFHLGtCQUFrQixDQUFDO0lBQzFDLENBQUM7SUFFRCxjQUFjO1FBQ1osT0FBTztZQUNMLFNBQVMsRUFBRSxDQUFDO1lBQ1osU0FBUyxFQUFFLEdBQUc7U0FDZixDQUFDO0lBQ0osQ0FBQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRmllbGQgfSBmcm9tIFwiLi4vLi4vY29yZS9tb2RlbHMvZmllbGRcIjtcbmltcG9ydCB7IElucHV0RmllbGRDb21wb25lbnQgfSBmcm9tICcuLi9maWVsZC1yZW5kZXJlcnMvYnVpbHQtaW5zL2lucHV0L2lucHV0LWZpZWxkLmNvbXBvbmVudCc7XG5pbXBvcnQgeyBJbnB1dFZpZXdDb21wb25lbnQgfSBmcm9tICcuLi9maWVsZC1yZW5kZXJlcnMvYnVpbHQtaW5zL2lucHV0L2lucHV0LXZpZXcuY29tcG9uZW50JztcbmV4cG9ydCBjbGFzcyBFbWFpbEZpZWxkIGV4dGVuZHMgRmllbGQge1xuXG4gIGNvbnN0cnVjdG9yKG5hbWU6IHN0cmluZykge1xuICAgIHN1cGVyKG5hbWUsIEZpZWxkLkJ1aWx0SW5UeXBlLkVNQUlMKTtcbiAgICB0aGlzLmlzRm9ybUZpZWxkID0gdHJ1ZTtcbiAgICB0aGlzLmlzUmVsYXRpb25zaGlwID0gZmFsc2U7XG4gICAgdGhpcy5maWVsZENvbXBvbmVudCA9IElucHV0RmllbGRDb21wb25lbnQ7XG4gICAgdGhpcy52aWV3Q29tcG9uZW50ID0gSW5wdXRWaWV3Q29tcG9uZW50O1xuICB9XG5cbiAgZ2V0RmllbGRMZW5ndGgoKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIG1pbmxlbmd0aDogMCxcbiAgICAgIG1heGxlbmd0aDogMjU1XG4gICAgfTtcbiAgfVxufVxuIl19