import { ALL_RECORDS_SIZE, MIN_NUMBER_LIMIT } from "../../core/constants";
import { Field } from "../../core/models/field";
import { InputFieldComponent } from "../field-renderers/built-ins/input/input-field.component";
import { InputViewComponent } from "../field-renderers/built-ins/input/input-view.component";
export class IntegerField extends Field {
    static { this.operators = [...Field.equalOperators, ...Field.greaterThanLessThanOperators, ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.INTEGER);
        this.isFormField = true;
        this.isRelationship = false;
        this.validation.pattern = /^[0-9]+$/;
        this.fieldComponent = InputFieldComponent;
        this.viewComponent = InputViewComponent;
    }
    getFieldLength() {
        return {
            minlength: MIN_NUMBER_LIMIT,
            maxlength: ALL_RECORDS_SIZE
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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