import { LookupFieldComponent } from "../field-renderers/built-ins/lookup/lookup-field.component";
import { LookupViewComponent } from "../field-renderers/built-ins/lookup/lookup-view.component";
import { Field } from "../../core/models/field";
import { LookupFloatingFilterComponent } from "../field-renderers/built-ins/lookup/lookup-floating-filter/lookup-floating-filter.component";
import { LookupGridFilterComponent } from "../field-renderers/built-ins/lookup/lookup-grid-filter/lookup-grid-filter.component";
export class LookupField extends Field {
    static { this.operators = [...Field.equalOperators,
        ...Field.listOperators,
        ...Field.nullOperator]; }
    constructor(name) {
        super(name, Field.BuiltInType.LOOKUP);
        this.isFormField = true;
        this.isRelationship = false;
        this.fieldComponent = LookupFieldComponent;
        this.viewComponent = LookupViewComponent;
        this.gridFloatingFilterComponent = LookupFloatingFilterComponent;
        this.gridFilterComponent = LookupGridFilterComponent;
        this.alwaysEditMode = true;
    }
    set dataSource(value) {
        this._dataSource = value;
        this.model = value.model;
    }
    get dataSource() {
        return this._dataSource;
    }
}
//# sourceMappingURL=data:application/json;base64,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