import { isObject } from "lodash-es";
import { Field } from "../../core/models/field";
import { PicklistField } from "./picklist";
export class MultiselectPicklistField extends PicklistField {
    constructor(name) {
        super(name, Field.BuiltInType.MULTISELECT_PICKLIST);
    }
    getFlatValue(value) {
        let newValues = [];
        value.forEach((val) => {
            if (isObject(val)) {
                newValues.push(val['@id']);
            }
            else {
                newValues.push(val);
            }
        });
        return newValues;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibXVsdGlzZWxlY3QtcGlja2xpc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9mb3JtLWZpZWxkcy9maWVsZC10eXBlcy9tdWx0aXNlbGVjdC1waWNrbGlzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sV0FBVyxDQUFDO0FBQ3JDLE9BQU8sRUFBRSxLQUFLLEVBQUUsTUFBTSx5QkFBeUIsQ0FBQztBQUNoRCxPQUFPLEVBQUUsYUFBYSxFQUFFLE1BQU0sWUFBWSxDQUFDO0FBRTNDLE1BQU0sT0FBTyx3QkFBeUIsU0FBUSxhQUFhO0lBQ3pELFlBQVksSUFBWTtRQUN0QixLQUFLLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxXQUFXLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBRUQsWUFBWSxDQUFDLEtBQVU7UUFDckIsSUFBSSxTQUFTLEdBQVUsRUFBRSxDQUFDO1FBQzFCLEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQyxHQUFRLEVBQUUsRUFBRTtZQUN6QixJQUFJLFFBQVEsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDO2dCQUNsQixTQUFTLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUF5QixDQUFDLENBQUMsQ0FBQTtZQUNoRCxDQUFDO2lCQUFNLENBQUM7Z0JBQ04sU0FBUyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUN0QixDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUM7UUFDSCxPQUFPLFNBQVMsQ0FBQztJQUNuQixDQUFDO0NBRUYiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBpc09iamVjdCB9IGZyb20gXCJsb2Rhc2gtZXNcIjtcbmltcG9ydCB7IEZpZWxkIH0gZnJvbSBcIi4uLy4uL2NvcmUvbW9kZWxzL2ZpZWxkXCI7XG5pbXBvcnQgeyBQaWNrbGlzdEZpZWxkIH0gZnJvbSBcIi4vcGlja2xpc3RcIjtcblxuZXhwb3J0IGNsYXNzIE11bHRpc2VsZWN0UGlja2xpc3RGaWVsZCBleHRlbmRzIFBpY2tsaXN0RmllbGQge1xuICBjb25zdHJ1Y3RvcihuYW1lOiBzdHJpbmcpIHtcbiAgICBzdXBlcihuYW1lLCBGaWVsZC5CdWlsdEluVHlwZS5NVUxUSVNFTEVDVF9QSUNLTElTVCk7XG4gIH1cblxuICBnZXRGbGF0VmFsdWUodmFsdWU6IGFueSkge1xuICAgIGxldCBuZXdWYWx1ZXM6IGFueVtdID0gW107XG4gICAgdmFsdWUuZm9yRWFjaCgodmFsOiBhbnkpID0+IHtcbiAgICAgIGlmIChpc09iamVjdCh2YWwpKSB7XG4gICAgICAgIG5ld1ZhbHVlcy5wdXNoKHZhbFsnQGlkJyBhcyBrZXlvZiB0eXBlb2YgdmFsXSlcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIG5ld1ZhbHVlcy5wdXNoKHZhbCk7XG4gICAgICB9XG4gICAgfSk7XG4gICAgcmV0dXJuIG5ld1ZhbHVlcztcbiAgfVxuXG59XG4iXX0=