import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';
import { ReactiveFormsModule } from '@angular/forms';
import { NgJsonEditorModule } from 'ang-jsoneditor';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { SearchableDropdownModule } from '../components/searchable-dropdown/searchable-dropdown.module';
import { CheckboxFieldComponent } from './field-renderers/built-ins/checkbox/checkbox-field.component';
import { CheckboxViewComponent } from './field-renderers/built-ins/checkbox/checkbox-view.component';
import { DatetimeViewComponent } from './field-renderers/built-ins/datetime/datetime-view/datetime-view.component';
import { EditableFieldComponent } from './field-renderers/built-ins/editable-field/editable-field.component';
import { FormFieldComponent } from './field-renderers/built-ins/form-field/form-field.component';
import { FormViewComponent } from './field-renderers/built-ins/form-view/form-view.component';
import { InputFieldComponent } from './field-renderers/built-ins/input/input-field.component';
import { InputViewComponent } from './field-renderers/built-ins/input/input-view.component';
import { LookupFieldComponent } from './field-renderers/built-ins/lookup/lookup-field.component';
import { LookupViewComponent } from './field-renderers/built-ins/lookup/lookup-view.component';
import { MultiselectFieldComponent } from './field-renderers/built-ins/multiselect/multiselect-field.component';
import { PicklistFieldComponent } from './field-renderers/built-ins/picklist/picklist-field.component';
import { PicklistViewComponent } from './field-renderers/built-ins/picklist/picklist-view.component';
import { RichtextHTMLFieldComponent } from './field-renderers/built-ins/richtext-html/richtext-html-field.component';
import { RichtextHTMLViewComponent } from './field-renderers/built-ins/richtext-html/richtext-html-view.component';
import { TextareaFieldComponent } from './field-renderers/built-ins/textarea/textarea-field.component';
import { FormMessagesComponent } from './form-messages/form-messages.component';
import { NgbDatepickerModule, NgbDropdownModule, NgbTimepickerModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { FieldRendererComponent } from './field-renderer/field-renderer.component';
import { DatetimeFieldComponent } from './field-renderers/built-ins/datetime/datetime-field/datetime-field.component';
import { SelectFieldComponent } from './field-renderers/built-ins/select-field/select-field.component';
import { SelectViewComponent } from './field-renderers/built-ins/select-field/select-view.component';
import { RadioFieldComponent } from './field-renderers/built-ins/radio/radio-field.component';
import { MultiSelectCheckboxDropdownFieldComponent } from './field-renderers/built-ins/multi-select-checkbox-dropdown/multi-select-checkbox-dropdown-field.component';
import { MultiSelectCheckboxDropdownViewComponent } from './field-renderers/built-ins/multi-select-checkbox-dropdown/multi-select-checkbox-dropdown-view.component';
import { RadioViewComponent } from './field-renderers/built-ins/radio/radio-view.component';
import { ToggleFieldComponent } from './field-renderers/built-ins/toggle/toggle-field.component';
import { ToggleViewComponent } from './field-renderers/built-ins/toggle/toggle-view.component';
import { ToggleDropdownFieldComponent } from './field-renderers/built-ins/toggle-dropdown/toggle-dropdown-field.component';
import { JsonEditorFieldComponent } from './field-renderers/built-ins/json-editor-field/json-editor-field.component';
import { DatetimeFloatingFilterComponent } from './field-renderers/built-ins/datetime/datetime-floating-filter/datetime-floating-filter.component';
import { SlideToggleComponent } from '../components/slide-toggle/slide-toggle.component';
import { LookupFloatingFilterComponent } from './field-renderers/built-ins/lookup/lookup-floating-filter/lookup-floating-filter.component';
import { LookupGridFilterComponent } from './field-renderers/built-ins/lookup/lookup-grid-filter/lookup-grid-filter.component';
import { HtmlEditorModule } from './field-renderers/built-ins/richtext-html/html-editor-module/html-editor.module';
import { TagsFieldComponent } from './field-renderers/built-ins/tags/tags-field.component';
import { TagsViewComponent } from './field-renderers/built-ins/tags/tags-view.component';
import { TagsInputComponent } from '../components/tags-input/tags-input.component';
import { CheckboxGridFilterComponent } from './field-renderers/built-ins/checkbox/checkbox-grid-filter/checkbox-grid-filter.component';
import { CheckboxFloatingFilterComponent } from './field-renderers/built-ins/checkbox/checkbox-floating-filter/checkbox-floating-filter.component';
import { TranslocoModule } from '@jsverse/transloco';
import { RichtextMarkdownFieldComponent } from './field-renderers/built-ins/richtext-markdown/richtext-markdown-field.component';
import { UtilityModule } from '../utility/utility.module';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/forms";
import * as i3 from "@ng-bootstrap/ng-bootstrap";
import * as i4 from "../components/tags-input/tags-input.component";
export class XFFormFieldsModule {
    static { this.ɵfac = function XFFormFieldsModule_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || XFFormFieldsModule)(); }; }
    static { this.ɵmod = /*@__PURE__*/ i0.ɵɵdefineNgModule({ type: XFFormFieldsModule }); }
    static { this.ɵinj = /*@__PURE__*/ i0.ɵɵdefineInjector({ imports: [CommonModule,
            UtilityModule,
            ReactiveFormsModule,
            SearchableDropdownModule,
            NgMultiSelectDropDownModule,
            NgbTooltipModule,
            NgbDatepickerModule,
            NgbTimepickerModule,
            NgbDropdownModule,
            NgJsonEditorModule,
            SlideToggleComponent,
            HtmlEditorModule,
            TagsInputComponent,
            TranslocoModule] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(XFFormFieldsModule, [{
        type: NgModule,
        args: [{
                declarations: [
                    CheckboxFieldComponent,
                    CheckboxViewComponent,
                    CheckboxGridFilterComponent,
                    CheckboxFloatingFilterComponent,
                    FormFieldComponent,
                    InputFieldComponent,
                    InputViewComponent,
                    FormMessagesComponent,
                    FormViewComponent,
                    LookupFieldComponent,
                    LookupViewComponent,
                    LookupFloatingFilterComponent,
                    LookupGridFilterComponent,
                    PicklistFieldComponent,
                    PicklistViewComponent,
                    TextareaFieldComponent,
                    RichtextHTMLFieldComponent,
                    RichtextHTMLViewComponent,
                    EditableFieldComponent,
                    MultiselectFieldComponent,
                    FieldRendererComponent,
                    SelectFieldComponent,
                    SelectViewComponent,
                    DatetimeFieldComponent,
                    DatetimeViewComponent,
                    DatetimeFloatingFilterComponent,
                    RadioFieldComponent,
                    RadioViewComponent,
                    TagsFieldComponent,
                    TagsViewComponent,
                    ToggleViewComponent,
                    ToggleFieldComponent,
                    MultiSelectCheckboxDropdownFieldComponent,
                    MultiSelectCheckboxDropdownViewComponent,
                    ToggleDropdownFieldComponent,
                    JsonEditorFieldComponent,
                    RichtextMarkdownFieldComponent
                ],
                imports: [
                    CommonModule,
                    UtilityModule,
                    ReactiveFormsModule,
                    SearchableDropdownModule,
                    NgMultiSelectDropDownModule,
                    NgbTooltipModule,
                    NgbDatepickerModule,
                    NgbTimepickerModule,
                    NgbDropdownModule,
                    NgJsonEditorModule,
                    SlideToggleComponent,
                    HtmlEditorModule,
                    TagsInputComponent,
                    TranslocoModule
                ],
                exports: [
                    PicklistFieldComponent,
                    LookupFieldComponent,
                    LookupFloatingFilterComponent,
                    LookupGridFilterComponent,
                    CheckboxFieldComponent,
                    CheckboxGridFilterComponent,
                    CheckboxFloatingFilterComponent,
                    InputFieldComponent,
                    FormFieldComponent,
                    FormViewComponent,
                    EditableFieldComponent,
                    FormMessagesComponent,
                    MultiselectFieldComponent,
                    SelectFieldComponent,
                    SelectViewComponent,
                    FieldRendererComponent,
                    DatetimeFieldComponent,
                    DatetimeViewComponent,
                    DatetimeFloatingFilterComponent,
                    RadioFieldComponent,
                    RadioViewComponent,
                    JsonEditorFieldComponent
                ]
            }]
    }], null, null); })();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && i0.ɵɵsetNgModuleScope(XFFormFieldsModule, { declarations: [CheckboxFieldComponent,
        CheckboxViewComponent,
        CheckboxGridFilterComponent,
        CheckboxFloatingFilterComponent,
        FormFieldComponent,
        InputFieldComponent,
        InputViewComponent,
        FormMessagesComponent,
        FormViewComponent,
        LookupFieldComponent,
        LookupViewComponent,
        LookupFloatingFilterComponent,
        LookupGridFilterComponent,
        PicklistFieldComponent,
        PicklistViewComponent,
        TextareaFieldComponent,
        RichtextHTMLFieldComponent,
        RichtextHTMLViewComponent,
        EditableFieldComponent,
        MultiselectFieldComponent,
        FieldRendererComponent,
        SelectFieldComponent,
        SelectViewComponent,
        DatetimeFieldComponent,
        DatetimeViewComponent,
        DatetimeFloatingFilterComponent,
        RadioFieldComponent,
        RadioViewComponent,
        TagsFieldComponent,
        TagsViewComponent,
        ToggleViewComponent,
        ToggleFieldComponent,
        MultiSelectCheckboxDropdownFieldComponent,
        MultiSelectCheckboxDropdownViewComponent,
        ToggleDropdownFieldComponent,
        JsonEditorFieldComponent,
        RichtextMarkdownFieldComponent], imports: [CommonModule,
        UtilityModule,
        ReactiveFormsModule,
        SearchableDropdownModule,
        NgMultiSelectDropDownModule,
        NgbTooltipModule,
        NgbDatepickerModule,
        NgbTimepickerModule,
        NgbDropdownModule,
        NgJsonEditorModule,
        SlideToggleComponent,
        HtmlEditorModule,
        TagsInputComponent,
        TranslocoModule], exports: [PicklistFieldComponent,
        LookupFieldComponent,
        LookupFloatingFilterComponent,
        LookupGridFilterComponent,
        CheckboxFieldComponent,
        CheckboxGridFilterComponent,
        CheckboxFloatingFilterComponent,
        InputFieldComponent,
        FormFieldComponent,
        FormViewComponent,
        EditableFieldComponent,
        FormMessagesComponent,
        MultiselectFieldComponent,
        SelectFieldComponent,
        SelectViewComponent,
        FieldRendererComponent,
        DatetimeFieldComponent,
        DatetimeViewComponent,
        DatetimeFloatingFilterComponent,
        RadioFieldComponent,
        RadioViewComponent,
        JsonEditorFieldComponent] }); })();
i0.ɵɵsetComponentScope(LookupFloatingFilterComponent, [i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FormFieldComponent], []);
i0.ɵɵsetComponentScope(TagsFieldComponent, [i1.NgClass, i1.NgIf, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, i3.NgbTooltip, i4.TagsInputComponent, FormMessagesComponent], []);
//# sourceMappingURL=data:application/json;base64,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