import { Component, forwardRef, Input, ViewChild } from '@angular/core';
import { NG_VALIDATORS, NG_VALUE_ACCESSOR, Validators } from '@angular/forms';
import { of } from 'rxjs';
import { map } from 'rxjs/operators';
import { Filter } from '../models/filter';
import { FieldOptions } from '../../form-fields/models/field-options';
import { SearchableDropdownComponent } from '../../components/searchable-dropdown/searchable-dropdown.component';
import { InputFieldComponent } from '../../form-fields/field-renderers/built-ins/input/input-field.component';
import { ViewContainerDirective } from '../../utility/directives/view-container.directive';
import { cloneDeep, isString } from 'lodash-es';
import * as i0 from "@angular/core";
import * as i1 from "../../core/services/entity.service";
import * as i2 from "@angular/forms";
import * as i3 from "@angular/common";
import * as i4 from "../../utility/directives/view-container.directive";
import * as i5 from "../../components/searchable-dropdown/searchable-dropdown.component";
const _c0 = ["formField"];
const _c1 = ["filterField"];
function FilterComponent_Conditional_6_option_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "option", 12);
    i0.ɵɵtext(1);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const operator_r2 = ctx.$implicit;
    i0.ɵɵproperty("ngValue", operator_r2.id);
    i0.ɵɵadvance();
    i0.ɵɵtextInterpolate(operator_r2.title);
} }
function FilterComponent_Conditional_6_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "select", 6);
    i0.ɵɵtemplate(1, FilterComponent_Conditional_6_option_1_Template, 2, 2, "option", 11);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("ngForOf", ctx_r2.field.operators);
} }
function FilterComponent_Conditional_8_ng_template_0_Template(rf, ctx) { }
function FilterComponent_Conditional_8_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵtemplate(0, FilterComponent_Conditional_8_ng_template_0_Template, 0, 0, "ng-template", 7);
} }
function FilterComponent_Conditional_10_Template(rf, ctx) { if (rf & 1) {
    const _r4 = i0.ɵɵgetCurrentView();
    i0.ɵɵelementStart(0, "button", 13);
    i0.ɵɵlistener("click", function FilterComponent_Conditional_10_Template_button_click_0_listener() { i0.ɵɵrestoreView(_r4); const ctx_r2 = i0.ɵɵnextContext(); return i0.ɵɵresetView(ctx_r2.deleteFilter()); });
    i0.ɵɵelement(1, "i", 14);
    i0.ɵɵelementEnd();
} }
function FilterComponent_Conditional_11_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 10);
    i0.ɵɵelement(1, "xf-filter", 15);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r2 = i0.ɵɵnextContext();
    i0.ɵɵadvance();
    i0.ɵɵproperty("entity", ctx_r2.subEntity)("isChild", true);
} }
export class FilterComponent {
    constructor(changeDetectorRef, entityService, formBuilder) {
        this.changeDetectorRef = changeDetectorRef;
        this.entityService = entityService;
        this.formBuilder = formBuilder;
        this.isChild = false;
        this.items = [];
        this.field = null;
        this.fieldRenderer = null;
        this.onChange = (_) => { };
        this.onTouched = () => { };
        this.value = new Filter();
        this.fieldOptions = new FieldOptions({
            showLabel: false
        });
        this.formGroup = this.formBuilder.group({
            filterField: [null, Validators.required],
            operator: [null, Validators.required],
            value: [null],
            subDataFilter: [null]
        });
    }
    writeValue(value) {
        this.value = value || new Filter();
        let field = this.value.field;
        let subFilter = null;
        if (this.value.field && this.value.field?.indexOf('.') > -1) {
            const parts = this.value.field.split('.');
            field = parts[0];
            parts.shift();
            subFilter = cloneDeep(value);
            subFilter.field = parts.join('.');
            this.formGroup.controls.operator.clearValidators();
        }
        else {
            this.formGroup.controls.operator.setValidators(Validators.required);
        }
        this.fieldValue = field && this.entity.fields[field] ? this.entity.fields[field].asSearchableItem() : null;
        if (this.fieldValue) {
            this.setField(this.fieldValue.value);
        }
        this.formGroup.setValue({
            filterField: this.fieldValue,
            operator: this.value.operator,
            value: this.value.originalValue || this.value.value,
            subDataFilter: subFilter
        }, {
            emitEvent: false
        });
        this.changeDetectorRef.detectChanges();
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnInit() {
        this.formGroup.controls.operator.valueChanges.subscribe((value) => this.operatorChanged(value));
        this.formGroup.controls.value.valueChanges.subscribe((value) => this.valueChanged(value));
        this.formGroup.controls.filterField.valueChanges.subscribe((value) => {
            this.fieldValue = value;
            this.fieldChanged();
        });
        this.formGroup.controls.subDataFilter.valueChanges.subscribe((value) => {
            if (!value) {
                this.onChange(null);
                return;
            }
            let fullValue = cloneDeep(value);
            fullValue.field = this.field?.name + '.' + value.field;
            this.value = fullValue;
            this.onChange(fullValue);
        });
        this.filterFields('');
    }
    filterFields(search) {
        of(this.entity.attributes).pipe(map((fields) => {
            return fields.map((field) => field.asSearchableItem());
        }), map((items) => {
            return items.filter((item) => {
                return isString(item.display) && item.display.toLowerCase().indexOf(search.toLowerCase()) > -1;
            });
        })).subscribe((items) => {
            this.items = items;
            this.changeDetectorRef.detectChanges();
        });
    }
    setField(field) {
        if (field && this.entity.fields[field.name].formType !== field.formType) {
            // Reset view
            this.field = null;
            this.fieldRenderer = null;
            this.changeDetectorRef.detectChanges();
        }
        this.field = field;
        if (field.data) {
            this.subEntity = this.entityService.createEntityFromData(field.data, 'sub-field-' + field.name);
            this.changeDetectorRef.detectChanges();
            return;
        }
        else {
            this.subEntity = undefined;
            this.changeDetectorRef.detectChanges();
        }
        if (this.value.operator) {
            const operator = this.field?.getOperator(this.value.operator);
            this.setRenderer(operator);
        }
        else {
            const defaultOperator = field.operators[0];
            this.setRenderer(defaultOperator);
            this.formGroup.controls.operator.setValue(defaultOperator.id);
        }
        this.changeDetectorRef.detectChanges();
    }
    fieldChanged() {
        if (!this.fieldValue) {
            return;
        }
        this.value.operator = null;
        this.value.field = this.fieldValue.value.name;
        this.setField(this.fieldValue.value);
        this.onChange(this.value);
    }
    operatorChanged(newOperatorId) {
        const operator = this.field?.getOperator(newOperatorId);
        this.value.operator = operator?.id || null;
        this.setRenderer(operator);
        this.onChange(this.value);
    }
    setRenderer(operator) {
        if (operator?.renderer) {
            this.fieldRenderer = operator.renderer;
        }
        else {
            this.fieldRenderer = InputFieldComponent;
        }
        const viewContainerRef = this.xfViewContainer.viewContainerRef;
        viewContainerRef.clear();
        if (!this.field) {
            return;
        }
        let field = cloneDeep(this.field);
        field.name = field.name + '-renderer';
        this.componentRef = viewContainerRef.createComponent(this.fieldRenderer);
        this.componentRef.instance.field = field;
        this.componentRef.instance.fieldClass = 'form-control-sm';
        this.componentRef.instance.fieldOptions = this.fieldOptions;
        this.componentRef.instance.writeValue(this.value.value);
        this.componentRef.instance.onChange = (value) => this.valueChanged(value);
        if (!this.value.value && this.field.defaultValue) {
            this.componentRef.instance.value = this.field.defaultValue;
        }
        this.componentRef.instance.changeDetectorRef.detectChanges();
    }
    valueChanged(value) {
        this.value.originalValue = value;
        this.value.value = this.field?.getFlatValue(value, this.field?.operators.find((operator) => this.value.operator === operator.id));
        this.onChange(this.value);
    }
    deleteFilter() {
        this.onChange(null);
    }
    validate(control) {
        return !this.value?.operator || !this.value?.field ? {
            required: true
        } : null;
    }
    focusOnFirstInvalidInput() {
        this.formGroup.markAllAsTouched();
        if (this.filterField.invalid) {
            this.filterField.setTouched();
            this.filterField.focus();
            return true;
        }
        return false;
    }
    static { this.ɵfac = function FilterComponent_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || FilterComponent)(i0.ɵɵdirectiveInject(i0.ChangeDetectorRef), i0.ɵɵdirectiveInject(i1.EntityService), i0.ɵɵdirectiveInject(i2.FormBuilder)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: FilterComponent, selectors: [["xf-filter"]], viewQuery: function FilterComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 5);
            i0.ɵɵviewQuery(_c1, 5);
            i0.ɵɵviewQuery(SearchableDropdownComponent, 5);
            i0.ɵɵviewQuery(ViewContainerDirective, 5);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.formField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.filterField = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.fieldSelect = _t.first);
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.xfViewContainer = _t.first);
        } }, inputs: { entity: "entity", isChild: "isChild" }, features: [i0.ɵɵProvidersFeature([{
                    provide: NG_VALUE_ACCESSOR,
                    useExisting: forwardRef(() => FilterComponent),
                    multi: true
                }, {
                    provide: NG_VALIDATORS,
                    useExisting: forwardRef(() => FilterComponent),
                    multi: true
                }])], decls: 12, vars: 6, consts: [["filterField", ""], [3, "formGroup"], [1, "d-flex", "align-items-center"], [1, "col", "pe-1"], ["buttonStyle", "select", "formControlName", "filterField", "placeholder", "Select Field", 3, "searchQueryChange", "items"], [1, "col", "px-1"], ["formControlName", "operator", 1, "form-select", "form-select-sm"], ["xfViewContainer", ""], [1, "col", "col-delete", "ps-1"], ["type", "button", 1, "btn", "btn-sm", "btn-outline"], [1, "mt-2"], [3, "ngValue", 4, "ngFor", "ngForOf"], [3, "ngValue"], ["type", "button", 1, "btn", "btn-sm", "btn-outline", 3, "click"], [1, "fa", "fa-close", "text-danger"], ["formControlName", "subDataFilter", 3, "entity", "isChild"]], template: function FilterComponent_Template(rf, ctx) { if (rf & 1) {
            const _r1 = i0.ɵɵgetCurrentView();
            i0.ɵɵelementStart(0, "div", 1)(1, "div", 2)(2, "div", 3)(3, "xf-searchable-dropdown", 4, 0);
            i0.ɵɵlistener("searchQueryChange", function FilterComponent_Template_xf_searchable_dropdown_searchQueryChange_3_listener($event) { i0.ɵɵrestoreView(_r1); return i0.ɵɵresetView(ctx.filterFields($event)); });
            i0.ɵɵelementEnd()();
            i0.ɵɵelementStart(5, "div", 5);
            i0.ɵɵtemplate(6, FilterComponent_Conditional_6_Template, 2, 1, "select", 6);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(7, "div", 5);
            i0.ɵɵtemplate(8, FilterComponent_Conditional_8_Template, 1, 0, null, 7);
            i0.ɵɵelementEnd();
            i0.ɵɵelementStart(9, "div", 8);
            i0.ɵɵtemplate(10, FilterComponent_Conditional_10_Template, 2, 0, "button", 9);
            i0.ɵɵelementEnd()();
            i0.ɵɵtemplate(11, FilterComponent_Conditional_11_Template, 2, 2, "div", 10);
            i0.ɵɵelementEnd();
        } if (rf & 2) {
            i0.ɵɵproperty("formGroup", ctx.formGroup);
            i0.ɵɵadvance(3);
            i0.ɵɵproperty("items", ctx.items);
            i0.ɵɵadvance(3);
            i0.ɵɵconditional(ctx.field && !ctx.subEntity ? 6 : -1);
            i0.ɵɵadvance(2);
            i0.ɵɵconditional(!ctx.subEntity ? 8 : -1);
            i0.ɵɵadvance(2);
            i0.ɵɵconditional(!ctx.isChild ? 10 : -1);
            i0.ɵɵadvance();
            i0.ɵɵconditional(ctx.field && ctx.subEntity ? 11 : -1);
        } }, dependencies: [i3.NgForOf, i4.ViewContainerDirective, i5.SearchableDropdownComponent, i2.NgSelectOption, i2.ɵNgSelectMultipleOption, i2.SelectControlValueAccessor, i2.NgControlStatus, i2.NgControlStatusGroup, i2.FormGroupDirective, i2.FormControlName, FilterComponent], styles: [".col-delete[_ngcontent-%COMP%]{flex:0 0 0}"] }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FilterComponent, [{
        type: Component,
        args: [{ selector: 'xf-filter', providers: [{
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => FilterComponent),
                        multi: true
                    }, {
                        provide: NG_VALIDATORS,
                        useExisting: forwardRef(() => FilterComponent),
                        multi: true
                    }], template: "<div [formGroup]=\"formGroup\">\n  <div class=\"d-flex align-items-center\">\n    <div class=\"col pe-1\">\n      <xf-searchable-dropdown #filterField buttonStyle=\"select\" formControlName=\"filterField\" [items]=\"items\"\n      placeholder=\"Select Field\" (searchQueryChange)=\"filterFields($event)\"></xf-searchable-dropdown>\n    </div>\n    <div class=\"col px-1\">\n      @if (field && !subEntity) {\n        <select class=\"form-select form-select-sm\" formControlName=\"operator\">\n          <option *ngFor=\"let operator of field.operators\" [ngValue]=\"operator.id\">{{ operator.title }}</option>\n        </select>\n      }\n    </div>\n    <div class=\"col px-1\">\n      @if (!subEntity) {\n        <!-- <xf-form-field *ngIf=\"fieldRenderer\" formControlName=\"value\" [field]=\"fieldRenderer\" [fieldOptions]=\"fieldOptions\" [fieldClass]=\"'form-control-sm'\" #formField></xf-form-field> -->\n        <ng-template xfViewContainer></ng-template>\n      }\n    </div>\n    <div class=\"col col-delete ps-1\">\n      @if (!isChild) {\n        <button type=\"button\" class=\"btn btn-sm btn-outline\" (click)=\"deleteFilter()\">\n          <i class=\"fa fa-close text-danger\"></i>\n        </button>\n      }\n    </div>\n  </div>\n  @if (field && subEntity) {\n    <div class=\"mt-2\">\n      <xf-filter [entity]=\"subEntity\" formControlName=\"subDataFilter\" [isChild]=\"true\"></xf-filter>\n    </div>\n  }\n\n</div>\n", styles: [".col-delete{flex:0 0 0}\n"] }]
    }], () => [{ type: i0.ChangeDetectorRef }, { type: i1.EntityService }, { type: i2.FormBuilder }], { entity: [{
            type: Input
        }], isChild: [{
            type: Input
        }], formField: [{
            type: ViewChild,
            args: ['formField', { static: false }]
        }], filterField: [{
            type: ViewChild,
            args: ['filterField', { static: false }]
        }], fieldSelect: [{
            type: ViewChild,
            args: [SearchableDropdownComponent]
        }], xfViewContainer: [{
            type: ViewChild,
            args: [ViewContainerDirective, { static: false }]
        }] }); })();
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassDebugInfo(FilterComponent, { className: "FilterComponent", filePath: "lib/query-filters/filter/filter.component.ts", lineNumber: 33 }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsdGVyLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3NoYXJlZC9zcmMvbGliL3F1ZXJ5LWZpbHRlcnMvZmlsdGVyL2ZpbHRlci5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi9xdWVyeS1maWx0ZXJzL2ZpbHRlci9maWx0ZXIuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFxQixTQUFTLEVBQThCLFVBQVUsRUFBRSxLQUFLLEVBQWtCLFNBQVMsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUN2SSxPQUFPLEVBQThFLGFBQWEsRUFBRSxpQkFBaUIsRUFBK0IsVUFBVSxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDdkwsT0FBTyxFQUFFLEVBQUUsRUFBRSxNQUFNLE1BQU0sQ0FBQztBQUMxQixPQUFPLEVBQWdCLEdBQUcsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBR25ELE9BQU8sRUFBRSxNQUFNLEVBQUUsTUFBTSxrQkFBa0IsQ0FBQztBQUcxQyxPQUFPLEVBQUUsWUFBWSxFQUFFLE1BQU0sd0NBQXdDLENBQUM7QUFDdEUsT0FBTyxFQUFFLDJCQUEyQixFQUFFLE1BQU0sb0VBQW9FLENBQUM7QUFHakgsT0FBTyxFQUFFLG1CQUFtQixFQUFFLE1BQU0seUVBQXlFLENBQUM7QUFDOUcsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sbURBQW1ELENBQUM7QUFDM0YsT0FBTyxFQUFFLFNBQVMsRUFBRSxRQUFRLEVBQUUsTUFBTSxXQUFXLENBQUM7Ozs7Ozs7Ozs7SUNOdEMsa0NBQXlFO0lBQUEsWUFBb0I7SUFBQSxpQkFBUzs7O0lBQXJELHdDQUF1QjtJQUFDLGNBQW9CO0lBQXBCLHVDQUFvQjs7O0lBRC9GLGlDQUFzRTtJQUNwRSxxRkFBeUU7SUFDM0UsaUJBQVM7OztJQURzQixjQUFrQjtJQUFsQixnREFBa0I7Ozs7SUFPakQsOEZBQTZCOzs7O0lBSzdCLGtDQUE4RTtJQUF6QixvTEFBUyxxQkFBYyxLQUFDO0lBQzNFLHdCQUF1QztJQUN6QyxpQkFBUzs7O0lBS2IsK0JBQWtCO0lBQ2hCLGdDQUE2RjtJQUMvRixpQkFBTTs7O0lBRE8sY0FBb0I7SUFBaUMsQUFBckQseUNBQW9CLGlCQUFpRDs7QURHdEYsTUFBTSxPQUFPLGVBQWU7SUFvQjFCLFlBQ1UsaUJBQW9DLEVBQ3BDLGFBQTRCLEVBQzVCLFdBQXdCO1FBRnhCLHNCQUFpQixHQUFqQixpQkFBaUIsQ0FBbUI7UUFDcEMsa0JBQWEsR0FBYixhQUFhLENBQWU7UUFDNUIsZ0JBQVcsR0FBWCxXQUFXLENBQWE7UUFwQnpCLFlBQU8sR0FBWSxLQUFLLENBQUM7UUFFbEMsVUFBSyxHQUFxQixFQUFFLENBQUM7UUFLN0IsVUFBSyxHQUFpQixJQUFJLENBQUM7UUFDM0Isa0JBQWEsR0FBZSxJQUFJLENBQUM7UUFNakMsYUFBUSxHQUFHLENBQUMsQ0FBTSxFQUFFLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDM0IsY0FBUyxHQUFHLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQztRQU9wQixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksTUFBTSxFQUFFLENBQUM7UUFDMUIsSUFBSSxDQUFDLFlBQVksR0FBRyxJQUFJLFlBQVksQ0FBQztZQUNuQyxTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsU0FBUyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDO1lBQ3RDLFdBQVcsRUFBRSxDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsUUFBUSxDQUFDO1lBQ3hDLFFBQVEsRUFBRSxDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsUUFBUSxDQUFDO1lBQ3JDLEtBQUssRUFBRSxDQUFDLElBQUksQ0FBQztZQUNiLGFBQWEsRUFBRSxDQUFDLElBQUksQ0FBQztTQUN0QixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0sVUFBVSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLElBQUksSUFBSSxNQUFNLEVBQUUsQ0FBQztRQUNuQyxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUM3QixJQUFJLFNBQVMsR0FBa0IsSUFBSSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLENBQUM7WUFDNUQsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQzFDLEtBQUssR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDakIsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1lBQ2QsU0FBUyxHQUFHLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUM3QixTQUFTLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDbEMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLGVBQWUsRUFBRSxDQUFDO1FBQ3JELENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDdEUsQ0FBQztRQUNELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7UUFDM0csSUFBSSxJQUFJLENBQUMsVUFBVSxFQUFFLENBQUM7WUFDcEIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3ZDLENBQUM7UUFDRCxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQztZQUN0QixXQUFXLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDNUIsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtZQUM3QixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLO1lBQ25ELGFBQWEsRUFBRSxTQUFTO1NBQ3pCLEVBQUU7WUFDRCxTQUFTLEVBQUUsS0FBSztTQUNqQixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDekMsQ0FBQztJQUVNLGdCQUFnQixDQUFDLEVBQTJCO1FBQ2pELElBQUksQ0FBQyxRQUFRLEdBQUcsRUFBRSxDQUFDO0lBQ3JCLENBQUM7SUFFTSxpQkFBaUIsQ0FBQyxFQUFjO1FBQ3JDLElBQUksQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFDO0lBQ3RCLENBQUM7SUFFRCxRQUFRO1FBQ04sSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQyxLQUFhLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUN4RyxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEtBQVUsRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDO1FBQy9GLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDLENBQUMsS0FBVSxFQUFFLEVBQUU7WUFDeEUsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7WUFDeEIsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1FBQ3RCLENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQyxLQUFVLEVBQUUsRUFBRTtZQUMxRSxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ1gsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDcEIsT0FBTztZQUNULENBQUM7WUFDRCxJQUFJLFNBQVMsR0FBRyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDakMsU0FBUyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksR0FBRyxHQUFHLEdBQUcsS0FBSyxDQUFDLEtBQUssQ0FBQztZQUN2RCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQzNCLENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUN4QixDQUFDO0lBRUQsWUFBWSxDQUFDLE1BQWM7UUFDekIsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLENBQUMsSUFBSSxDQUM3QixHQUFHLENBQUMsQ0FBQyxNQUFlLEVBQUUsRUFBRTtZQUN0QixPQUFPLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxLQUFZLEVBQUUsRUFBRSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDLENBQUM7UUFDaEUsQ0FBQyxDQUFDLEVBQ0YsR0FBRyxDQUFDLENBQUMsS0FBdUIsRUFBRSxFQUFFO1lBQzlCLE9BQU8sS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQW9CLEVBQUUsRUFBRTtnQkFDM0MsT0FBTyxRQUFRLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxXQUFXLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQ2pHLENBQUMsQ0FBQyxDQUFDO1FBQ0wsQ0FBQyxDQUFDLENBQ0gsQ0FBQyxTQUFTLENBQUMsQ0FBQyxLQUF1QixFQUFFLEVBQUU7WUFDdEMsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7WUFDbkIsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3pDLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELFFBQVEsQ0FBQyxLQUFZO1FBQ25CLElBQUksS0FBSyxJQUFJLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxRQUFRLEtBQUssS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO1lBQ3hFLGFBQWE7WUFDYixJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQztZQUNsQixJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQztZQUMxQixJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDekMsQ0FBQztRQUNELElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ2YsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLG9CQUFvQixDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsWUFBWSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNoRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7WUFDdkMsT0FBTztRQUNULENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLFNBQVMsR0FBRyxTQUFTLENBQUM7WUFDM0IsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO1FBQ3pDLENBQUM7UUFDRCxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDeEIsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLEtBQUssRUFBRSxXQUFXLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUM5RCxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQzdCLENBQUM7YUFBTSxDQUFDO1lBQ04sTUFBTSxlQUFlLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUMzQyxJQUFJLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1lBQ2xDLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsZUFBZSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBQ2hFLENBQUM7UUFDRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDekMsQ0FBQztJQUVELFlBQVk7UUFDVixJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDO1lBQ3JCLE9BQU87UUFDVCxDQUFDO1FBQ0QsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDO1FBQzNCLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQztRQUM5QyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDckMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQUVELGVBQWUsQ0FBQyxhQUFxQjtRQUNuQyxNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsS0FBSyxFQUFFLFdBQVcsQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUN4RCxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsR0FBRyxRQUFRLEVBQUUsRUFBRSxJQUFJLElBQUksQ0FBQztRQUMzQyxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQzNCLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzVCLENBQUM7SUFFTyxXQUFXLENBQUMsUUFBbUI7UUFDckMsSUFBRyxRQUFRLEVBQUUsUUFBUSxFQUFFLENBQUM7WUFDdEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxRQUFRLENBQUMsUUFBUSxDQUFDO1FBQ3pDLENBQUM7YUFBTSxDQUFDO1lBQ04sSUFBSSxDQUFDLGFBQWEsR0FBRyxtQkFBbUIsQ0FBQztRQUMzQyxDQUFDO1FBQ0QsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLGdCQUFnQixDQUFDO1FBQy9ELGdCQUFnQixDQUFDLEtBQUssRUFBRSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDaEIsT0FBTztRQUNULENBQUM7UUFDRCxJQUFJLEtBQUssR0FBRyxTQUFTLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2xDLEtBQUssQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksR0FBRyxXQUFXLENBQUM7UUFDdEMsSUFBSSxDQUFDLFlBQVksR0FBRyxnQkFBZ0IsQ0FBQyxlQUFlLENBQXlCLElBQUksQ0FBQyxhQUFjLENBQUMsQ0FBQztRQUNsRyxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ3pDLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxDQUFDLFVBQVUsR0FBRyxpQkFBaUIsQ0FBQztRQUMxRCxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQztRQUM1RCxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUN4RCxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxRQUFRLEdBQUcsQ0FBQyxLQUFVLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDL0UsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDakQsSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQzdELENBQUM7UUFDRCxJQUFJLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUMvRCxDQUFDO0lBRUQsWUFBWSxDQUFDLEtBQVU7UUFDckIsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLEVBQUUsWUFBWSxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSyxFQUFFLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxRQUFrQixFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsS0FBSyxRQUFRLENBQUMsRUFBRSxDQUFFLENBQUMsQ0FBQztRQUM3SSxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM1QixDQUFDO0lBRUQsWUFBWTtRQUNWLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVELFFBQVEsQ0FBQyxPQUF3QjtRQUMvQixPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxRQUFRLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxDQUFDLENBQUM7WUFDbkQsUUFBUSxFQUFFLElBQUk7U0FDZixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7SUFDWCxDQUFDO0lBRUQsd0JBQXdCO1FBQ3RCLElBQUksQ0FBQyxTQUFTLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztRQUNsQyxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDN0IsSUFBSSxDQUFDLFdBQVcsQ0FBQyxVQUFVLEVBQUUsQ0FBQTtZQUM3QixJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxDQUFDO1lBQ3pCLE9BQU8sSUFBSSxDQUFDO1FBQ2QsQ0FBQztRQUNELE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztnSEEzTVUsZUFBZTtvRUFBZixlQUFlOzs7MkJBY2YsMkJBQTJCOzJCQUMzQixzQkFBc0I7Ozs7Ozs7Z0dBekJ0QixDQUFDO29CQUNWLE9BQU8sRUFBRSxpQkFBaUI7b0JBQzFCLFdBQVcsRUFBRSxVQUFVLENBQUMsR0FBRyxFQUFFLENBQUMsZUFBZSxDQUFDO29CQUM5QyxLQUFLLEVBQUUsSUFBSTtpQkFDWixFQUFFO29CQUNELE9BQU8sRUFBRSxhQUFhO29CQUN0QixXQUFXLEVBQUUsVUFBVSxDQUFDLEdBQUcsRUFBRSxDQUFDLGVBQWUsQ0FBQztvQkFDOUMsS0FBSyxFQUFFLElBQUk7aUJBQ1osQ0FBQzs7WUMzQkUsQUFERixBQURGLEFBREYsOEJBQTZCLGFBQ1ksYUFDZixtQ0FFa0Q7WUFBM0MsZ0xBQXFCLHdCQUFvQixLQUFDO1lBQ3ZFLEFBRHdFLGlCQUF5QixFQUMzRjtZQUNOLDhCQUFzQjtZQUNwQiwyRUFBMkI7WUFLN0IsaUJBQU07WUFDTiw4QkFBc0I7WUFDcEIsdUVBQWtCO1lBSXBCLGlCQUFNO1lBQ04sOEJBQWlDO1lBQy9CLDZFQUFnQjtZQU1wQixBQURFLGlCQUFNLEVBQ0Y7WUFDTiwyRUFBMEI7WUFNNUIsaUJBQU07O1lBakNELHlDQUF1QjtZQUdrRSxlQUFlO1lBQWYsaUNBQWU7WUFJdkcsZUFJQztZQUpELHNEQUlDO1lBR0QsZUFHQztZQUhELHlDQUdDO1lBR0QsZUFJQztZQUpELHdDQUlDO1lBR0wsY0FJQztZQUpELHNEQUlDO3lRRENVLGVBQWU7O2lGQUFmLGVBQWU7Y0FkM0IsU0FBUzsyQkFDRSxXQUFXLGFBR1YsQ0FBQzt3QkFDVixPQUFPLEVBQUUsaUJBQWlCO3dCQUMxQixXQUFXLEVBQUUsVUFBVSxDQUFDLEdBQUcsRUFBRSxnQkFBZ0IsQ0FBQzt3QkFDOUMsS0FBSyxFQUFFLElBQUk7cUJBQ1osRUFBRTt3QkFDRCxPQUFPLEVBQUUsYUFBYTt3QkFDdEIsV0FBVyxFQUFFLFVBQVUsQ0FBQyxHQUFHLEVBQUUsZ0JBQWdCLENBQUM7d0JBQzlDLEtBQUssRUFBRSxJQUFJO3FCQUNaLENBQUM7d0dBSU8sTUFBTTtrQkFBZCxLQUFLO1lBQ0csT0FBTztrQkFBZixLQUFLO1lBU3FDLFNBQVM7a0JBQW5ELFNBQVM7bUJBQUMsV0FBVyxFQUFFLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRTtZQUNJLFdBQVc7a0JBQXZELFNBQVM7bUJBQUMsYUFBYSxFQUFFLEVBQUUsTUFBTSxFQUFFLEtBQUssRUFBRTtZQUNILFdBQVc7a0JBQWxELFNBQVM7bUJBQUMsMkJBQTJCO1lBQ2dCLGVBQWU7a0JBQXBFLFNBQVM7bUJBQUMsc0JBQXNCLEVBQUUsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFOztrRkFmekMsZUFBZSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENoYW5nZURldGVjdG9yUmVmLCBDb21wb25lbnQsIENvbXBvbmVudFJlZiwgRXZlbnRFbWl0dGVyLCBmb3J3YXJkUmVmLCBJbnB1dCwgT25Jbml0LCBPdXRwdXQsIFZpZXdDaGlsZCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQWJzdHJhY3RDb250cm9sLCBDb250cm9sVmFsdWVBY2Nlc3NvciwgRm9ybUJ1aWxkZXIsIEZvcm1Db250cm9sLCBGb3JtR3JvdXAsIE5HX1ZBTElEQVRPUlMsIE5HX1ZBTFVFX0FDQ0VTU09SLCBWYWxpZGF0aW9uRXJyb3JzLCBWYWxpZGF0b3IsIFZhbGlkYXRvcnMgfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XG5pbXBvcnQgeyBvZiB9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHsgZGVib3VuY2VUaW1lLCBtYXAgfSBmcm9tICdyeGpzL29wZXJhdG9ycyc7XG5pbXBvcnQgeyBFbnRpdHkgfSBmcm9tICcuLi8uLi9jb3JlL21vZGVscy9lbnRpdHknO1xuaW1wb3J0IHsgRmllbGQgfSBmcm9tICcuLi8uLi9jb3JlL21vZGVscy9maWVsZCc7XG5pbXBvcnQgeyBGaWx0ZXIgfSBmcm9tICcuLi9tb2RlbHMvZmlsdGVyJztcbmltcG9ydCB7IE9wZXJhdG9yIH0gZnJvbSAnLi4vbW9kZWxzL29wZXJhdG9yJztcbmltcG9ydCB7IEZvcm1GaWVsZENvbXBvbmVudCB9IGZyb20gJy4uLy4uL2Zvcm0tZmllbGRzL2ZpZWxkLXJlbmRlcmVycy9idWlsdC1pbnMvZm9ybS1maWVsZC9mb3JtLWZpZWxkLmNvbXBvbmVudCc7XG5pbXBvcnQgeyBGaWVsZE9wdGlvbnMgfSBmcm9tICcuLi8uLi9mb3JtLWZpZWxkcy9tb2RlbHMvZmllbGQtb3B0aW9ucyc7XG5pbXBvcnQgeyBTZWFyY2hhYmxlRHJvcGRvd25Db21wb25lbnQgfSBmcm9tICcuLi8uLi9jb21wb25lbnRzL3NlYXJjaGFibGUtZHJvcGRvd24vc2VhcmNoYWJsZS1kcm9wZG93bi5jb21wb25lbnQnO1xuaW1wb3J0IHsgU2VhcmNoYWJsZUl0ZW0gfSBmcm9tICcuLi8uLi9jb21wb25lbnRzL3NlYXJjaGFibGUtZHJvcGRvd24vc2VhcmNoYWJsZS1pdGVtJztcbmltcG9ydCB7IEFic3RyYWN0RmllbGRDb21wb25lbnQgfSBmcm9tICcuLi8uLi9mb3JtLWZpZWxkcy9maWVsZC1yZW5kZXJlcnMvYnVpbHQtaW5zL2Fic3RyYWN0LWZpZWxkLmNvbXBvbmVudCc7XG5pbXBvcnQgeyBJbnB1dEZpZWxkQ29tcG9uZW50IH0gZnJvbSAnLi4vLi4vZm9ybS1maWVsZHMvZmllbGQtcmVuZGVyZXJzL2J1aWx0LWlucy9pbnB1dC9pbnB1dC1maWVsZC5jb21wb25lbnQnO1xuaW1wb3J0IHsgVmlld0NvbnRhaW5lckRpcmVjdGl2ZSB9IGZyb20gJy4uLy4uL3V0aWxpdHkvZGlyZWN0aXZlcy92aWV3LWNvbnRhaW5lci5kaXJlY3RpdmUnO1xuaW1wb3J0IHsgY2xvbmVEZWVwLCBpc1N0cmluZyB9IGZyb20gJ2xvZGFzaC1lcyc7XG5pbXBvcnQgeyBFbnRpdHlTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vY29yZS9zZXJ2aWNlcy9lbnRpdHkuc2VydmljZSc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ3hmLWZpbHRlcicsXG4gIHRlbXBsYXRlVXJsOiAnLi9maWx0ZXIuY29tcG9uZW50Lmh0bWwnLFxuICBzdHlsZVVybHM6IFsnLi9maWx0ZXIuY29tcG9uZW50LnNjc3MnXSxcbiAgcHJvdmlkZXJzOiBbe1xuICAgIHByb3ZpZGU6IE5HX1ZBTFVFX0FDQ0VTU09SLFxuICAgIHVzZUV4aXN0aW5nOiBmb3J3YXJkUmVmKCgpID0+IEZpbHRlckNvbXBvbmVudCksXG4gICAgbXVsdGk6IHRydWVcbiAgfSwge1xuICAgIHByb3ZpZGU6IE5HX1ZBTElEQVRPUlMsXG4gICAgdXNlRXhpc3Rpbmc6IGZvcndhcmRSZWYoKCkgPT4gRmlsdGVyQ29tcG9uZW50KSxcbiAgICBtdWx0aTogdHJ1ZVxuICB9XVxufSlcbmV4cG9ydCBjbGFzcyBGaWx0ZXJDb21wb25lbnQgaW1wbGVtZW50cyBDb250cm9sVmFsdWVBY2Nlc3NvciwgVmFsaWRhdG9yIHtcblxuICBASW5wdXQoKSBlbnRpdHkhOiBFbnRpdHk7XG4gIEBJbnB1dCgpIGlzQ2hpbGQ6IGJvb2xlYW4gPSBmYWxzZTtcbiAgc3ViRW50aXR5PzogRW50aXR5O1xuICBpdGVtczogU2VhcmNoYWJsZUl0ZW1bXSA9IFtdO1xuICBmaWVsZFZhbHVlITogU2VhcmNoYWJsZUl0ZW0gfCBudWxsO1xuICBmb3JtR3JvdXAhOiBGb3JtR3JvdXA7XG4gIGZpZWxkT3B0aW9uczogRmllbGRPcHRpb25zO1xuICB2YWx1ZTogRmlsdGVyO1xuICBmaWVsZDogRmllbGQgfCBudWxsID0gbnVsbDtcbiAgZmllbGRSZW5kZXJlcjogYW55IHwgbnVsbCA9IG51bGw7XG4gIEBWaWV3Q2hpbGQoJ2Zvcm1GaWVsZCcsIHsgc3RhdGljOiBmYWxzZSB9KSBmb3JtRmllbGQhOiBGb3JtRmllbGRDb21wb25lbnQ7XG4gIEBWaWV3Q2hpbGQoJ2ZpbHRlckZpZWxkJywgeyBzdGF0aWM6IGZhbHNlIH0pIGZpbHRlckZpZWxkITogU2VhcmNoYWJsZURyb3Bkb3duQ29tcG9uZW50O1xuICBAVmlld0NoaWxkKFNlYXJjaGFibGVEcm9wZG93bkNvbXBvbmVudCkgZmllbGRTZWxlY3QhOiBTZWFyY2hhYmxlRHJvcGRvd25Db21wb25lbnQ7XG4gIEBWaWV3Q2hpbGQoVmlld0NvbnRhaW5lckRpcmVjdGl2ZSwgeyBzdGF0aWM6IGZhbHNlIH0pIHhmVmlld0NvbnRhaW5lciE6IFZpZXdDb250YWluZXJEaXJlY3RpdmU7XG4gIGNvbXBvbmVudFJlZiE6IENvbXBvbmVudFJlZjxBYnN0cmFjdEZpZWxkQ29tcG9uZW50PjtcbiAgb25DaGFuZ2UgPSAoXzogYW55KSA9PiB7IH07XG4gIG9uVG91Y2hlZCA9ICgpID0+IHsgfTtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIGNoYW5nZURldGVjdG9yUmVmOiBDaGFuZ2VEZXRlY3RvclJlZixcbiAgICBwcml2YXRlIGVudGl0eVNlcnZpY2U6IEVudGl0eVNlcnZpY2UsXG4gICAgcHJpdmF0ZSBmb3JtQnVpbGRlcjogRm9ybUJ1aWxkZXJcbiAgKSB7XG4gICAgdGhpcy52YWx1ZSA9IG5ldyBGaWx0ZXIoKTtcbiAgICB0aGlzLmZpZWxkT3B0aW9ucyA9IG5ldyBGaWVsZE9wdGlvbnMoe1xuICAgICAgc2hvd0xhYmVsOiBmYWxzZVxuICAgIH0pO1xuICAgIHRoaXMuZm9ybUdyb3VwID0gdGhpcy5mb3JtQnVpbGRlci5ncm91cCh7XG4gICAgICBmaWx0ZXJGaWVsZDogW251bGwsIFZhbGlkYXRvcnMucmVxdWlyZWRdLFxuICAgICAgb3BlcmF0b3I6IFtudWxsLCBWYWxpZGF0b3JzLnJlcXVpcmVkXSxcbiAgICAgIHZhbHVlOiBbbnVsbF0sXG4gICAgICBzdWJEYXRhRmlsdGVyOiBbbnVsbF1cbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyB3cml0ZVZhbHVlKHZhbHVlOiBGaWx0ZXIpOiB2b2lkIHtcbiAgICB0aGlzLnZhbHVlID0gdmFsdWUgfHwgbmV3IEZpbHRlcigpO1xuICAgIGxldCBmaWVsZCA9IHRoaXMudmFsdWUuZmllbGQ7XG4gICAgbGV0IHN1YkZpbHRlcjogRmlsdGVyIHwgbnVsbCA9IG51bGw7XG4gICAgaWYgKHRoaXMudmFsdWUuZmllbGQgJiYgdGhpcy52YWx1ZS5maWVsZD8uaW5kZXhPZignLicpID4gLTEpIHtcbiAgICAgIGNvbnN0IHBhcnRzID0gdGhpcy52YWx1ZS5maWVsZC5zcGxpdCgnLicpO1xuICAgICAgZmllbGQgPSBwYXJ0c1swXTtcbiAgICAgIHBhcnRzLnNoaWZ0KCk7XG4gICAgICBzdWJGaWx0ZXIgPSBjbG9uZURlZXAodmFsdWUpO1xuICAgICAgc3ViRmlsdGVyLmZpZWxkID0gcGFydHMuam9pbignLicpO1xuICAgICAgdGhpcy5mb3JtR3JvdXAuY29udHJvbHMub3BlcmF0b3IuY2xlYXJWYWxpZGF0b3JzKCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuZm9ybUdyb3VwLmNvbnRyb2xzLm9wZXJhdG9yLnNldFZhbGlkYXRvcnMoVmFsaWRhdG9ycy5yZXF1aXJlZCk7XG4gICAgfVxuICAgIHRoaXMuZmllbGRWYWx1ZSA9IGZpZWxkICYmIHRoaXMuZW50aXR5LmZpZWxkc1tmaWVsZF0gPyB0aGlzLmVudGl0eS5maWVsZHNbZmllbGRdLmFzU2VhcmNoYWJsZUl0ZW0oKSA6IG51bGw7XG4gICAgaWYgKHRoaXMuZmllbGRWYWx1ZSkge1xuICAgICAgdGhpcy5zZXRGaWVsZCh0aGlzLmZpZWxkVmFsdWUudmFsdWUpO1xuICAgIH1cbiAgICB0aGlzLmZvcm1Hcm91cC5zZXRWYWx1ZSh7XG4gICAgICBmaWx0ZXJGaWVsZDogdGhpcy5maWVsZFZhbHVlLFxuICAgICAgb3BlcmF0b3I6IHRoaXMudmFsdWUub3BlcmF0b3IsXG4gICAgICB2YWx1ZTogdGhpcy52YWx1ZS5vcmlnaW5hbFZhbHVlIHx8IHRoaXMudmFsdWUudmFsdWUsXG4gICAgICBzdWJEYXRhRmlsdGVyOiBzdWJGaWx0ZXJcbiAgICB9LCB7XG4gICAgICBlbWl0RXZlbnQ6IGZhbHNlXG4gICAgfSk7XG4gICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gIH1cblxuICBwdWJsaWMgcmVnaXN0ZXJPbkNoYW5nZShmbjogKHZhbHVlOiBzdHJpbmcpID0+IHZvaWQpOiB2b2lkIHtcbiAgICB0aGlzLm9uQ2hhbmdlID0gZm47XG4gIH1cblxuICBwdWJsaWMgcmVnaXN0ZXJPblRvdWNoZWQoZm46ICgpID0+IHZvaWQpOiB2b2lkIHtcbiAgICB0aGlzLm9uVG91Y2hlZCA9IGZuO1xuICB9XG5cbiAgbmdPbkluaXQoKTogdm9pZCB7XG4gICAgdGhpcy5mb3JtR3JvdXAuY29udHJvbHMub3BlcmF0b3IudmFsdWVDaGFuZ2VzLnN1YnNjcmliZSgodmFsdWU6IHN0cmluZykgPT4gdGhpcy5vcGVyYXRvckNoYW5nZWQodmFsdWUpKTtcbiAgICB0aGlzLmZvcm1Hcm91cC5jb250cm9scy52YWx1ZS52YWx1ZUNoYW5nZXMuc3Vic2NyaWJlKCh2YWx1ZTogYW55KSA9PiB0aGlzLnZhbHVlQ2hhbmdlZCh2YWx1ZSkpO1xuICAgIHRoaXMuZm9ybUdyb3VwLmNvbnRyb2xzLmZpbHRlckZpZWxkLnZhbHVlQ2hhbmdlcy5zdWJzY3JpYmUoKHZhbHVlOiBhbnkpID0+IHtcbiAgICAgIHRoaXMuZmllbGRWYWx1ZSA9IHZhbHVlO1xuICAgICAgdGhpcy5maWVsZENoYW5nZWQoKTtcbiAgICB9KTtcbiAgICB0aGlzLmZvcm1Hcm91cC5jb250cm9scy5zdWJEYXRhRmlsdGVyLnZhbHVlQ2hhbmdlcy5zdWJzY3JpYmUoKHZhbHVlOiBhbnkpID0+IHtcbiAgICAgIGlmICghdmFsdWUpIHtcbiAgICAgICAgdGhpcy5vbkNoYW5nZShudWxsKTtcbiAgICAgICAgcmV0dXJuO1xuICAgICAgfVxuICAgICAgbGV0IGZ1bGxWYWx1ZSA9IGNsb25lRGVlcCh2YWx1ZSk7XG4gICAgICBmdWxsVmFsdWUuZmllbGQgPSB0aGlzLmZpZWxkPy5uYW1lICsgJy4nICsgdmFsdWUuZmllbGQ7XG4gICAgICB0aGlzLnZhbHVlID0gZnVsbFZhbHVlO1xuICAgICAgdGhpcy5vbkNoYW5nZShmdWxsVmFsdWUpO1xuICAgIH0pO1xuICAgIHRoaXMuZmlsdGVyRmllbGRzKCcnKTtcbiAgfVxuXG4gIGZpbHRlckZpZWxkcyhzZWFyY2g6IHN0cmluZykge1xuICAgIG9mKHRoaXMuZW50aXR5LmF0dHJpYnV0ZXMpLnBpcGUoXG4gICAgICBtYXAoKGZpZWxkczogRmllbGRbXSkgPT4ge1xuICAgICAgICByZXR1cm4gZmllbGRzLm1hcCgoZmllbGQ6IEZpZWxkKSA9PiBmaWVsZC5hc1NlYXJjaGFibGVJdGVtKCkpO1xuICAgICAgfSksXG4gICAgICBtYXAoKGl0ZW1zOiBTZWFyY2hhYmxlSXRlbVtdKSA9PiB7XG4gICAgICAgIHJldHVybiBpdGVtcy5maWx0ZXIoKGl0ZW06IFNlYXJjaGFibGVJdGVtKSA9PiB7XG4gICAgICAgICAgcmV0dXJuIGlzU3RyaW5nKGl0ZW0uZGlzcGxheSkgJiYgaXRlbS5kaXNwbGF5LnRvTG93ZXJDYXNlKCkuaW5kZXhPZihzZWFyY2gudG9Mb3dlckNhc2UoKSkgPiAtMTtcbiAgICAgICAgfSk7XG4gICAgICB9KVxuICAgICkuc3Vic2NyaWJlKChpdGVtczogU2VhcmNoYWJsZUl0ZW1bXSkgPT4ge1xuICAgICAgdGhpcy5pdGVtcyA9IGl0ZW1zO1xuICAgICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgfSk7XG4gIH1cblxuICBzZXRGaWVsZChmaWVsZDogRmllbGQpIHtcbiAgICBpZiAoZmllbGQgJiYgdGhpcy5lbnRpdHkuZmllbGRzW2ZpZWxkLm5hbWVdLmZvcm1UeXBlICE9PSBmaWVsZC5mb3JtVHlwZSkge1xuICAgICAgLy8gUmVzZXQgdmlld1xuICAgICAgdGhpcy5maWVsZCA9IG51bGw7XG4gICAgICB0aGlzLmZpZWxkUmVuZGVyZXIgPSBudWxsO1xuICAgICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gICAgfVxuICAgIHRoaXMuZmllbGQgPSBmaWVsZDtcbiAgICBpZiAoZmllbGQuZGF0YSkge1xuICAgICAgdGhpcy5zdWJFbnRpdHkgPSB0aGlzLmVudGl0eVNlcnZpY2UuY3JlYXRlRW50aXR5RnJvbURhdGEoZmllbGQuZGF0YSwgJ3N1Yi1maWVsZC0nICsgZmllbGQubmFtZSk7XG4gICAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgICAgIHJldHVybjtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5zdWJFbnRpdHkgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgICB9XG4gICAgaWYgKHRoaXMudmFsdWUub3BlcmF0b3IpIHtcbiAgICAgIGNvbnN0IG9wZXJhdG9yID0gdGhpcy5maWVsZD8uZ2V0T3BlcmF0b3IodGhpcy52YWx1ZS5vcGVyYXRvcik7XG4gICAgICB0aGlzLnNldFJlbmRlcmVyKG9wZXJhdG9yKTtcbiAgICB9IGVsc2Uge1xuICAgICAgY29uc3QgZGVmYXVsdE9wZXJhdG9yID0gZmllbGQub3BlcmF0b3JzWzBdO1xuICAgICAgdGhpcy5zZXRSZW5kZXJlcihkZWZhdWx0T3BlcmF0b3IpO1xuICAgICAgdGhpcy5mb3JtR3JvdXAuY29udHJvbHMub3BlcmF0b3Iuc2V0VmFsdWUoZGVmYXVsdE9wZXJhdG9yLmlkKTtcbiAgICB9XG4gICAgdGhpcy5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gIH1cblxuICBmaWVsZENoYW5nZWQoKSB7XG4gICAgaWYgKCF0aGlzLmZpZWxkVmFsdWUpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgdGhpcy52YWx1ZS5vcGVyYXRvciA9IG51bGw7XG4gICAgdGhpcy52YWx1ZS5maWVsZCA9IHRoaXMuZmllbGRWYWx1ZS52YWx1ZS5uYW1lO1xuICAgIHRoaXMuc2V0RmllbGQodGhpcy5maWVsZFZhbHVlLnZhbHVlKTtcbiAgICB0aGlzLm9uQ2hhbmdlKHRoaXMudmFsdWUpO1xuICB9XG5cbiAgb3BlcmF0b3JDaGFuZ2VkKG5ld09wZXJhdG9ySWQ6IHN0cmluZykge1xuICAgIGNvbnN0IG9wZXJhdG9yID0gdGhpcy5maWVsZD8uZ2V0T3BlcmF0b3IobmV3T3BlcmF0b3JJZCk7XG4gICAgdGhpcy52YWx1ZS5vcGVyYXRvciA9IG9wZXJhdG9yPy5pZCB8fCBudWxsO1xuICAgIHRoaXMuc2V0UmVuZGVyZXIob3BlcmF0b3IpO1xuICAgIHRoaXMub25DaGFuZ2UodGhpcy52YWx1ZSk7XG4gIH1cblxuICBwcml2YXRlIHNldFJlbmRlcmVyKG9wZXJhdG9yPzogT3BlcmF0b3IpIHtcbiAgICBpZihvcGVyYXRvcj8ucmVuZGVyZXIpIHtcbiAgICAgIHRoaXMuZmllbGRSZW5kZXJlciA9IG9wZXJhdG9yLnJlbmRlcmVyO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLmZpZWxkUmVuZGVyZXIgPSBJbnB1dEZpZWxkQ29tcG9uZW50O1xuICAgIH1cbiAgICBjb25zdCB2aWV3Q29udGFpbmVyUmVmID0gdGhpcy54ZlZpZXdDb250YWluZXIudmlld0NvbnRhaW5lclJlZjtcbiAgICB2aWV3Q29udGFpbmVyUmVmLmNsZWFyKCk7XG4gICAgaWYgKCF0aGlzLmZpZWxkKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuICAgIGxldCBmaWVsZCA9IGNsb25lRGVlcCh0aGlzLmZpZWxkKTtcbiAgICBmaWVsZC5uYW1lID0gZmllbGQubmFtZSArICctcmVuZGVyZXInO1xuICAgIHRoaXMuY29tcG9uZW50UmVmID0gdmlld0NvbnRhaW5lclJlZi5jcmVhdGVDb21wb25lbnQ8QWJzdHJhY3RGaWVsZENvbXBvbmVudD4odGhpcy5maWVsZFJlbmRlcmVyISk7XG4gICAgdGhpcy5jb21wb25lbnRSZWYuaW5zdGFuY2UuZmllbGQgPSBmaWVsZDtcbiAgICB0aGlzLmNvbXBvbmVudFJlZi5pbnN0YW5jZS5maWVsZENsYXNzID0gJ2Zvcm0tY29udHJvbC1zbSc7XG4gICAgdGhpcy5jb21wb25lbnRSZWYuaW5zdGFuY2UuZmllbGRPcHRpb25zID0gdGhpcy5maWVsZE9wdGlvbnM7XG4gICAgdGhpcy5jb21wb25lbnRSZWYuaW5zdGFuY2Uud3JpdGVWYWx1ZSh0aGlzLnZhbHVlLnZhbHVlKTtcbiAgICB0aGlzLmNvbXBvbmVudFJlZi5pbnN0YW5jZS5vbkNoYW5nZSA9ICh2YWx1ZTogYW55KSA9PiB0aGlzLnZhbHVlQ2hhbmdlZCh2YWx1ZSk7XG4gICAgaWYgKCF0aGlzLnZhbHVlLnZhbHVlICYmIHRoaXMuZmllbGQuZGVmYXVsdFZhbHVlKSB7XG4gICAgICB0aGlzLmNvbXBvbmVudFJlZi5pbnN0YW5jZS52YWx1ZSA9IHRoaXMuZmllbGQuZGVmYXVsdFZhbHVlO1xuICAgIH1cbiAgICB0aGlzLmNvbXBvbmVudFJlZi5pbnN0YW5jZS5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XG4gIH1cblxuICB2YWx1ZUNoYW5nZWQodmFsdWU6IGFueSkge1xuICAgIHRoaXMudmFsdWUub3JpZ2luYWxWYWx1ZSA9IHZhbHVlO1xuICAgIHRoaXMudmFsdWUudmFsdWUgPSB0aGlzLmZpZWxkPy5nZXRGbGF0VmFsdWUodmFsdWUsIHRoaXMuZmllbGQ/Lm9wZXJhdG9ycy5maW5kKChvcGVyYXRvcjogT3BlcmF0b3IpID0+IHRoaXMudmFsdWUub3BlcmF0b3IgPT09IG9wZXJhdG9yLmlkKSEpO1xuICAgIHRoaXMub25DaGFuZ2UodGhpcy52YWx1ZSk7XG4gIH1cblxuICBkZWxldGVGaWx0ZXIoKSB7XG4gICAgdGhpcy5vbkNoYW5nZShudWxsKTtcbiAgfVxuXG4gIHZhbGlkYXRlKGNvbnRyb2w6IEFic3RyYWN0Q29udHJvbCk6IFZhbGlkYXRpb25FcnJvcnMgfCBudWxsIHtcbiAgICByZXR1cm4gIXRoaXMudmFsdWU/Lm9wZXJhdG9yIHx8ICF0aGlzLnZhbHVlPy5maWVsZCA/IHtcbiAgICAgIHJlcXVpcmVkOiB0cnVlXG4gICAgfSA6IG51bGw7XG4gIH1cblxuICBmb2N1c09uRmlyc3RJbnZhbGlkSW5wdXQoKSB7XG4gICAgdGhpcy5mb3JtR3JvdXAubWFya0FsbEFzVG91Y2hlZCgpO1xuICAgIGlmICh0aGlzLmZpbHRlckZpZWxkLmludmFsaWQpIHtcbiAgICAgIHRoaXMuZmlsdGVyRmllbGQuc2V0VG91Y2hlZCgpXG4gICAgICB0aGlzLmZpbHRlckZpZWxkLmZvY3VzKCk7XG4gICAgICByZXR1cm4gdHJ1ZTtcbiAgICB9XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9XG5cbn1cbiIsIjxkaXYgW2Zvcm1Hcm91cF09XCJmb3JtR3JvdXBcIj5cbiAgPGRpdiBjbGFzcz1cImQtZmxleCBhbGlnbi1pdGVtcy1jZW50ZXJcIj5cbiAgICA8ZGl2IGNsYXNzPVwiY29sIHBlLTFcIj5cbiAgICAgIDx4Zi1zZWFyY2hhYmxlLWRyb3Bkb3duICNmaWx0ZXJGaWVsZCBidXR0b25TdHlsZT1cInNlbGVjdFwiIGZvcm1Db250cm9sTmFtZT1cImZpbHRlckZpZWxkXCIgW2l0ZW1zXT1cIml0ZW1zXCJcbiAgICAgIHBsYWNlaG9sZGVyPVwiU2VsZWN0IEZpZWxkXCIgKHNlYXJjaFF1ZXJ5Q2hhbmdlKT1cImZpbHRlckZpZWxkcygkZXZlbnQpXCI+PC94Zi1zZWFyY2hhYmxlLWRyb3Bkb3duPlxuICAgIDwvZGl2PlxuICAgIDxkaXYgY2xhc3M9XCJjb2wgcHgtMVwiPlxuICAgICAgQGlmIChmaWVsZCAmJiAhc3ViRW50aXR5KSB7XG4gICAgICAgIDxzZWxlY3QgY2xhc3M9XCJmb3JtLXNlbGVjdCBmb3JtLXNlbGVjdC1zbVwiIGZvcm1Db250cm9sTmFtZT1cIm9wZXJhdG9yXCI+XG4gICAgICAgICAgPG9wdGlvbiAqbmdGb3I9XCJsZXQgb3BlcmF0b3Igb2YgZmllbGQub3BlcmF0b3JzXCIgW25nVmFsdWVdPVwib3BlcmF0b3IuaWRcIj57eyBvcGVyYXRvci50aXRsZSB9fTwvb3B0aW9uPlxuICAgICAgICA8L3NlbGVjdD5cbiAgICAgIH1cbiAgICA8L2Rpdj5cbiAgICA8ZGl2IGNsYXNzPVwiY29sIHB4LTFcIj5cbiAgICAgIEBpZiAoIXN1YkVudGl0eSkge1xuICAgICAgICA8IS0tIDx4Zi1mb3JtLWZpZWxkICpuZ0lmPVwiZmllbGRSZW5kZXJlclwiIGZvcm1Db250cm9sTmFtZT1cInZhbHVlXCIgW2ZpZWxkXT1cImZpZWxkUmVuZGVyZXJcIiBbZmllbGRPcHRpb25zXT1cImZpZWxkT3B0aW9uc1wiIFtmaWVsZENsYXNzXT1cIidmb3JtLWNvbnRyb2wtc20nXCIgI2Zvcm1GaWVsZD48L3hmLWZvcm0tZmllbGQ+IC0tPlxuICAgICAgICA8bmctdGVtcGxhdGUgeGZWaWV3Q29udGFpbmVyPjwvbmctdGVtcGxhdGU+XG4gICAgICB9XG4gICAgPC9kaXY+XG4gICAgPGRpdiBjbGFzcz1cImNvbCBjb2wtZGVsZXRlIHBzLTFcIj5cbiAgICAgIEBpZiAoIWlzQ2hpbGQpIHtcbiAgICAgICAgPGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCIgY2xhc3M9XCJidG4gYnRuLXNtIGJ0bi1vdXRsaW5lXCIgKGNsaWNrKT1cImRlbGV0ZUZpbHRlcigpXCI+XG4gICAgICAgICAgPGkgY2xhc3M9XCJmYSBmYS1jbG9zZSB0ZXh0LWRhbmdlclwiPjwvaT5cbiAgICAgICAgPC9idXR0b24+XG4gICAgICB9XG4gICAgPC9kaXY+XG4gIDwvZGl2PlxuICBAaWYgKGZpZWxkICYmIHN1YkVudGl0eSkge1xuICAgIDxkaXYgY2xhc3M9XCJtdC0yXCI+XG4gICAgICA8eGYtZmlsdGVyIFtlbnRpdHldPVwic3ViRW50aXR5XCIgZm9ybUNvbnRyb2xOYW1lPVwic3ViRGF0YUZpbHRlclwiIFtpc0NoaWxkXT1cInRydWVcIj48L3hmLWZpbHRlcj5cbiAgICA8L2Rpdj5cbiAgfVxuXG48L2Rpdj5cbiJdfQ==