import { __decorate } from "tslib";
import { Type } from "class-transformer";
import { cloneDeep, forEach } from "lodash-es";
import { Filter } from "./filter";
import { FilterGroup } from "./filter-group";
import { DEFAULT_GRID_ROWS } from "../../core/constants";
export class Query {
    constructor(query) {
        this.limit = DEFAULT_GRID_ROWS;
        this.search = '';
        this.logic = 'AND';
        this.page = 1;
        this.relationships = false;
        this.selectedFields = [];
        this.filters = [];
        this.sort = [];
        this.aggregates = [];
        this.showDeleted = false;
        this.ignoreFields = [];
        this.queryParams = {};
        Object.assign(this, query);
    }
    getURLParameters() {
        let queryParams = {};
        if (this.limit) {
            queryParams.$limit = this.limit;
        }
        if (this.page > 0) {
            queryParams.$page = this.page;
        }
        if (this.relationships === true) {
            queryParams.$relationships = this.relationships;
        }
        if (this.search?.length > 0) {
            queryParams.$search = this.search;
        }
        if (this.showDeleted === true) {
            queryParams.$showDeleted = this.showDeleted;
        }
        if (this.queryParams) {
            forEach(this.queryParams, (value, key) => {
                queryParams[key] = value;
            });
        }
        if (this.sort.length > 0) {
            // if (entity) {
            //   var sorts = angular.copy(this.sort);
            //   this.sort = [];
            //   for (var i = 0, iLen = sorts.length; i < iLen; i++) {
            //     var fieldName = sorts[i].field;
            //     var fieldObj = entity.fields ? entity.fields[fieldName] : undefined;
            //     if (fieldObj) {
            //       var fieldSort = fieldObj.buildSort(sorts[i].direction || sorts[i].sort.direction);
            //       for (var fieldSortIndex = 0; fieldSortIndex < fieldSort.length; fieldSortIndex++) {
            //         this.sort.push(fieldSort[fieldSortIndex]);
            //       }
            //     }
            //   }
            // }
            let orderBy = '';
            this.sort.forEach((sortItem, index) => {
                if (index > 0) {
                    orderBy += ',';
                }
                let direction = sortItem.direction.toLowerCase() === 'desc' ? '-' : '+';
                orderBy += direction + sortItem.field;
            });
            queryParams.$orderby = orderBy;
        }
        return queryParams;
    }
    mergeQueries(queries) {
        forEach(queries, (query) => {
            this.filters.push(...query.filters);
            this.sort.push(...query.sort);
        });
    }
    getQueryObject(useValue = false) {
        let query = {
            sort: [],
            logic: this.logic,
            page: this.page
        };
        if (this.search.length > 0) {
            query.search = this.search;
        }
        if (this.showDeleted === true) {
            query.showDeleted = this.showDeleted;
        }
        query.filters = cloneDeep(this.filters);
        if (this.relationships) {
            query.$relationships = this.relationships;
        }
        if (query.filters.length > 0) {
            query.logic = this.logic;
            query.filters = this.transformFilters(query.filters, useValue);
        }
        if (this.aggregates && this.aggregates.length > 0) {
            query.aggregates = this.aggregates;
        }
        if (this.selectedFields.length > 0) {
            query.fields = this.selectedFields;
        }
        if (this.ignoreFields?.length > 0) {
            query.__ignoreFields = this.ignoreFields;
        }
        if (this.sort.length > 0) {
            query.sort = this.sort;
        }
        // else if (defaultQuery && defaultQuery.sort) {
        //   query.sort = defaultQuery.sort;
        // }
        return query;
    }
    ;
    transformFilters(filters, useValue) {
        let transFormedFilters = [];
        filters.forEach((filter) => {
            // this is a related record filter
            // if (filter.subFields) {
            //   delete filter.subFields;
            //   filter.field = filter.module + '.' + filter.field;
            //   delete filter.module;
            // }
            //if(filter.value && isString(filter.value) && filter.value.indexOf('{{') !== -1){
            //see for any query object in URL if yes then apply where ever the {{expressions}} are used.
            // if(!angular.isUndefined($state.params.qparam) && useValue){
            //   var interpolateObject = JSON.parse($state.params.qparam);
            //   interpolateObject.currentUserIri = currentUserIriService;
            //   filter.value = $interpolate(filter.value)(interpolateObject);
            //   if(filter.updateDateIntervalValue){//its a datetime filter
            //     filter.value = filter.value.indexOf('differenceType')>=0?JSON.parse(filter.value):filter.value;//this is case of dateRange where object is passed
            //     filter.updateDateIntervalValue(filter);
            //   }
            // }
            //}
            if (filter.filters?.length > 0) {
                filter = filter;
                let returnedFilter = this.transformFilters(filter.filters, useValue);
                let filterObj = {
                    logic: filter.logic,
                    filters: returnedFilter
                };
                transFormedFilters.push(filterObj);
            }
            else if (filter instanceof Filter) {
                transFormedFilters.push(filter.getFlatFilter());
            }
        });
        return transFormedFilters;
    }
    getURLQuery(entity) {
        let flatQuery = {};
        if (this.search) {
            flatQuery.$search = this.search;
        }
        Object.assign(flatQuery, this.getURLParameters());
        this.filters.forEach((filter) => {
            if (filter instanceof Filter) {
                console.log(filter.getURLQuery(entity));
                Object.assign(flatQuery, filter.getURLQuery(entity));
            }
        });
        return flatQuery;
    }
    asFilterGroup() {
        return new FilterGroup(this.filters, this.logic);
    }
}
__decorate([
    Type(() => Filter, {
        discriminator: {
            property: 'logic',
            subTypes: [
                { value: FilterGroup, name: 'AND' },
                { value: FilterGroup, name: 'OR' },
            ]
        },
        keepDiscriminatorProperty: true
    })
], Query.prototype, "filters", void 0);
//# sourceMappingURL=data:application/json;base64,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