import { Directive, Output, EventEmitter, HostListener } from '@angular/core';
import * as i0 from "@angular/core";
export class ScrollTrackerDirective {
    constructor() {
        this.scrollingFinished = new EventEmitter();
        this.emitted = false;
    }
    onScroll(event) {
        if ((window.innerHeight + window.scrollY) >= document.body.scrollHeight && !this.emitted) {
            this.emitted = true;
            this.scrollingFinished.emit();
        }
        else if ((window.innerHeight + window.scrollY) < document.body.scrollHeight) {
            this.emitted = false;
        }
    }
    static { this.ɵfac = function ScrollTrackerDirective_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || ScrollTrackerDirective)(); }; }
    static { this.ɵdir = /*@__PURE__*/ i0.ɵɵdefineDirective({ type: ScrollTrackerDirective, selectors: [["", "scrollTracker", ""]], hostBindings: function ScrollTrackerDirective_HostBindings(rf, ctx) { if (rf & 1) {
            i0.ɵɵlistener("scroll", function ScrollTrackerDirective_scroll_HostBindingHandler($event) { return ctx.onScroll($event); }, false, i0.ɵɵresolveWindow);
        } }, outputs: { scrollingFinished: "scrollingFinished" } }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ScrollTrackerDirective, [{
        type: Directive,
        args: [{
                selector: '[scrollTracker]'
            }]
    }], null, { scrollingFinished: [{
            type: Output
        }], onScroll: [{
            type: HostListener,
            args: ['window:scroll', ['$event']]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2Nyb2xsLXRyYWNrZXIuZGlyZWN0aXZlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc2hhcmVkL3NyYy9saWIvdXRpbGl0eS9kaXJlY3RpdmVzL3Njcm9sbC10cmFja2VyLmRpcmVjdGl2ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0sRUFBRSxZQUFZLEVBQUUsWUFBWSxFQUFFLE1BQU0sZUFBZSxDQUFDOztBQUs5RSxNQUFNLE9BQU8sc0JBQXNCO0lBSG5DO1FBSVksc0JBQWlCLEdBQUcsSUFBSSxZQUFZLEVBQVEsQ0FBQztRQUV2RCxZQUFPLEdBQUcsS0FBSyxDQUFDO0tBV2pCO0lBUkMsUUFBUSxDQUFDLEtBQVU7UUFDakIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDO1lBQ3pGLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUNoQyxDQUFDO2FBQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLFFBQVEsQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDOUUsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7UUFDdkIsQ0FBQztJQUNILENBQUM7dUhBYlUsc0JBQXNCO29FQUF0QixzQkFBc0I7WUFBdEIsbUdBQUEsb0JBQWdCLCtCQUFNOzs7aUZBQXRCLHNCQUFzQjtjQUhsQyxTQUFTO2VBQUM7Z0JBQ1QsUUFBUSxFQUFFLGlCQUFpQjthQUM1QjtnQkFFVyxpQkFBaUI7a0JBQTFCLE1BQU07WUFLUCxRQUFRO2tCQURQLFlBQVk7bUJBQUMsZUFBZSxFQUFFLENBQUMsUUFBUSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGlyZWN0aXZlLCBPdXRwdXQsIEV2ZW50RW1pdHRlciwgSG9zdExpc3RlbmVyIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5cbkBEaXJlY3RpdmUoe1xuICBzZWxlY3RvcjogJ1tzY3JvbGxUcmFja2VyXSdcbn0pXG5leHBvcnQgY2xhc3MgU2Nyb2xsVHJhY2tlckRpcmVjdGl2ZSB7XG4gIEBPdXRwdXQoKSBzY3JvbGxpbmdGaW5pc2hlZCA9IG5ldyBFdmVudEVtaXR0ZXI8dm9pZD4oKTtcblxuICBlbWl0dGVkID0gZmFsc2U7XG5cbiAgQEhvc3RMaXN0ZW5lcignd2luZG93OnNjcm9sbCcsIFsnJGV2ZW50J10pXG4gIG9uU2Nyb2xsKGV2ZW50OiBhbnkpOiB2b2lkIHtcbiAgICBpZiAoKHdpbmRvdy5pbm5lckhlaWdodCArIHdpbmRvdy5zY3JvbGxZKSA+PSBkb2N1bWVudC5ib2R5LnNjcm9sbEhlaWdodCAmJiAhdGhpcy5lbWl0dGVkKSB7XG4gICAgICB0aGlzLmVtaXR0ZWQgPSB0cnVlO1xuICAgICAgdGhpcy5zY3JvbGxpbmdGaW5pc2hlZC5lbWl0KCk7XG4gICAgfSBlbHNlIGlmICgod2luZG93LmlubmVySGVpZ2h0ICsgd2luZG93LnNjcm9sbFkpIDwgZG9jdW1lbnQuYm9keS5zY3JvbGxIZWlnaHQpIHtcbiAgICAgIHRoaXMuZW1pdHRlZCA9IGZhbHNlO1xuICAgIH1cbiAgfVxufVxuIl19