import { Pipe, SecurityContext, inject } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';
import * as i0 from "@angular/core";
export class HighlightPipe {
    constructor() {
        this.domSanitizer = inject(DomSanitizer);
    }
    transform(input, searchText) {
        let individualWords = searchText.match(/\S+/g);
        individualWords?.forEach((word) => {
            let regex = new RegExp(word, 'gi');
            input = input.replace(regex, (match) => {
                return `<mark class='highlighted-result p-0'>${match}</mark>`;
            });
        });
        const sanitized = this.domSanitizer.sanitize(SecurityContext.HTML, input) || '';
        return sanitized;
    }
    static { this.ɵfac = function HighlightPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || HighlightPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "highlight", type: HighlightPipe, pure: true }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(HighlightPipe, [{
        type: Pipe,
        args: [{
                name: 'highlight'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlnaGxpZ2h0LnBpcGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zaGFyZWQvc3JjL2xpYi91dGlsaXR5L3BpcGVzL2hpZ2hsaWdodC5waXBlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFDTCxJQUFJLEVBRUosZUFBZSxFQUNmLE1BQU0sRUFDUCxNQUFNLGVBQWUsQ0FBQztBQUN2QixPQUFPLEVBQUUsWUFBWSxFQUFFLE1BQU0sMkJBQTJCLENBQUM7O0FBS3pELE1BQU0sT0FBTyxhQUFhO0lBSDFCO1FBSUUsaUJBQVksR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDLENBQUM7S0FrQnJDO0lBakJDLFNBQVMsQ0FBQyxLQUFhLEVBQUUsVUFBa0I7UUFDekMsSUFBSSxlQUFlLEdBQUcsVUFBVSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUMvQyxlQUFlLEVBQUUsT0FBTyxDQUFDLENBQUMsSUFBWSxFQUFFLEVBQUU7WUFDeEMsSUFBSSxLQUFLLEdBQUcsSUFBSSxNQUFNLENBQ3BCLElBQUksRUFDSixJQUFJLENBQ0wsQ0FBQztZQUNGLEtBQUssR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssRUFBRSxDQUFDLEtBQWEsRUFBRSxFQUFFO2dCQUM3QyxPQUFPLHdDQUF3QyxLQUFLLFNBQVMsQ0FBQztZQUNoRSxDQUFDLENBQUMsQ0FBQztRQUNMLENBQUMsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQzFDLGVBQWUsQ0FBQyxJQUFJLEVBQ3BCLEtBQUssQ0FDTixJQUFJLEVBQUUsQ0FBQztRQUNSLE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7OEdBbEJVLGFBQWE7bUZBQWIsYUFBYTs7aUZBQWIsYUFBYTtjQUh6QixJQUFJO2VBQUM7Z0JBQ0osSUFBSSxFQUFFLFdBQVc7YUFDbEIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBQaXBlLFxuICBQaXBlVHJhbnNmb3JtLFxuICBTZWN1cml0eUNvbnRleHQsXG4gIGluamVjdFxufSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IERvbVNhbml0aXplciB9IGZyb20gJ0Bhbmd1bGFyL3BsYXRmb3JtLWJyb3dzZXInO1xuXG5AUGlwZSh7XG4gIG5hbWU6ICdoaWdobGlnaHQnXG59KVxuZXhwb3J0IGNsYXNzIEhpZ2hsaWdodFBpcGUgaW1wbGVtZW50cyBQaXBlVHJhbnNmb3JtIHtcbiAgZG9tU2FuaXRpemVyID0gaW5qZWN0KERvbVNhbml0aXplcik7XG4gIHRyYW5zZm9ybShpbnB1dDogc3RyaW5nLCBzZWFyY2hUZXh0OiBzdHJpbmcpOiBhbnkge1xuICAgIGxldCBpbmRpdmlkdWFsV29yZHMgPSBzZWFyY2hUZXh0Lm1hdGNoKC9cXFMrL2cpO1xuICAgIGluZGl2aWR1YWxXb3Jkcz8uZm9yRWFjaCgod29yZDogc3RyaW5nKSA9PiB7XG4gICAgICBsZXQgcmVnZXggPSBuZXcgUmVnRXhwKFxuICAgICAgICB3b3JkLFxuICAgICAgICAnZ2knXG4gICAgICApO1xuICAgICAgaW5wdXQgPSBpbnB1dC5yZXBsYWNlKHJlZ2V4LCAobWF0Y2g6IHN0cmluZykgPT4ge1xuICAgICAgICByZXR1cm4gYDxtYXJrIGNsYXNzPSdoaWdobGlnaHRlZC1yZXN1bHQgcC0wJz4ke21hdGNofTwvbWFyaz5gO1xuICAgICAgfSk7XG4gICAgfSk7XG4gICAgY29uc3Qgc2FuaXRpemVkID0gdGhpcy5kb21TYW5pdGl6ZXIuc2FuaXRpemUoXG4gICAgICBTZWN1cml0eUNvbnRleHQuSFRNTCxcbiAgICAgIGlucHV0XG4gICAgKSB8fCAnJztcbiAgICByZXR1cm4gc2FuaXRpemVkO1xuICB9XG59XG4iXX0=