import { Injectable, Pipe } from '@angular/core';
import _ from 'lodash-es';
import * as i0 from "@angular/core";
export class OrderByPipe {
    transform(value, orderBy, order = 'asc', customOrder = []) {
        if (customOrder.length > 0) {
            const orderMap = customOrder.reduce((map, value, index) => {
                map[value] = index;
                return map;
            }, {});
            return _.orderBy(value, [item => orderMap[item[orderBy[0]]]], order);
        }
        else {
            return _.orderBy(value, orderBy, order);
        }
    }
    static { this.ɵfac = function OrderByPipe_Factory(__ngFactoryType__) { return new (__ngFactoryType__ || OrderByPipe)(); }; }
    static { this.ɵpipe = /*@__PURE__*/ i0.ɵɵdefinePipe({ name: "orderBy", type: OrderByPipe, pure: true }); }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: OrderByPipe, factory: OrderByPipe.ɵfac, providedIn: 'root' }); }
}
(() => { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(OrderByPipe, [{
        type: Pipe,
        args: [{
                name: 'orderBy'
            }]
    }, {
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], null, null); })();
//# sourceMappingURL=data:application/json;base64,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